/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.AbstractComponentApplication;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import piskorski.util.functions.Files;

public class ApplyComponent {
    private static String applicationName;
    private static String configurationFile;
    private static final String INPUT = "Input";
    private static final String CHARSET = "CharacterSet";
    private static final String OUTPUT = "Output";
    private static String currentCharacterSet;

    static void usage() {
        System.out.println("Usage: ApplyComponent <ApplicationName> <ConfigurationFile>");
        System.out.println("       <ApplicationName> - an application name");
        System.out.println("       <ConfigurationFile> - a path to the configuration file with the settings for the component");
        System.exit(0);
    }

    static void messageExit(String Text) {
        Component.loggerMessage(Text);
        System.exit(0);
    }

    private static boolean readInFileNames(String input, ArrayList<File> files) {
        if (input == null) {
            return false;
        }
        File source = new File(input);
        boolean isFile = source.isFile();
        boolean isDirectory = source.isDirectory();
        if (!isFile && !isDirectory) {
            Component.loggerMessage(input + " is not a file/directory.");
            return false;
        }
        if (!source.canRead()) {
            Component.loggerMessage(input + " can not be read.");
            return false;
        }
        if (isFile) {
            files.add(source);
        } else {
            File[] filesInDirectory = source.listFiles();
            int numFiles = filesInDirectory.length;
            for (int i = 0; i < numFiles; ++i) {
                if (!filesInDirectory[i].isFile() || !filesInDirectory[i].canRead()) continue;
                files.add(new File(filesInDirectory[i].getAbsolutePath()));
            }
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            Component.loggerMessage("Invalid number of arguments");
            ApplyComponent.usage();
        }
        applicationName = args[0];
        configurationFile = args[1];
        Component.loggerMessage("Create an instance of: " + applicationName);
        AbstractComponentApplication application = AbstractComponentApplication.createApplication(applicationName);
        Component.loggerMessage("Read configuration from file: " + configurationFile);
        Configuration configuration = Configuration.initializeFrom(configurationFile);
        Component.loggerMessage("Initialize the instance of: " + applicationName);
        boolean status = application.initialize(configuration);
        if (application.isNull() || !status) {
            ApplyComponent.messageExit("Application named: '" + applicationName + " could not be launched.");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        if (!ApplyComponent.readInFileNames(configuration.getFeature(INPUT), fileList)) {
            ApplyComponent.messageExit("Input data is not specified properly!");
        }
        currentCharacterSet = configuration.getFeature(CHARSET, "UTF-8");
        Component.loggerMessage("Current Characterset is: " + currentCharacterSet);
        String outputDirectory = configuration.getFeature(OUTPUT, "");
        File directory = new File(outputDirectory);
        if (!directory.isDirectory()) {
            ApplyComponent.messageExit(outputDirectory + " is not a directory");
        }
        if (outputDirectory.length() > 1 && outputDirectory.charAt(outputDirectory.length() - 1) != '\\') {
            outputDirectory = outputDirectory + '\\';
        }
        for (File f : fileList) {
            StringBuffer result;
            Component.loggerMessage("Processing file: " + f.getAbsolutePath());
            try {
                String inputText = Files.FileToString(f.getAbsolutePath(), currentCharacterSet);
                result = application.process(inputText);
            }
            catch (IOException e) {
                Component.loggerMessage("Can not access the file: " + f.getAbsolutePath());
                continue;
            }
            catch (Exception e) {
                Component.loggerMessage(e.toString());
                e.printStackTrace();
                continue;
            }
            String outputFile = outputDirectory + f.getName() + ".out";
            Component.loggerMessage("Writing result to the file: " + outputFile);
            try {
                if (Files.StringBufferToFile(outputFile, result, currentCharacterSet)) continue;
                throw new Exception();
            }
            catch (Exception e) {
                Component.loggerMessage("Could not write to the file: " + outputFile);
            }
        }
    }
}

