/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component;

import it.jrc.lt.core.component.ComponentException;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.ConfigurationFeature;
import it.jrc.lt.core.component.Storable;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcher;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import it.jrc.lt.core.component.matcher.AbstractMatcher;
import it.jrc.lt.core.component.morphology.AbstractMorphology;
import it.jrc.lt.core.component.scanner.AbstractScanner;
import it.jrc.lt.core.component.sentencesplitter.AbstractSentenceSplitter;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import piskorski.util.functions.Files;

public abstract class Component
implements Storable {
    protected static Logger logger = Logger.getLogger(Component.class);
    protected String name;
    private static final Component nullComponent = new Component(){

        @Override
        public boolean initialize(Configuration configuration) {
            return Component.loggerMessageAndReturn("NullComponent: Compilation not possible.");
        }

        @Override
        public boolean hasBeenInitialized() {
            return false;
        }

        @Override
        public void readFromStream(DataInputStream d) throws IOException {
            Component.loggerMessageAndReturn("NullComponent: Operation can not be performed.");
        }

        @Override
        public void writeToStream(DataOutputStream d) throws IOException {
            Component.loggerMessageAndReturn("NullComponent: Operation can not be performed.");
        }

        @Override
        protected void applySpecificSettings(Configuration configuration) {
        }

        @Override
        protected List<ConfigurationFeature> getCompilationFeatures() {
            return Collections.EMPTY_LIST;
        }

        @Override
        protected List<ConfigurationFeature> getDeploymentFeatures() {
            return Collections.EMPTY_LIST;
        }

        public boolean isNull() {
            return true;
        }
    };

    protected static void loggerMessageAndExit(String message) throws ComponentException {
        logger.error((Object)message);
        throw new ComponentException(message);
    }

    protected static boolean loggerMessageAndReturn(String message) {
        logger.error((Object)message);
        return false;
    }

    protected static void loggerMessage(String message) {
        logger.info((Object)message);
    }

    protected static void loggerWarning(String message) {
        logger.warn((Object)message);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean saveToFile(String file) {
        if (!this.hasBeenInitialized()) {
            return Component.loggerMessageAndReturn("Trying to save an uninitialized component.");
        }
        byte[] fill = null;
        boolean status = true;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            this.writeToStream(d);
            d.close();
            byteOS.close();
            fill = byteOS.toByteArray();
        }
        catch (IOException e) {
            return Component.loggerMessageAndReturn("Could not write to file: " + file);
        }
        if (status) {
            status = Files.writeByteArrayToFile(fill, file);
        }
        fill = null;
        return status;
    }

    @Override
    public boolean readFromFile(String fileName) {
        byte[] randomAccess = null;
        File file = new File(fileName);
        int size = (int)file.length();
        randomAccess = new byte[size];
        try {
            Files.readByteArrayFromFile(randomAccess, fileName);
            ByteArrayInputStream byteIS = new ByteArrayInputStream(randomAccess);
            DataInputStream d = new DataInputStream(byteIS);
            this.readFromStream(d);
            d.close();
            byteIS.close();
        }
        catch (IOException e) {
            Component.loggerMessageAndReturn("Could not read from file: " + file);
            return false;
        }
        return true;
    }

    public static Component getInstance(String componentType) {
        Creator myCreator = null;
        for (ComponentType cType : ComponentType.values()) {
            if (cType.getName().compareTo(componentType) != 0) continue;
            myCreator = cType.getMyClass();
            break;
        }
        if (myCreator == null) {
            Component.loggerMessage("No such component is available: " + componentType);
        } else {
            try {
                Component myResult = myCreator.getInstance();
                return myResult;
            }
            catch (Exception e) {
                Component.loggerMessage("Can not create an instance of : " + componentType);
                Component.loggerMessage(e.getMessage());
            }
        }
        return nullComponent;
    }

    public static ArrayList<String> getAvailableComponents() {
        ArrayList<String> list = new ArrayList<String>();
        for (ComponentType t : ComponentType.values()) {
            list.add(t.getName());
        }
        return list;
    }

    public abstract boolean hasBeenInitialized();

    protected abstract List<ConfigurationFeature> getCompilationFeatures();

    protected abstract List<ConfigurationFeature> getDeploymentFeatures();

    public boolean compile(Configuration configuration) {
        ArrayList<String> errors = configuration.checkConfiguration(this.getCompilationFeatures());
        if (errors.size() > 0) {
            for (String message : errors) {
                Component.loggerMessage(message);
            }
            return Component.loggerMessageAndReturn("Invalid configuration.");
        }
        return this.initialize(configuration);
    }

    public boolean compile(Configuration configuration, String fileName) {
        if (!this.compile(configuration)) {
            return Component.loggerMessageAndReturn("Compilation error.");
        }
        return this.saveToFile(fileName);
    }

    public boolean applySettings(Configuration configuration) {
        ArrayList<String> errors = configuration.checkConfiguration(this.getDeploymentFeatures());
        if (errors.size() > 0) {
            for (String message : errors) {
                Component.loggerMessage(message);
            }
            return Component.loggerMessageAndReturn("Invalid configuration.");
        }
        this.applySpecificSettings(configuration);
        return true;
    }

    protected abstract void applySpecificSettings(Configuration var1);

    protected abstract boolean initialize(Configuration var1);

    public boolean isNullComponent() {
        return false;
    }

    private static enum ComponentType {
        SENTENCE_SPLITTER("sentenceSplitter", new Creator(){

            @Override
            Component getInstance() {
                return AbstractSentenceSplitter.createInstance("sentenceSplitter");
            }
        }),
        BASIC_SCANNER("basicScanner", new Creator(){

            @Override
            Component getInstance() {
                return AbstractScanner.createInstance("");
            }
        }),
        BASIC_TOKENIZER("basicTokenizer", new Creator(){

            @Override
            Component getInstance() {
                return AbstractTokenizer.createInstance("basicTokenizer");
            }
        }),
        CLASSIFYING_TOKENIZER("classifyingTokenizer", new Creator(){

            @Override
            Component getInstance() {
                return AbstractTokenizer.createInstance("classifyingTokenizer");
            }
        }),
        BASIC_GAZETTEER("basicGazetteer", new Creator(){

            @Override
            Component getInstance() {
                return AbstractGazetteer.createInstance("basicGazetteer");
            }
        }),
        EXTENDED_GAZETTEER("basicGazetteer", new Creator(){

            @Override
            Component getInstance() {
                return AbstractGazetteer.createInstance("extendedGazetteer");
            }
        }),
        BASIC_FLAT_PATTERN_MATCHER("basicFlatPatternMatcher", new Creator(){

            @Override
            Component getInstance() {
                return AbstractFlatPatternMatcher.createInstance("basicFlatPatternMatcher");
            }
        }),
        MULTEXT_MORPHOLOGY("multextMorphology", new Creator(){

            @Override
            Component getInstance() {
                return AbstractMorphology.createInstance("multextMorphology");
            }
        }),
        MULTEXT_MORPHOLOGY_2("multextMorphology2", new Creator(){

            @Override
            Component getInstance() {
                return AbstractMorphology.createInstance("multextMorphology2");
            }
        }),
        BASIC_MATCHER("basicMatcher", new Creator(){

            @Override
            Component getInstance() {
                return AbstractMatcher.createInstance("basicMatcher");
            }
        });

        private final String name;
        private final Creator myClass;

        private ComponentType(String name, Creator myClass) {
            this.name = name;
            this.myClass = myClass;
        }

        public String getName() {
            return this.name;
        }

        public Creator getMyClass() {
            return this.myClass;
        }
    }

    static abstract class Creator {
        Creator() {
        }

        abstract Component getInstance();
    }
}

