/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.Configuration;
import java.util.ArrayList;

public class ComponentCompiler {
    private static String componentName;
    private static String configurationFile;

    static void usage() {
        System.out.println("Usage: CompileComponent <ComponentName>");
        System.out.println("       <ComponentName> - a component name");
        System.out.println("       <CompilerConfigFile> - a path to the configuration file for the component");
        System.out.println("");
        System.out.println("Available components:");
        ArrayList<String> components = Component.getAvailableComponents();
        for (String s : components) {
            System.out.println(" " + s);
        }
        System.exit(0);
    }

    static void messageExit(String Text) {
        System.out.println(Text);
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            Component.loggerMessage("Invalid number of arguments");
            ComponentCompiler.usage();
        }
        componentName = args[0];
        configurationFile = args[1];
        Component.loggerMessage("Create an instance of: " + componentName);
        Component component = Component.getInstance(componentName);
        Component.loggerMessage("Read configuration from file: " + configurationFile);
        Configuration configuration = Configuration.initializeFrom(configurationFile, "UTF-8");
        Component.loggerMessage("Compile resources");
        double startTime = System.currentTimeMillis();
        component.compile(configuration);
        Component.loggerMessage("Write compiled resources to file: " + configuration.getFeature("OutputFile"));
        String fileName = configuration.getFeature("OutputFile");
        component.saveToFile(fileName);
        double endTime = System.currentTimeMillis();
        if (component.hasBeenInitialized()) {
            Component.loggerMessage("Compilation successfull.");
            Component.loggerMessage("Compilation time: " + (endTime - startTime) / 1000.0 + " secs");
        } else {
            Component.loggerMessage("Compilation aborted.");
        }
    }
}

