/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.application;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.AbstractComponentApplication;
import it.jrc.lt.core.component.gazetteer.AbstractDisjunctionOfGazetteerItems;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteerItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;

public class BasicGazetteerApp
extends AbstractComponentApplication {
    private static final String RESOURCE_FILE = "ResourceFile";
    private AbstractGazetteer gazetteer;
    private AbstractTokenizer tokenizer = AbstractTokenizer.createInstance("basicTokenizer");

    @Override
    public boolean initialize(Configuration configuration) {
        this.gazetteer = AbstractGazetteer.createInstance("basicGazetteer");
        boolean status = this.gazetteer.readFromFile(configuration.getFeature(RESOURCE_FILE, ""));
        this.gazetteer.applySettings(configuration);
        return status && !this.gazetteer.isNullComponent() && this.gazetteer.hasBeenInitialized();
    }

    @Override
    public StringBuffer process(String inputText) {
        ArrayList<AbstractTokenItem> tokens = this.tokenizer.tokenize(inputText);
        ArrayList<AbstractDisjunctionOfGazetteerItems> gazetteerItems = this.gazetteer.findMatch(tokens, inputText);
        StringBuffer result = new StringBuffer();
        boolean tokenPositions = this.gazetteer.producesTokenPositions();
        for (AbstractDisjunctionOfGazetteerItems it : gazetteerItems) {
            int numItems = it.getNumberOfItems();
            for (int k = 0; k < numItems; ++k) {
                AbstractGazetteerItem item = it.getItem(k);
                int start = tokenPositions ? tokens.get(item.getStart()).getStart() : item.getStart();
                int end = tokenPositions ? tokens.get(item.getEnd()).getEnd() : item.getEnd();
                result.append(inputText.substring(start, end + 1));
                result.append(" ");
                result.append(item.toString());
                result.append(LINE_SEPARATOR);
            }
            result.append("----------------------------------");
            result.append(LINE_SEPARATOR);
        }
        return result;
    }
}

