/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.application;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.AbstractComponentApplication;
import it.jrc.lt.core.component.morphology.AbstractDisjunctionOfMorphologyItems;
import it.jrc.lt.core.component.morphology.AbstractMorphology;
import it.jrc.lt.core.component.morphology.AbstractMorphologyItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;

public class MultextMorphology2App
extends AbstractComponentApplication {
    private static final String RESOURCE_FILE = "ResourceFile";
    private static final String TOKENIZER_RESOURCE_FILE = "TokenizerResourceFile";
    private AbstractMorphology morphology;
    private AbstractTokenizer tokenizer;

    @Override
    public boolean initialize(Configuration configuration) {
        this.tokenizer = AbstractTokenizer.createInstance("classifyingTokenizer");
        this.tokenizer.readFromFile(configuration.getFeature(TOKENIZER_RESOURCE_FILE, ""));
        if (this.tokenizer.isNullComponent() || !this.tokenizer.hasBeenInitialized()) {
            return false;
        }
        this.morphology = AbstractMorphology.createInstance("multextMorphology2");
        boolean status = this.morphology.readFromFile(configuration.getFeature(RESOURCE_FILE, ""));
        return status && !this.morphology.isNullComponent() && this.morphology.hasBeenInitialized();
    }

    @Override
    public StringBuffer process(String inputText) {
        ArrayList<AbstractTokenItem> tokens = this.tokenizer.tokenize(inputText);
        ArrayList<AbstractDisjunctionOfMorphologyItems> morphologyItems = this.morphology.findMatch(tokens, inputText);
        StringBuffer result = new StringBuffer();
        for (AbstractDisjunctionOfMorphologyItems it : morphologyItems) {
            int numItems = it.getNumberOfItems();
            for (int k = 0; k < numItems; ++k) {
                AbstractMorphologyItem nextItem = it.getItem(k);
                result.append(nextItem.getText(inputText));
                result.append(" ");
                result.append(nextItem.toString());
                result.append(LINE_SEPARATOR);
            }
            result.append("----------------------------------");
            result.append(LINE_SEPARATOR);
        }
        return result;
    }
}

