/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.gazetteer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import piskorski.util.functions.DataStream;

public final class Attribute {
    private final String name;
    private final String[] values;
    private final boolean isOpenClass;

    public String getName() {
        return this.name;
    }

    public boolean isOpenClassAttribute() {
        return this.isOpenClass;
    }

    private Attribute() {
        this.name = null;
        this.values = null;
        this.isOpenClass = false;
    }

    private Attribute(String name, boolean openClassAttribute, ArrayList<String> valueSet) {
        this.name = name;
        this.isOpenClass = openClassAttribute;
        this.values = new String[valueSet.size()];
        int i = 0;
        for (String s : valueSet) {
            this.values[i++] = s;
        }
    }

    private Attribute(String name, boolean openClassAttribute, String[] valueSet) {
        this.name = name;
        this.isOpenClass = openClassAttribute;
        int len = valueSet.length;
        this.values = new String[len];
        System.arraycopy(valueSet, 0, this.values, 0, len);
    }

    private Attribute(Attribute attribute) {
        this.name = attribute.name;
        this.isOpenClass = attribute.isOpenClass;
        int len = attribute.values.length;
        this.values = new String[len];
        System.arraycopy(attribute.values, 0, this.values, 0, len);
    }

    public static Attribute createInstance(String name, boolean openClassAttribute, ArrayList<String> valueSet) {
        return new Attribute(name, openClassAttribute, valueSet);
    }

    public static Attribute createInstance(String name, boolean openClassAttribute, String[] valueSet) {
        return new Attribute(name, openClassAttribute, valueSet);
    }

    public static Attribute createInstance(Attribute attribute) {
        return new Attribute(attribute);
    }

    public void writeToStream(DataOutputStream d) throws IOException {
        DataStream.writeString(d, this.name);
        d.writeBoolean(this.isOpenClass);
        if (!this.isOpenClassAttribute()) {
            DataStream.writeStringArray(d, this.values);
        }
    }

    public static Attribute readFromStream(DataInputStream d) throws IOException {
        String name = DataStream.readString(d);
        boolean isOpenClass = d.readBoolean();
        String[] values = !isOpenClass ? DataStream.readStringArray(d) : new String[]{};
        return Attribute.createInstance(name, isOpenClass, values);
    }

    public int numberOfValues() {
        return this.values.length;
    }

    public String getValue(int i) {
        if (i >= 0 && i < this.values.length) {
            return this.values[i];
        }
        return "";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Attribute: ");
        result.append(this.getName());
        result.append(" open-class: ");
        result.append(this.isOpenClassAttribute());
        result.append(" values: ");
        for (String s : this.values) {
            result.append(s);
            result.append(',');
        }
        return result.toString();
    }
}

