/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.gazetteer;

import it.jrc.lt.core.component.gazetteer.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import piskorski.util.functions.Files;

public class Types {
    public static int UNDEFINED = -1;
    private Type[] myTypes;
    private String attributeEncodingType;
    private HashMap<String, Integer> typeNames;

    private Types() {
        this.myTypes = null;
        this.typeNames = null;
    }

    private Types(ArrayList<Type> types, String attributeEncodingType) {
        int len = types.size();
        this.myTypes = new Type[len];
        this.typeNames = new HashMap();
        for (int i = 0; i < len; ++i) {
            Type t;
            this.myTypes[i] = t = types.get(i);
            this.typeNames.put(t.getName(), i);
        }
        this.attributeEncodingType = attributeEncodingType;
    }

    private Types(Type[] types, String attributeEncodingType) {
        int len = types.length;
        this.myTypes = new Type[len];
        System.arraycopy(types, 0, this.myTypes, 0, len);
        this.typeNames = new HashMap();
        for (int i = 0; i < len; ++i) {
            this.typeNames.put(types[i].getName(), i);
        }
        this.attributeEncodingType = attributeEncodingType;
    }

    private Types(Types types, String attributeEncodingType) {
        int i;
        int len = types.getNumberTypes();
        this.myTypes = new Type[len];
        for (i = 0; i < len; ++i) {
            this.myTypes[i] = types.getType(i);
        }
        this.typeNames = new HashMap();
        for (i = 0; i < len; ++i) {
            this.typeNames.put(types.getType(i).getName(), i);
        }
        this.attributeEncodingType = attributeEncodingType;
    }

    public static Types createInstance(ArrayList<Type> types, String attributeEncodingType) {
        return new Types(types, attributeEncodingType);
    }

    public static Types createInstance(Type[] types, String attributeEncodingType) {
        return new Types(types, attributeEncodingType);
    }

    public static Types createInstance(Types types, String attributeEncodingType) {
        return new Types(types, attributeEncodingType);
    }

    public Type getType(int i) {
        if (i >= 0 && i < this.myTypes.length) {
            return this.myTypes[i];
        }
        return null;
    }

    public int getNumberTypes() {
        return this.myTypes.length;
    }

    public String getAttributeEncodingType() {
        return this.attributeEncodingType;
    }

    public boolean containsType(String name) {
        return this.typeNames.get(name) != null;
    }

    public int typeIndex(String name) {
        Integer index = this.typeNames.get(name);
        return index == null ? UNDEFINED : index;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Attribute encoding type: ");
        result.append(this.attributeEncodingType);
        result.append('\n');
        for (Type t : this.myTypes) {
            result.append(t.toString());
            result.append('\n');
        }
        return result.toString();
    }

    private static Types returnError(StringBuffer errorLog, String message) {
        errorLog.append(message);
        return null;
    }

    public static Types createFromFile(String fileName, String charSet, StringBuffer errorLog) {
        String[] lines = null;
        try {
            lines = Files.FileToStringArray(fileName, charSet);
        }
        catch (Exception e) {
            return Types.returnError(errorLog, "Could not read file: " + fileName);
        }
        if (lines != null && lines.length > 1) {
            String attributeEncodingType = lines[0];
            StringTokenizer sTok = new StringTokenizer(attributeEncodingType, " \t");
            if (sTok.countTokens() > 1) {
                return Types.returnError(errorLog, "Incorrect name of the attribute encoding type in line 0 in file: " + fileName);
            }
            if (attributeEncodingType.length() == 0) {
                return Types.returnError(errorLog, "Missing name of the attribute encoding type in line 0 in file: " + fileName);
            }
            int numTypes = lines.length - 1;
            Type[] myTypes = new Type[numTypes];
            HashSet<String> newTypes = new HashSet<String>();
            for (int i = 1; i <= numTypes; ++i) {
                int j;
                sTok = new StringTokenizer(lines[i], " \t");
                int numTokens = sTok.countTokens();
                if (numTokens < 2) {
                    return Types.returnError(errorLog, "Definition of type in line: " + i + " in file " + fileName + " is incorrect.");
                }
                String typeName = sTok.nextToken();
                if (newTypes.contains(typeName)) {
                    return Types.returnError(errorLog, "Type " + typeName + " declared for the second time in line " + i + " in file: " + fileName);
                }
                newTypes.add(typeName);
                String[] attributes = new String[numTokens - 1];
                HashSet<String> newAttributes = new HashSet<String>();
                for (j = 1; j < numTokens; ++j) {
                    attributes[j - 1] = sTok.nextToken();
                }
                for (j = 0; j < numTokens - 1; ++j) {
                    if (newAttributes.contains(attributes[j])) {
                        return Types.returnError(errorLog, "Attribute " + attributes[j] + " declared twice in line " + i + " in file: " + fileName + "\n");
                    }
                    newAttributes.add(attributes[j]);
                }
                myTypes[i - 1] = Type.createInstance(typeName, attributes);
            }
            return Types.createInstance(myTypes, attributeEncodingType);
        }
        return Types.returnError(errorLog, "Problems encountered while reading file: " + fileName);
    }
}

