/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.morphology;

import it.jrc.lt.core.component.gazetteer.GazetteerException;
import it.jrc.lt.core.component.morphology.AbstractDisjunctionOfMorphologyItems;
import it.jrc.lt.core.component.morphology.AbstractMorphology;
import it.jrc.lt.core.component.morphology.AbstractMorphologyItem;
import it.jrc.lt.core.component.morphology.LanguageSpecificTreatment;
import it.jrc.lt.core.component.morphology.MultextMorphologyItem;
import it.jrc.lt.core.component.morphology.MultextPartOfSpeech;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import java.util.ArrayList;
import piskorski.util.strings.StringFunctions;

final class ItalianSpecificTreatment
extends LanguageSpecificTreatment {
    AbstractMorphology morphology;
    private static final char[] apostrophees = new char[]{'\'', '\u2019', '\u02c8', '\u00b4', '`', '\u2018', '\u2010', '\u02bb'};
    private static final byte WORD_WITH_APOSTROPHEE_LOWERCASE = 27;
    private static final byte WORD_WITH_APOSTROPHEE_UPERCASE = 26;
    private static final int NOUN_TYPE = MultextPartOfSpeech.NOUN.getTagIndex("Type");
    private static final int NOUN_GENDER = MultextPartOfSpeech.NOUN.getTagIndex("Gender");
    private static final int NOUN_NUMBER = MultextPartOfSpeech.NOUN.getTagIndex("Number");
    private static final int ADJ_GENDER = MultextPartOfSpeech.ADJECTIVE.getTagIndex("Gender");
    private static final int ADJ_NUMBER = MultextPartOfSpeech.ADJECTIVE.getTagIndex("Number");
    private static final int ART_GENDER = MultextPartOfSpeech.ARTICLE.getTagIndex("Gender");
    private static final int ART_NUMBER = MultextPartOfSpeech.ARTICLE.getTagIndex("Number");
    private static final int DET_GENDER = MultextPartOfSpeech.DETERMINER.getTagIndex("Gender");
    private static final int DET_NUMBER = MultextPartOfSpeech.DETERMINER.getTagIndex("Number");
    private static final int DET_PERSON = MultextPartOfSpeech.DETERMINER.getTagIndex("Person");
    private static final int ADV_DEGREE = MultextPartOfSpeech.ADVERB.getTagIndex("Degree");
    private static final int ADP_TYPE = MultextPartOfSpeech.ADPOSITION.getTagIndex("Type");

    protected ItalianSpecificTreatment(AbstractMorphology morphology) throws GazetteerException {
        this.morphology = morphology;
    }

    @Override
    protected boolean hasBeenInitialized() {
        return this.morphology != null;
    }

    @Override
    int process(ArrayList<AbstractDisjunctionOfMorphologyItems> returnList, ArrayList<AbstractTokenItem> tokens, int position, char[] inputText) {
        AbstractTokenItem currentToken = tokens.get(position);
        String currentWord = currentToken.getText(inputText);
        returnList.clear();
        switch (currentToken.getType()) {
            case 26: 
            case 27: {
                AbstractDisjunctionOfMorphologyItems restM;
                int apIndex = StringFunctions.findIndexOf(currentWord, apostrophees);
                if (apIndex == -1) break;
                String first = currentWord.substring(0, apIndex + 1);
                String rest = currentWord.substring(apIndex + 1);
                int start1 = currentToken.getStart();
                int end1 = start1 + apIndex;
                int start2 = end1 + 1;
                int end2 = currentToken.getEnd();
                AbstractDisjunctionOfMorphologyItems firstM = this.morphology.search(first.toLowerCase());
                if (firstM == null) {
                    firstM = this.morphology.search(first.toLowerCase());
                }
                if ((restM = this.morphology.search(rest)) == null) {
                    restM = this.morphology.search(rest.toLowerCase());
                }
                int numInterFirst = firstM != null ? firstM.getNumberOfItems() : 0;
                int numInterRest = restM != null ? restM.getNumberOfItems() : 0;
                ArrayList<AbstractMorphologyItem> returnListForFirst = new ArrayList<AbstractMorphologyItem>();
                ArrayList<AbstractMorphologyItem> returnListForRest = new ArrayList<AbstractMorphologyItem>();
                if (numInterFirst > 0) {
                    if (numInterRest > 0) {
                        for (int i = 0; i < numInterFirst; ++i) {
                            AbstractMorphologyItem firstMorph = firstM.getItem(i);
                            for (int j = 0; j < numInterRest; ++j) {
                                AbstractMorphologyItem restMorph = restM.getItem(j);
                                returnListForFirst.add(new MultextMorphologyItem(start1, end1, firstMorph.getPos(), firstMorph.getLemma(), firstMorph.getTags()));
                                returnListForRest.add(new MultextMorphologyItem(start2, end2, restMorph.getPos(), restMorph.getLemma(), restMorph.getTags()));
                            }
                        }
                    } else {
                        block13: for (int i = 0; i < numInterFirst; ++i) {
                            AbstractMorphologyItem firstMorph = firstM.getItem(i);
                            char pos = firstMorph.getPos();
                            switch (pos) {
                                case 'A': {
                                    char[] tags = new char[]{Character.isLowerCase(rest.charAt(0)) ? (char)'c' : 'p', firstMorph.getTag(ADJ_GENDER), firstMorph.getTag(ADJ_NUMBER)};
                                    returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.ADJECTIVE.getCode(), firstMorph.getLemma(), firstMorph.getTags()));
                                    returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.NOUN.getCode(), rest, new String(tags)));
                                    continue block13;
                                }
                                case 'T': {
                                    char[] tags = new char[]{Character.isLowerCase(rest.charAt(0)) ? (char)'c' : 'p', firstMorph.getTag(ART_GENDER), firstMorph.getTag(ART_NUMBER)};
                                    returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.ARTICLE.getCode(), firstMorph.getLemma(), firstMorph.getTags()));
                                    returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.NOUN.getCode(), rest, new String(tags)));
                                    continue block13;
                                }
                                case 'D': {
                                    char[] tags = new char[]{Character.isLowerCase(rest.charAt(0)) ? (char)'c' : 'p', firstMorph.getTag(DET_GENDER), firstMorph.getTag(DET_NUMBER)};
                                    returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.ARTICLE.getCode(), firstMorph.getLemma(), tags));
                                    returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.NOUN.getCode(), rest, new String(tags)));
                                    continue block13;
                                }
                                case 'S': {
                                    if (firstMorph.getTag(ADP_TYPE) != 'p') continue block13;
                                    returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.ADPOSITION.getCode(), firstMorph.getLemma(), firstMorph.getTags()));
                                    returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.NOUN.getCode(), rest, "-"));
                                    continue block13;
                                }
                                case 'P': {
                                    returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.PRONOUN.getCode(), firstMorph.getLemma(), firstMorph.getTags()));
                                    returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.VERB.getCode(), rest, "-"));
                                    continue block13;
                                }
                                case 'R': {
                                    if (firstMorph.getTag(ADV_DEGREE) != 'p') continue block13;
                                    returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.ADVERB.getCode(), firstMorph.getLemma(), firstMorph.getTags()));
                                    returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.VERB.getCode(), rest, "-"));
                                    continue block13;
                                }
                            }
                        }
                    }
                } else if (rest.length() > 1) {
                    for (int i = 0; i < numInterRest; ++i) {
                        AbstractMorphologyItem restMorph = restM.getItem(i);
                        if (restMorph.getPos() != MultextPartOfSpeech.NOUN.getCode()) continue;
                        char[] tags = new char[]{'-', '-', restMorph.getTag(NOUN_GENDER), restMorph.getTag(NOUN_NUMBER)};
                        returnListForFirst.add(new MultextMorphologyItem(start1, end1, MultextPartOfSpeech.ADJECTIVE.getCode(), first, new String(tags)));
                        returnListForRest.add(new MultextMorphologyItem(start2, end2, MultextPartOfSpeech.NOUN.getCode(), restMorph.getLemma(), restMorph.getTags()));
                    }
                }
                if (returnListForFirst.size() <= 0) break;
                returnList.add(new AbstractDisjunctionOfMorphologyItems(returnListForFirst));
                returnList.add(new AbstractDisjunctionOfMorphologyItems(returnListForRest));
                break;
            }
        }
        return position;
    }
}

