/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.morphology;

import it.jrc.lt.core.component.gazetteer.GazetteerException;
import it.jrc.lt.core.component.morphology.AbstractDisjunctionOfMorphologyItems;
import it.jrc.lt.core.component.morphology.AbstractMorphology;
import it.jrc.lt.core.component.morphology.EnglishSpecificTreatment;
import it.jrc.lt.core.component.morphology.ItalianSpecificTreatment;
import it.jrc.lt.core.component.morphology.Language;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import java.util.ArrayList;

abstract class LanguageSpecificTreatment {
    private static final LanguageSpecificTreatment nullTreatment = new LanguageSpecificTreatment(){

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public int process(ArrayList<AbstractDisjunctionOfMorphologyItems> returnResult, ArrayList<AbstractTokenItem> tokens, int position, char[] text) {
            return position;
        }

        @Override
        public boolean hasBeenInitialized() {
            return true;
        }
    };

    static LanguageSpecificTreatment createInstance(String name, AbstractMorphology myMorphology) {
        LanguageSpecificTreatment newInstance = null;
        if (name != null) {
            try {
                if (name.compareTo(Language.ENGLISH.getName()) == 0) {
                    newInstance = new EnglishSpecificTreatment(myMorphology);
                }
                if (name.compareTo(Language.ITALIAN.getName()) == 0) {
                    newInstance = new ItalianSpecificTreatment(myMorphology);
                }
                if (newInstance != null && !newInstance.hasBeenInitialized()) {
                    newInstance = null;
                }
            }
            catch (GazetteerException gazetteerException) {
                // empty catch block
            }
        }
        return newInstance != null ? newInstance : nullTreatment;
    }

    abstract int process(ArrayList<AbstractDisjunctionOfMorphologyItems> var1, ArrayList<AbstractTokenItem> var2, int var3, char[] var4);

    public boolean isNull() {
        return false;
    }

    protected LanguageSpecificTreatment() {
    }

    protected abstract boolean hasBeenInitialized();
}

