/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.morphology;

import it.jrc.lt.core.component.morphology.AbstractMorphology;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import piskorski.util.functions.Files;

public class MultextMorphologyTest {
    private AbstractMorphology myInstance;
    private String[] myEntries;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.myInstance = AbstractMorphology.createInstance("multextMorphology");
        this.myInstance.readFromFile("data/morphology/EN/Multext_Morphology_EN.mor");
        this.myInstance.switchOnCaseSensitiveMode();
        this.myEntries = Files.FileToStringArray("data/morphology/EN/Multext_Resources_Enhanced_EN.txt", "UTF-8");
        if (this.myEntries != null) {
            for (int i = 0; i < this.myEntries.length; ++i) {
                int where = this.myEntries[i].indexOf("\t");
                this.myEntries[i] = this.myEntries[i].substring(0, where).trim();
            }
        }
    }

    @Test
    public void testSearchString() {
        Assert.assertTrue((String)"Could not instantiate the morphology.", (!this.myInstance.isNullComponent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Could not read morphology resources from file.", (boolean)this.myInstance.hasBeenInitialized());
        Assert.assertTrue((String)"Could not read entries. ", (this.myEntries != null ? 1 : 0) != 0);
        for (int i = 0; i < this.myEntries.length; ++i) {
            Assert.assertTrue((String)("Look-up for: " + this.myEntries[i] + " has failed."), (this.myInstance.search(this.myEntries[i]) != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Found: 1234567890 in morphological lexicon.", (this.myInstance.search("1234567890") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found: ---1234567890 in morphological lexicon.", (this.myInstance.search("---1234567890") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found: **** in morphological lexicon.", (this.myInstance.search("****") == null ? 1 : 0) != 0);
    }
}

