/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.sentencesplitter;

import it.jrc.lt.core.component.sentencesplitter.AbstractSentenceItem;
import it.jrc.lt.core.component.sentencesplitter.AbstractSentenceSplitter;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleSentenceSplitterTest {
    private AbstractSentenceSplitter myInstance;
    private AbstractTokenizer myTokenizer;
    private String myText1 = "This is a sentence. And this is the second sentence. This is a thrid sentence";
    private String myText2 = "One";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.myInstance = AbstractSentenceSplitter.createInstance("sentenceSplitter");
        this.myInstance.readFromFile("data/sentenceSplitter/EN/Sentence_Splitter_EN.ssb");
        this.myTokenizer = AbstractTokenizer.createInstance("classifyingTokenizer");
        this.myTokenizer.readFromFile("data/tokenizer/EN/ClassifyingTokenizer_EN.tok");
    }

    @Test
    public void testSegmentCharArrayArrayListOfAbstractTokenItem() {
        Assert.assertTrue((String)"Could not instantiate the tokenizer.", (!this.myTokenizer.isNullComponent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Could not read tokenizer resources from file.", (boolean)this.myTokenizer.hasBeenInitialized());
        Assert.assertTrue((String)"Could not instantiate the sentence splitter.", (!this.myInstance.isNullComponent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Could not read sentence splitter resources from file.", (boolean)this.myInstance.hasBeenInitialized());
        ArrayList<AbstractTokenItem> tokens = this.myTokenizer.tokenize(this.myText1);
        ArrayList<AbstractSentenceItem> sentenceItems = this.myInstance.segment(this.myText1, tokens);
        Assert.assertTrue((String)"Sentence splitter returns NULL", (sentenceItems != null ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)sentenceItems.size());
        tokens = this.myTokenizer.tokenize(this.myText2);
        sentenceItems = this.myInstance.segment(this.myText2, tokens);
        Assert.assertTrue((String)"Sentence splitter returns NULL", (sentenceItems != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)sentenceItems.size());
    }
}

