/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.tokenizer;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.ConfigurationFeature;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import piskorski.util.functions.DataStream;

final class BasicTokenizer
extends AbstractTokenizer {
    private boolean[] isWhiteSpace;
    private boolean[] isTokenSeparator = new boolean[65536];
    private static final String defaultWhitespaces = "\t\f\n\r ";
    private static final String defaultTokenSeparators = "\"\\',`.:;{}[]()~*!$<+@#>?/%^&-|\u201d\u201c\u2019\u2014\u2018\u00a3\u00a5\u00a2\u20ac\u00a9\u00b4\u02b9\u02bb\u02bc\u02bd\u02ca\u02cb\u02ba\u02dc\u02dd\u00ab\u00bb";
    private static final String defaultName = "DefaultBasicTokenizer";
    private static final transient String className = "[" + BasicTokenizer.class.getSimpleName() + "] ";
    private static final transient int MAX_CHAR = 65536;

    protected BasicTokenizer() {
        this.isWhiteSpace = new boolean[65536];
        this.name = defaultName;
        this.initIsArrays(defaultWhitespaces, defaultTokenSeparators);
    }

    private void initIsArrays(String whitespaces, String separators) {
        int i;
        Arrays.fill(this.isWhiteSpace, false);
        Arrays.fill(this.isTokenSeparator, false);
        int len = separators.length();
        for (i = 0; i < len; ++i) {
            this.isTokenSeparator[separators.charAt((int)i)] = true;
        }
        len = whitespaces.length();
        for (i = 0; i < len; ++i) {
            this.isWhiteSpace[whitespaces.charAt((int)i)] = true;
        }
    }

    @Override
    public boolean hasBeenInitialized() {
        if (this.isTokenSeparator == null) {
            return false;
        }
        if (this.isWhiteSpace == null) {
            return false;
        }
        return this.getName() != null;
    }

    @Override
    public void writeToStream(DataOutputStream d) throws IOException {
        DataStream.writeBooleanArray(d, this.isWhiteSpace);
        DataStream.writeBooleanArray(d, this.isTokenSeparator);
        DataStream.writeString(d, this.getName());
    }

    @Override
    public void readFromStream(DataInputStream d) throws IOException {
        this.isWhiteSpace = DataStream.readBooleanArray(d);
        this.isTokenSeparator = DataStream.readBooleanArray(d);
        this.setName(DataStream.readString(d));
    }

    @Override
    protected List<ConfigurationFeature> getCompilationFeatures() {
        return Collections.unmodifiableList(Arrays.asList(CompilationFeatures.FEATURES));
    }

    @Override
    protected List<ConfigurationFeature> getDeploymentFeatures() {
        return Collections.unmodifiableList(Arrays.asList(DeploymentFeatures.FEATURES));
    }

    @Override
    protected boolean initialize(Configuration configuration) {
        try {
            String tokenSeparators;
            String whitespaces = configuration.getFeature(CompilationFeatures.WHITESPACES.getName(), "");
            if (whitespaces.length() == 0) {
                whitespaces = defaultWhitespaces;
                Component.loggerMessage(className + "Missing or invalid value of the feature: " + CompilationFeatures.WHITESPACES.getName() + ". Default settings will be used.");
            }
            if ((tokenSeparators = configuration.getFeature(CompilationFeatures.TOKEN_SEPARATORS.getName(), "")).length() == 0) {
                tokenSeparators = defaultTokenSeparators;
                Component.loggerMessage(className + "Missing or invalid value of the feature: " + CompilationFeatures.TOKEN_SEPARATORS.getName() + ". Default settings will be used.");
            }
            this.initIsArrays(whitespaces, tokenSeparators);
            String name = configuration.getFeature(CompilationFeatures.NAME.getName(), "");
            if (name.length() == 0) {
                Component.loggerMessage(className + "Missing feature: " + CompilationFeatures.NAME.getName());
                return false;
            }
            this.setName(name);
        }
        catch (Exception e) {
            Component.loggerMessage(className + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Map<Byte, String> getTypeNames() {
        return Collections.unmodifiableMap(TokenType.types);
    }

    @Override
    public ArrayList<AbstractTokenItem> tokenize(char[] inputText) {
        int current;
        int len = inputText.length;
        ArrayList<AbstractTokenItem> tokens = new ArrayList<AbstractTokenItem>(len / 5 + 1);
        int start = 0;
        boolean returnsWhitespaces = this.producesWhitespaceTokens();
        boolean intoken = false;
        for (current = 0; current < len; ++current) {
            char nextSymbol = inputText[current];
            if (this.isWhiteSpace[nextSymbol] || this.isTokenSeparator[nextSymbol]) {
                if (intoken) {
                    tokens.add(new BasicTokenItem(start, current - 1, false, TokenType.NON_WHITESPACE.getCode()));
                    intoken = false;
                }
                if (this.isTokenSeparator[nextSymbol]) {
                    tokens.add(new BasicTokenItem(current, current, false, TokenType.NON_WHITESPACE.getCode()));
                    continue;
                }
                if (!returnsWhitespaces) continue;
                start = current;
                while (current < len && this.isWhiteSpace[inputText[current]]) {
                    ++current;
                }
                tokens.add(new BasicTokenItem(start, --current, true, TokenType.WHITESPACE.getCode()));
                continue;
            }
            if (intoken) continue;
            start = current;
            intoken = true;
        }
        if (intoken) {
            tokens.add(new BasicTokenItem(start, current - 1, false, TokenType.NON_WHITESPACE.getCode()));
        }
        return tokens;
    }

    @Override
    protected void applySpecificSettings(Configuration configuration) {
        if (configuration.getFeature(DeploymentFeatures.WHITESPACE_TOKENS.getName()).compareTo("true") == 0) {
            this.produceWhitespaceTokens();
        }
    }

    private final class BasicTokenItem
    extends AbstractTokenItem {
        private byte type;

        @Override
        public byte getType() {
            return this.type;
        }

        @Override
        protected String getType(byte type) {
            return TokenType.types.get(type);
        }

        @Override
        protected void setType(byte type) {
            this.type = type;
        }

        BasicTokenItem(int start, int end, boolean isWhitespace, byte type) {
            super(start, end, isWhitespace, type);
        }

        @Override
        public String toString() {
            return "[" + this.getStart() + "," + this.getEnd() + "," + this.getTypeAsString() + "," + this.isWhiteSpace() + "]";
        }
    }

    private static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType WHITESPACE;
        public static final /* enum */ TokenType NON_WHITESPACE;
        private final byte code;
        private final String description;
        static final HashMap<Byte, String> types;
        private static final /* synthetic */ TokenType[] $VALUES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        public static TokenType valueOf(String name) {
            return Enum.valueOf(TokenType.class, name);
        }

        private TokenType(byte code, String description) {
            this.code = code;
            this.description = description;
        }

        byte getCode() {
            return this.code;
        }

        String getDescription() {
            return this.description;
        }

        static {
            TokenType[] myTypes;
            WHITESPACE = new TokenType(0, "whitespace");
            NON_WHITESPACE = new TokenType(1, "non-whitespace");
            $VALUES = new TokenType[]{WHITESPACE, NON_WHITESPACE};
            types = new HashMap();
            for (TokenType t : myTypes = TokenType.values()) {
                types.put(t.getCode(), t.getDescription());
            }
        }
    }

    private static final class DeploymentFeatures {
        static final ConfigurationFeature CHARACTER_SET = ConfigurationFeature.createFeature("CharacterSet", false, "UTF-8");
        static final ConfigurationFeature WHITESPACE_TOKENS = ConfigurationFeature.createFeature("WhitespaceTokens", false, "false");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{CHARACTER_SET, WHITESPACE_TOKENS};

        private DeploymentFeatures() {
        }
    }

    private static final class CompilationFeatures {
        static final ConfigurationFeature WHITESPACES = ConfigurationFeature.createFeature("Whitespaces", false, "");
        static final ConfigurationFeature TOKEN_SEPARATORS = ConfigurationFeature.createFeature("TokenSeparators", false, "");
        static final ConfigurationFeature NAME = ConfigurationFeature.createFeature("Name", true, "");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{WHITESPACES, TOKEN_SEPARATORS};

        private CompilationFeatures() {
        }
    }
}

