/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSAImpl_1xx;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSAImpl_2;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA_Impl_TransMatrix;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA_Impl_TransMatrixCompressed;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;
import piskorski.util.arraylist.CharacterArrayList;

public abstract class DictionaryLetterFSA {
    public abstract int getNumberOfTransitions();

    public abstract int getNumberOfStates();

    public abstract CharacterArrayList getAlphabet();

    public abstract State getInitialState();

    public abstract void initializeFrom(LetterFSAInterface var1);

    public abstract boolean saveToFile(String var1);

    public abstract boolean readFromFile(String var1);

    public abstract boolean writeToByteBuffer(ByteBuffer var1);

    public abstract boolean writeToDataOutputStream(DataOutputStream var1) throws IOException;

    public abstract boolean readFromDataInputStream(DataInputStream var1) throws IOException;

    public abstract boolean readFromByteBuffer(ByteBuffer var1);

    public static DictionaryLetterFSA getInstance(String type) {
        if (type.compareTo("BASIC") == 0) {
            return new DictionaryLetterFSAImpl_1xx();
        }
        if (type.compareTo("BASIC_RA") == 0) {
            return new DictionaryLetterFSAImpl_2();
        }
        if (type.compareTo("TRANS_MATRIX") == 0) {
            return new DictionaryLetterFSA_Impl_TransMatrix();
        }
        if (type.compareTo("TRANS_MATRIX_COMPRESSED") == 0) {
            return new DictionaryLetterFSA_Impl_TransMatrixCompressed();
        }
        return null;
    }

    public static interface Transition {
        public State getTargetState();

        public char getLabel();

        public boolean pointsToFinalState();
    }

    public static interface State {
        public Transition getFirstTransition();

        public Transition getNextTransition(Transition var1);

        public Transition getTransitionLabelledWith(char var1);
    }
}

