/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.FSAAuxilliaryFunctions;
import piskorski.fs.letterfs.fsa.FiniteStateProcessingException;
import piskorski.fs.letterfs.fsa.InOutDegree;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.functions.Arithmetic;
import piskorski.util.functions.Files;
import piskorski.util.functions.Memory;

public class DictionaryLetterFSAImpl_1x
extends DictionaryLetterFSA {
    private int numTransitions;
    private int numStates;
    private char[] alphabet;
    protected byte[] transitions;
    private int transitionSize;
    private int nextTransitionInfoOffset;
    private short nextTransitionInfoFLAG;
    private int lastTransitionInfoOffset;
    private short lastTransitionInfoFLAG;
    private int isFinalTransitionOffset;
    private short isFinalTransitionFLAG;
    private int pointsToSentinelOffset;
    private short pointsToSentinelFLAG;
    private int labelBytes;
    private int labelFLAG;
    private int jumpTransitionOffset;
    private int jumpTransitionNumBytes;
    private HashMap<Character, Integer> charEnc;
    private HashMap<Character, DictionaryLetterFSA.Transition> targetTransForInitState;
    private transient DictionaryLetterFSA.State initialState = new State(0);

    private void constructTransTableForInitialState() {
        this.targetTransForInitState = new HashMap();
        DictionaryLetterFSA.State initState = this.getInitialState();
        DictionaryLetterFSA.Transition transition = initState.getFirstTransition();
        while (transition != null) {
            this.targetTransForInitState.put(Character.valueOf(transition.getLabel()), transition);
            transition = initState.getNextTransition(transition);
        }
    }

    @Override
    public int getNumberOfTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumberOfStates() {
        return this.numStates;
    }

    @Override
    public CharacterArrayList getAlphabet() {
        CharacterArrayList result = new CharacterArrayList();
        for (int i = 0; i < this.alphabet.length; ++i) {
            result.add(this.alphabet[i]);
        }
        return result;
    }

    @Override
    public DictionaryLetterFSA.State getInitialState() {
        return this.initialState;
    }

    public void initializeFromX(LetterFSAInterface A) throws FiniteStateProcessingException {
        int currentByte = 0;
        int currentBit = 0;
        this.numStates = A.getNumberOfStates();
        this.numTransitions = A.getNumberOfTransitions();
        CharacterArrayList Alphabet = A.getAlphabet();
        int alphabetSize = Alphabet.size();
        this.alphabet = new char[alphabetSize];
        this.charEnc = new HashMap();
        for (int i = 0; i < alphabetSize; ++i) {
            char symbol = Alphabet.get(i);
            this.charEnc.put(Character.valueOf(symbol), i);
            this.alphabet[i] = symbol;
        }
        int howManyBits = Memory.howManyBits(alphabetSize);
        if (howManyBits > 8) {
            this.labelBytes = 2;
            this.labelFLAG = ~(-1 << howManyBits - 8);
            currentBit = howManyBits - 8;
            currentByte = 1;
        } else {
            this.labelBytes = 1;
            this.labelFLAG = ~(-1 << howManyBits);
            currentBit = howManyBits;
        }
        if (++currentBit > 8) {
            currentBit = 1;
            ++currentByte;
        }
        this.nextTransitionInfoOffset = currentByte++;
        this.nextTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.lastTransitionInfoOffset = currentByte++;
        this.lastTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.isFinalTransitionOffset = currentByte++;
        this.isFinalTransitionFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.pointsToSentinelOffset = currentByte;
        this.pointsToSentinelFLAG = (short)(1 << currentBit - 1);
        IntArrayList states = A.getStates();
        int maxIndex = 0;
        int max = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            if (states.get(i) <= max) continue;
            maxIndex = i;
        }
        int[] adressInTransitionArray = new int[++maxIndex];
        boolean[] sequentialState = new boolean[maxIndex];
        Arrays.fill(adressInTransitionArray, 0);
        Arrays.fill(sequentialState, false);
        InOutDegree[] InOut = FSAAuxilliaryFunctions.inOutDegree(A);
        int numberSequentialStates = 0;
        for (int i = 0; i < states.size(); ++i) {
            int nextState = states.get(i);
            if (InOut[nextState].getInDegree() != 1 || InOut[nextState].getOutDegree() != 1 || A.getTransitions(nextState).getTarget(0) == nextState) continue;
            sequentialState[nextState] = true;
            ++numberSequentialStates;
        }
        int howManyBytesForTransitions = this.computNumberOfBytesForTransitionArray(this.numTransitions, currentByte + 1, numberSequentialStates);
        int howmanyBitsforTransitionIndex = Memory.howManyBits(howManyBytesForTransitions);
        this.jumpTransitionNumBytes = howmanyBitsforTransitionIndex / 8;
        if (howmanyBitsforTransitionIndex % 8 != 0) {
            ++this.jumpTransitionNumBytes;
        }
        this.transitionSize = ++currentByte + this.jumpTransitionNumBytes;
        this.jumpTransitionOffset = currentByte;
        byte[] tempTransitions = new byte[howManyBytesForTransitions + 1];
        Arrays.fill(tempTransitions, (byte)0);
        boolean[] visited = new boolean[maxIndex];
        Arrays.fill(visited, false);
        boolean[] alreadyInToBeProcessed = new boolean[maxIndex];
        Arrays.fill(alreadyInToBeProcessed, false);
        IntArrayList statesToBeProcessed = new IntArrayList(this.numStates / 2);
        statesToBeProcessed.add(A.getInitialState());
        currentByte = 0;
        int countT = 0;
        while (!statesToBeProcessed.empty()) {
            boolean isFinal;
            int consumedBytes;
            TransitionArrayList newTransitions;
            int nextState = statesToBeProcessed.removeLast();
            visited[nextState] = true;
            adressInTransitionArray[nextState] = currentByte;
            if (sequentialState[nextState]) {
                newTransitions = A.getTransitions(nextState);
                int targetState = newTransitions.getTarget(0);
                boolean isFinal2 = A.isFinalState(targetState);
                boolean isNext = true;
                boolean pointsToSentinel = false;
                if (InOut[targetState].getOutDegree() == 0) {
                    isNext = false;
                    pointsToSentinel = true;
                } else if (visited[targetState]) {
                    isNext = false;
                } else if (!alreadyInToBeProcessed[targetState]) {
                    statesToBeProcessed.add(targetState);
                    alreadyInToBeProcessed[targetState] = true;
                }
                Integer charI = this.charEnc.get(Character.valueOf(newTransitions.getSymbol(0)));
                int charIndex = charI != null ? charI : -1;
                consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, isNext, isFinal2, pointsToSentinel, targetState);
                ++countT;
                currentByte += consumedBytes;
                continue;
            }
            newTransitions = A.getTransitions(nextState);
            boolean foundOneNotVisited = false;
            int whichIsNotVisited = 0;
            for (int j = 0; j < newTransitions.size(); ++j) {
                int charIndex;
                Integer charI;
                boolean pointsToSentinel;
                int targetState = newTransitions.getTarget(j);
                boolean bl = pointsToSentinel = InOut[targetState].getOutDegree() == 0;
                if (!visited[targetState]) {
                    if (!foundOneNotVisited && !pointsToSentinel) {
                        foundOneNotVisited = true;
                        whichIsNotVisited = j;
                        continue;
                    }
                    if (!pointsToSentinel && !alreadyInToBeProcessed[targetState]) {
                        statesToBeProcessed.add(targetState);
                        alreadyInToBeProcessed[targetState] = true;
                    }
                }
                char label = newTransitions.getSymbol(j);
                isFinal = A.isFinalState(targetState);
                if (j == newTransitions.size() - 1 && !foundOneNotVisited) {
                    charI = this.charEnc.get(Character.valueOf(label));
                    charIndex = charI != null ? charI : -1;
                    consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, false, isFinal, pointsToSentinel, targetState);
                } else {
                    charI = this.charEnc.get(Character.valueOf(label));
                    charIndex = charI != null ? charI : -1;
                    consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, false, false, isFinal, pointsToSentinel, targetState);
                }
                ++countT;
                currentByte += consumedBytes;
            }
            if (!foundOneNotVisited) continue;
            int targetState = newTransitions.getTarget(whichIsNotVisited);
            isFinal = A.isFinalState(targetState);
            Integer charI = this.charEnc.get(Character.valueOf(newTransitions.getSymbol(whichIsNotVisited)));
            int charIndex = charI != null ? charI : -1;
            consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, true, isFinal, false, 0);
            ++countT;
            currentByte += consumedBytes;
            if (!alreadyInToBeProcessed[targetState]) {
                statesToBeProcessed.add(targetState);
                alreadyInToBeProcessed[targetState] = true;
                continue;
            }
            throw new FiniteStateProcessingException("some problem while processing fsa");
        }
        this.transitions = new byte[currentByte];
        System.arraycopy(tempTransitions, 0, this.transitions, 0, this.transitions.length);
        currentByte = 0;
        int[] how_many_pointers_local = new int[]{0, 0, 0, 0};
        int how_many_next = 0;
        while (currentByte < this.transitions.length) {
            boolean pointsToSentinel;
            boolean isNext = (this.transitions[currentByte + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean bl = pointsToSentinel = (this.transitions[currentByte + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            if (isNext || pointsToSentinel) {
                currentByte += this.jumpTransitionOffset;
                ++how_many_next;
                continue;
            }
            int address = Memory.convertByteArrayToInt(this.transitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            if (Math.abs(adressInTransitionArray[address] - currentByte) < 256) {
                how_many_pointers_local[0] = how_many_pointers_local[0] + 1;
            } else if (Math.abs(adressInTransitionArray[address] - currentByte) < 65536) {
                how_many_pointers_local[1] = how_many_pointers_local[1] + 1;
            } else if (Math.abs(adressInTransitionArray[address] - currentByte) < 0x1000000) {
                how_many_pointers_local[2] = how_many_pointers_local[2] + 1;
            } else {
                how_many_pointers_local[3] = how_many_pointers_local[3] + 1;
            }
            Memory.convertIntToByteArray(adressInTransitionArray[address], this.transitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            currentByte += this.transitionSize;
        }
        adressInTransitionArray = null;
        sequentialState = null;
        tempTransitions = null;
        visited = null;
        statesToBeProcessed = null;
        this.constructTransTableForInitialState();
    }

    @Override
    public void initializeFrom(LetterFSAInterface A) {
        int currentByte = 0;
        int currentBit = 0;
        this.numStates = A.getNumberOfStates();
        this.numTransitions = A.getNumberOfTransitions();
        CharacterArrayList Alphabet = A.getAlphabet();
        int alphabetSize = Alphabet.size();
        this.alphabet = new char[alphabetSize];
        this.charEnc = new HashMap();
        for (int i = 0; i < alphabetSize; ++i) {
            char symbol = Alphabet.get(i);
            this.charEnc.put(Character.valueOf(symbol), i);
            this.alphabet[i] = symbol;
        }
        int howManyBits = Memory.howManyBits(alphabetSize);
        if (howManyBits > 8) {
            this.labelBytes = 2;
            this.labelFLAG = ~(-1 << howManyBits - 8);
            currentBit = howManyBits - 8;
            currentByte = 1;
        } else {
            this.labelBytes = 1;
            this.labelFLAG = ~(-1 << howManyBits);
            currentBit = howManyBits;
        }
        if (++currentBit > 8) {
            currentBit = 1;
            ++currentByte;
        }
        this.nextTransitionInfoOffset = currentByte++;
        this.nextTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.lastTransitionInfoOffset = currentByte++;
        this.lastTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.isFinalTransitionOffset = currentByte++;
        this.isFinalTransitionFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.pointsToSentinelOffset = currentByte;
        this.pointsToSentinelFLAG = (short)(1 << currentBit - 1);
        IntArrayList states = A.getStates();
        int maxIndex = 0;
        int max = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            if (states.get(i) <= max) continue;
            maxIndex = i;
        }
        int[] adressInTransitionArray = new int[++maxIndex];
        boolean[] sequentialState = new boolean[maxIndex];
        Arrays.fill(adressInTransitionArray, 0);
        Arrays.fill(sequentialState, false);
        InOutDegree[] InOut = FSAAuxilliaryFunctions.inOutDegree(A);
        int numberSequentialStates = 0;
        for (int i = 0; i < states.size(); ++i) {
            int target;
            int nextState = states.get(i);
            if (InOut[nextState].getInDegree() != 1 || InOut[nextState].getOutDegree() != 1 || (target = A.getTransitions(nextState).getTarget(0)) == nextState || InOut[target].getInDegree() != 1) continue;
            sequentialState[nextState] = true;
            ++numberSequentialStates;
        }
        int howManyBytesForTransitions = this.computNumberOfBytesForTransitionArray(this.numTransitions, currentByte + 1, numberSequentialStates);
        int howmanyBitsforTransitionIndex = Memory.howManyBits(howManyBytesForTransitions);
        this.jumpTransitionNumBytes = howmanyBitsforTransitionIndex / 8;
        if (howmanyBitsforTransitionIndex % 8 != 0) {
            ++this.jumpTransitionNumBytes;
        }
        this.transitionSize = ++currentByte + this.jumpTransitionNumBytes;
        this.jumpTransitionOffset = currentByte;
        byte[] tempTransitions = new byte[howManyBytesForTransitions + 1];
        Arrays.fill(tempTransitions, (byte)0);
        boolean[] visited = new boolean[maxIndex];
        Arrays.fill(visited, false);
        boolean[] inForProcessing = new boolean[maxIndex];
        Arrays.fill(inForProcessing, false);
        IntArrayList statesToBeProcessed = new IntArrayList(this.numStates / 2);
        statesToBeProcessed.add(A.getInitialState());
        currentByte = 0;
        int countT = 0;
        while (!statesToBeProcessed.empty()) {
            boolean isFinal;
            TransitionArrayList newTransitions;
            int nextState = statesToBeProcessed.removeLast();
            visited[nextState] = true;
            adressInTransitionArray[nextState] = currentByte;
            if (sequentialState[nextState]) {
                newTransitions = A.getTransitions(nextState);
                int targetState = newTransitions.getTarget(0);
                boolean isFinal2 = A.isFinalState(targetState);
                boolean isNext = true;
                boolean pointsToSentinel = false;
                if (InOut[targetState].getOutDegree() == 0) {
                    isNext = false;
                    pointsToSentinel = true;
                } else if (visited[targetState]) {
                    isNext = false;
                } else {
                    statesToBeProcessed.add(targetState);
                    inForProcessing[targetState] = true;
                }
                Integer charI = this.charEnc.get(Character.valueOf(newTransitions.getSymbol(0)));
                int charIndex = charI != null ? charI : -1;
                currentByte += this.insertTransition(tempTransitions, currentByte, charIndex, true, isNext, isFinal2, pointsToSentinel, targetState);
                ++countT;
                continue;
            }
            newTransitions = A.getTransitions(nextState);
            boolean foundOneNotVisited = false;
            int whichIsNotVisited = 0;
            for (int j = 0; j < newTransitions.size(); ++j) {
                int consumedBytes;
                int charIndex;
                Integer charI;
                boolean pointsToSentinel;
                int targetState = newTransitions.getTarget(j);
                boolean bl = pointsToSentinel = InOut[targetState].getOutDegree() == 0;
                if (!visited[targetState] && !inForProcessing[targetState]) {
                    if (!foundOneNotVisited && !pointsToSentinel) {
                        foundOneNotVisited = true;
                        whichIsNotVisited = j;
                        inForProcessing[targetState] = true;
                        continue;
                    }
                    if (!pointsToSentinel) {
                        statesToBeProcessed.add(targetState);
                        inForProcessing[targetState] = true;
                    }
                }
                char label = newTransitions.getSymbol(j);
                isFinal = A.isFinalState(targetState);
                if (j == newTransitions.size() - 1 && !foundOneNotVisited) {
                    charI = this.charEnc.get(Character.valueOf(label));
                    charIndex = charI != null ? charI : -1;
                    consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, false, isFinal, pointsToSentinel, targetState);
                } else {
                    charI = this.charEnc.get(Character.valueOf(label));
                    charIndex = charI != null ? charI : -1;
                    consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, false, false, isFinal, pointsToSentinel, targetState);
                }
                ++countT;
                currentByte += consumedBytes;
            }
            if (!foundOneNotVisited) continue;
            int targetState = newTransitions.getTarget(whichIsNotVisited);
            isFinal = A.isFinalState(targetState);
            ++countT;
            Integer charI = this.charEnc.get(Character.valueOf(newTransitions.getSymbol(whichIsNotVisited)));
            int charIndex = charI != null ? charI : -1;
            currentByte += this.insertTransition(tempTransitions, currentByte, charIndex, true, true, isFinal, false, 0);
            statesToBeProcessed.add(targetState);
        }
        this.transitions = new byte[currentByte];
        System.arraycopy(tempTransitions, 0, this.transitions, 0, this.transitions.length);
        currentByte = 0;
        int[] how_many_pointers_local = new int[]{0, 0, 0, 0};
        int how_many_next = 0;
        while (currentByte < this.transitions.length) {
            boolean pointsToSentinel;
            boolean isNext = (this.transitions[currentByte + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean bl = pointsToSentinel = (this.transitions[currentByte + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            if (isNext || pointsToSentinel) {
                currentByte += this.jumpTransitionOffset;
                ++how_many_next;
                continue;
            }
            int address = Memory.convertByteArrayToInt(this.transitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            if (Math.abs(adressInTransitionArray[address] - currentByte) < 256) {
                how_many_pointers_local[0] = how_many_pointers_local[0] + 1;
            } else if (Math.abs(adressInTransitionArray[address] - currentByte) < 65536) {
                how_many_pointers_local[1] = how_many_pointers_local[1] + 1;
            } else if (Math.abs(adressInTransitionArray[address] - currentByte) < 0x1000000) {
                how_many_pointers_local[2] = how_many_pointers_local[2] + 1;
            } else {
                how_many_pointers_local[3] = how_many_pointers_local[3] + 1;
            }
            Memory.convertIntToByteArray(adressInTransitionArray[address], this.transitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            currentByte += this.transitionSize;
        }
        adressInTransitionArray = null;
        sequentialState = null;
        tempTransitions = null;
        visited = null;
        statesToBeProcessed = null;
        this.constructTransTableForInitialState();
    }

    public void initializeFromOld(LetterFSAInterface A) {
        int currentByte = 0;
        int currentBit = 0;
        this.numStates = A.getNumberOfStates();
        this.numTransitions = A.getNumberOfTransitions();
        CharacterArrayList Alphabet = A.getAlphabet();
        int alphabetSize = Alphabet.size();
        this.alphabet = new char[alphabetSize];
        this.charEnc = new HashMap();
        for (int i = 0; i < alphabetSize; ++i) {
            char symbol = Alphabet.get(i);
            this.charEnc.put(Character.valueOf(symbol), i);
            this.alphabet[i] = symbol;
        }
        int howManyBits = Memory.howManyBits(alphabetSize);
        if (howManyBits > 8) {
            this.labelBytes = 2;
            this.labelFLAG = ~(-1 << howManyBits - 8);
            currentBit = howManyBits - 8;
            currentByte = 1;
        } else {
            this.labelBytes = 1;
            this.labelFLAG = ~(-1 << howManyBits);
            currentBit = howManyBits;
        }
        if (++currentBit > 8) {
            currentBit = 1;
            ++currentByte;
        }
        this.nextTransitionInfoOffset = currentByte++;
        this.nextTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.lastTransitionInfoOffset = currentByte++;
        this.lastTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.isFinalTransitionOffset = currentByte++;
        this.isFinalTransitionFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.pointsToSentinelOffset = currentByte;
        this.pointsToSentinelFLAG = (short)(1 << currentBit - 1);
        IntArrayList states = A.getStates();
        int maxIndex = 0;
        int max = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            if (states.get(i) <= max) continue;
            maxIndex = i;
        }
        int[] adressInTransitionArray = new int[++maxIndex];
        boolean[] sequentialState = new boolean[maxIndex];
        Arrays.fill(adressInTransitionArray, 0);
        Arrays.fill(sequentialState, false);
        InOutDegree[] InOut = FSAAuxilliaryFunctions.inOutDegree(A);
        int numberSequentialStates = 0;
        for (int i = 0; i < states.size(); ++i) {
            int nextState = states.get(i);
            if (InOut[nextState].getInDegree() != 1 || InOut[nextState].getOutDegree() != 1 || A.getTransitions(nextState).getTarget(0) == nextState) continue;
            sequentialState[nextState] = true;
            ++numberSequentialStates;
        }
        int howManyBytesForTransitions = this.computNumberOfBytesForTransitionArray(this.numTransitions, currentByte + 1, numberSequentialStates);
        int howmanyBitsforTransitionIndex = Memory.howManyBits(howManyBytesForTransitions);
        this.jumpTransitionNumBytes = howmanyBitsforTransitionIndex / 8;
        if (howmanyBitsforTransitionIndex % 8 != 0) {
            ++this.jumpTransitionNumBytes;
        }
        this.transitionSize = ++currentByte + this.jumpTransitionNumBytes;
        this.jumpTransitionOffset = currentByte;
        byte[] tempTransitions = new byte[howManyBytesForTransitions + 1];
        Arrays.fill(tempTransitions, (byte)0);
        boolean[] visited = new boolean[maxIndex];
        Arrays.fill(visited, false);
        IntArrayList statesToBeProcessed = new IntArrayList(this.numStates / 2);
        statesToBeProcessed.add(A.getInitialState());
        currentByte = 0;
        while (!statesToBeProcessed.empty()) {
            boolean isFinal;
            int consumedBytes;
            TransitionArrayList newTransitions;
            int nextState = statesToBeProcessed.removeLast();
            visited[nextState] = true;
            adressInTransitionArray[nextState] = currentByte;
            if (sequentialState[nextState]) {
                newTransitions = A.getTransitions(nextState);
                int targetState = newTransitions.getTarget(0);
                boolean isFinal2 = A.isFinalState(targetState);
                boolean isNext = true;
                boolean pointsToSentinel = false;
                if (InOut[targetState].getOutDegree() == 0) {
                    isNext = false;
                    pointsToSentinel = true;
                } else if (visited[targetState]) {
                    isNext = false;
                } else {
                    statesToBeProcessed.add(targetState);
                }
                Integer charI = this.charEnc.get(Character.valueOf(newTransitions.getSymbol(0)));
                int charIndex = charI != null ? charI : -1;
                consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, isNext, isFinal2, pointsToSentinel, targetState);
                currentByte += consumedBytes;
                continue;
            }
            newTransitions = A.getTransitions(nextState);
            boolean foundOneNotVisited = false;
            int whichIsNotVisited = 0;
            for (int j = 0; j < newTransitions.size(); ++j) {
                int charIndex;
                Integer charI;
                boolean pointsToSentinel;
                int targetState = newTransitions.getTarget(j);
                boolean bl = pointsToSentinel = InOut[targetState].getOutDegree() == 0;
                if (!visited[targetState]) {
                    if (!foundOneNotVisited && !pointsToSentinel) {
                        foundOneNotVisited = true;
                        whichIsNotVisited = j;
                        continue;
                    }
                    if (!pointsToSentinel) {
                        statesToBeProcessed.add(targetState);
                    }
                }
                char label = newTransitions.getSymbol(j);
                isFinal = A.isFinalState(targetState);
                if (j == newTransitions.size() - 1 && !foundOneNotVisited) {
                    charI = this.charEnc.get(Character.valueOf(label));
                    charIndex = charI != null ? charI : -1;
                    consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, false, isFinal, pointsToSentinel, targetState);
                } else {
                    charI = this.charEnc.get(Character.valueOf(label));
                    charIndex = charI != null ? charI : -1;
                    consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, false, false, isFinal, pointsToSentinel, targetState);
                }
                currentByte += consumedBytes;
            }
            if (!foundOneNotVisited) continue;
            int targetState = newTransitions.getTarget(whichIsNotVisited);
            isFinal = A.isFinalState(targetState);
            Integer charI = this.charEnc.get(Character.valueOf(newTransitions.getSymbol(whichIsNotVisited)));
            int charIndex = charI != null ? charI : -1;
            consumedBytes = this.insertTransition(tempTransitions, currentByte, charIndex, true, true, isFinal, false, 0);
            currentByte += consumedBytes;
            statesToBeProcessed.add(targetState);
        }
        this.transitions = new byte[currentByte];
        System.arraycopy(tempTransitions, 0, this.transitions, 0, this.transitions.length);
        currentByte = 0;
        int[] how_many_pointers_local = new int[]{0, 0, 0, 0};
        int how_many_next = 0;
        while (currentByte < this.transitions.length) {
            boolean pointsToSentinel;
            boolean isNext = (this.transitions[currentByte + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean bl = pointsToSentinel = (this.transitions[currentByte + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            if (isNext || pointsToSentinel) {
                currentByte += this.jumpTransitionOffset;
                ++how_many_next;
                continue;
            }
            int address = Memory.convertByteArrayToInt(this.transitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            if (Math.abs(adressInTransitionArray[address] - currentByte) < 256) {
                how_many_pointers_local[0] = how_many_pointers_local[0] + 1;
            } else if (Math.abs(adressInTransitionArray[address] - currentByte) < 65536) {
                how_many_pointers_local[1] = how_many_pointers_local[1] + 1;
            } else if (Math.abs(adressInTransitionArray[address] - currentByte) < 0x1000000) {
                how_many_pointers_local[2] = how_many_pointers_local[2] + 1;
            } else {
                how_many_pointers_local[3] = how_many_pointers_local[3] + 1;
            }
            Memory.convertIntToByteArray(adressInTransitionArray[address], this.transitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            currentByte += this.transitionSize;
        }
        adressInTransitionArray = null;
        sequentialState = null;
        tempTransitions = null;
        visited = null;
        statesToBeProcessed = null;
        this.constructTransTableForInitialState();
    }

    public void printAtState(String currentEntry, DictionaryLetterFSA.State state) {
        DictionaryLetterFSA.Transition nextTransition = state.getFirstTransition();
        while (nextTransition != null) {
            DictionaryLetterFSA.State nextState;
            String nextLabel = new Character(nextTransition.getLabel()).toString();
            if (nextTransition.pointsToFinalState()) {
                System.out.println("ENTRY: " + currentEntry + nextLabel);
            }
            if ((nextState = nextTransition.getTargetState()) != null) {
                this.printAtState(currentEntry + nextLabel, nextState);
            }
            nextTransition = state.getNextTransition(nextTransition);
        }
    }

    private int insertTransition(byte[] trans, int position, int label, boolean last, boolean next, boolean isFinal, boolean pointsToSentinel, int targetAddress) {
        if (this.labelBytes == 1) {
            trans[position] = (byte)(label & this.labelFLAG);
        } else {
            trans[position] = (byte)(label & 0xFF);
            trans[position + 1] = (byte)(label >>> 8 & this.labelFLAG);
        }
        trans[position + this.lastTransitionInfoOffset] = last ? (byte)(trans[position + this.lastTransitionInfoOffset] | this.lastTransitionInfoFLAG) : (byte)(trans[position + this.lastTransitionInfoOffset] & ~this.lastTransitionInfoFLAG);
        trans[position + this.nextTransitionInfoOffset] = next ? (byte)(trans[position + this.nextTransitionInfoOffset] | this.nextTransitionInfoFLAG) : (byte)(trans[position + this.nextTransitionInfoOffset] & ~this.nextTransitionInfoFLAG);
        trans[position + this.isFinalTransitionOffset] = isFinal ? (byte)(trans[position + this.isFinalTransitionOffset] | this.isFinalTransitionFLAG) : (byte)(trans[position + this.isFinalTransitionOffset] & ~this.isFinalTransitionFLAG);
        trans[position + this.pointsToSentinelOffset] = pointsToSentinel ? (byte)(trans[position + this.pointsToSentinelOffset] | this.pointsToSentinelFLAG) : (byte)(trans[position + this.pointsToSentinelOffset] & ~this.pointsToSentinelFLAG);
        if (!next && !pointsToSentinel) {
            Memory.convertIntToByteArray(targetAddress, trans, position + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
        }
        if (next || pointsToSentinel) {
            return this.jumpTransitionOffset;
        }
        return this.transitionSize;
    }

    public void printTransToText(String Filename) throws FiniteStateProcessingException {
        int start = 0;
        int max = this.transitions.length;
        StringBuffer Result = new StringBuffer();
        Result.append(this.getNumberOfStates() + " states\n");
        Result.append(this.getNumberOfTransitions() + " trans\n");
        Result.append(this.transitions.length);
        Result.append(" bytes needed for storing transitions\n");
        Result.append(Memory.howManyBits(this.alphabet.length));
        Result.append(" bits needed for representing labels\n");
        Result.append(this.labelBytes);
        Result.append(" bytes needed for representing labels\n");
        while (start < max) {
            int pointToSE;
            boolean next = (this.transitions[start + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean pointsToS = (this.transitions[start + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            int label = this.labelBytes == 1 ? this.transitions[start] & this.labelFLAG : this.transitions[start] & 0xFF | (this.transitions[start + 1] & this.labelFLAG) << 8;
            int lastE = (this.transitions[start + this.lastTransitionInfoOffset] & this.lastTransitionInfoFLAG) != 0 ? 1 : 0;
            int nextE = (this.transitions[start + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0 ? 1 : 0;
            int finalE = (this.transitions[start + this.isFinalTransitionOffset] & this.isFinalTransitionFLAG) != 0 ? 1 : 0;
            int n = pointToSE = (this.transitions[start + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0 ? 1 : 0;
            if (!next && !pointsToS) {
                Result.append(start);
                Result.append(" ");
                Result.append(label);
                Result.append(" ");
                Result.append(lastE);
                Result.append(" ");
                Result.append(nextE);
                Result.append(" ");
                Result.append(pointToSE);
                Result.append(" ");
                Result.append(finalE);
                Result.append(" ");
                Result.append(Memory.convertByteArrayToInt(this.transitions, start + this.jumpTransitionOffset, this.jumpTransitionNumBytes));
                Result.append("\n");
                start += this.transitionSize;
                continue;
            }
            Result.append(start);
            Result.append(" ");
            Result.append(label);
            Result.append(" ");
            Result.append(lastE);
            Result.append(" ");
            Result.append(nextE);
            Result.append(" ");
            Result.append(pointToSE);
            Result.append(" ");
            Result.append(finalE);
            Result.append("\n");
            start += this.jumpTransitionOffset;
        }
        try {
            Files.StringBufferToFile(Filename, Result, "UTF-8");
        }
        catch (Exception e) {
            throw new FiniteStateProcessingException("Could not write to file: " + Filename);
        }
    }

    private int computNumberOfBytesForTransitionArray(int numTrans, int minSizeForTrans, int numTransWithNext) {
        long T = numTrans;
        long C = minSizeForTrans;
        long X = T * C;
        long E = numTransWithNext;
        long currentVal = 0L;
        while ((X += T) < (currentVal = T * C + (long)Math.round(((T - E) * (long)Arithmetic.log2(X) + 1L) / 8L))) {
        }
        return (int)(X + T);
    }

    private void internalPrint() {
        System.out.println("numTransitions: " + this.numTransitions);
        System.out.println("alphabetSize " + this.alphabet.length);
        System.out.println("numStates " + this.numStates);
        System.out.println("transitionSize " + this.transitionSize);
        System.out.println("nextTransitionInfoOffset " + this.nextTransitionInfoOffset);
        System.out.println("nextTransitionInfoFLAG " + this.nextTransitionInfoFLAG);
        System.out.println("lastTransitionInfoOffset " + this.lastTransitionInfoOffset);
        System.out.println("lastTransitionInfoFLAG " + this.lastTransitionInfoFLAG);
        System.out.println("pointsToSentinelOffset " + this.pointsToSentinelOffset);
        System.out.println("pointsToSentinelFLAG " + this.pointsToSentinelFLAG);
        System.out.println("isFinalTransitionOffset " + this.isFinalTransitionOffset);
        System.out.println("isFinalTransitionFLAG " + this.isFinalTransitionFLAG);
        System.out.println("labelBytes " + this.labelBytes);
        System.out.println("labelFLAG " + this.labelFLAG);
        System.out.println("jumpTransitionOffset " + this.jumpTransitionOffset);
        System.out.println("jumpTransitionNumBytes " + this.jumpTransitionNumBytes);
    }

    @Override
    public boolean saveToFile(String File2) {
        ByteBuffer b = ByteBuffer.allocate(this.transitions.length + 131072 + 1000);
        this.writeToByteBuffer(b);
        byte[] fill = b.array();
        File FileName = new File(File2);
        try {
            FileOutputStream out = new FileOutputStream(FileName);
            DataOutputStream s = new DataOutputStream(out);
            s.write(fill, 0, fill.length);
            s.flush();
            s.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        fill = null;
        return true;
    }

    @Override
    public boolean readFromFile(String File2) {
        File FileName = new File(File2);
        int maxLen = (int)FileName.length();
        byte[] randomAccess = new byte[maxLen];
        try {
            FileInputStream out = new FileInputStream(FileName);
            DataInputStream s = new DataInputStream(out);
            s.readFully(randomAccess, 0, maxLen);
            s.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Exception while reading File: " + File2);
            return false;
        }
        ByteBuffer b = ByteBuffer.allocate(maxLen);
        b.put(randomAccess);
        b.rewind();
        this.readFromByteBuffer(b);
        randomAccess = null;
        return true;
    }

    @Override
    public boolean writeToByteBuffer(ByteBuffer b) {
        b.putInt(this.numTransitions);
        b.putInt(this.numStates);
        b.putInt(this.transitionSize);
        b.putInt(this.nextTransitionInfoOffset);
        b.putShort(this.nextTransitionInfoFLAG);
        b.putInt(this.lastTransitionInfoOffset);
        b.putShort(this.lastTransitionInfoFLAG);
        b.putInt(this.isFinalTransitionOffset);
        b.putShort(this.isFinalTransitionFLAG);
        b.putInt(this.pointsToSentinelOffset);
        b.putShort(this.pointsToSentinelFLAG);
        b.putInt(this.labelBytes);
        b.putInt(this.labelFLAG);
        b.putInt(this.jumpTransitionOffset);
        b.putInt(this.jumpTransitionNumBytes);
        b.putInt(this.alphabet.length);
        for (int i = 0; i < this.alphabet.length; ++i) {
            b.putChar(this.alphabet[i]);
        }
        b.putInt(this.transitions.length);
        b.put(this.transitions);
        return true;
    }

    @Override
    public boolean writeToDataOutputStream(DataOutputStream d) throws IOException {
        d.writeInt(this.numTransitions);
        d.writeInt(this.numStates);
        d.writeInt(this.transitionSize);
        d.writeInt(this.nextTransitionInfoOffset);
        d.writeShort(this.nextTransitionInfoFLAG);
        d.writeInt(this.lastTransitionInfoOffset);
        d.writeShort(this.lastTransitionInfoFLAG);
        d.writeInt(this.isFinalTransitionOffset);
        d.writeShort(this.isFinalTransitionFLAG);
        d.writeInt(this.pointsToSentinelOffset);
        d.writeShort(this.pointsToSentinelFLAG);
        d.writeInt(this.labelBytes);
        d.writeInt(this.labelFLAG);
        d.writeInt(this.jumpTransitionOffset);
        d.writeInt(this.jumpTransitionNumBytes);
        d.writeInt(this.alphabet.length);
        for (int i = 0; i < this.alphabet.length; ++i) {
            d.writeChar(this.alphabet[i]);
        }
        d.writeInt(this.transitions.length);
        d.write(this.transitions, 0, this.transitions.length);
        return true;
    }

    @Override
    public boolean readFromDataInputStream(DataInputStream d) throws IOException {
        int i;
        this.numTransitions = d.readInt();
        this.numStates = d.readInt();
        this.transitionSize = d.readInt();
        this.nextTransitionInfoOffset = d.readInt();
        this.nextTransitionInfoFLAG = d.readShort();
        this.lastTransitionInfoOffset = d.readInt();
        this.lastTransitionInfoFLAG = d.readShort();
        this.isFinalTransitionOffset = d.readInt();
        this.isFinalTransitionFLAG = d.readShort();
        this.pointsToSentinelOffset = d.readInt();
        this.pointsToSentinelFLAG = d.readShort();
        this.labelBytes = d.readInt();
        this.labelFLAG = d.readInt();
        this.jumpTransitionOffset = d.readInt();
        this.jumpTransitionNumBytes = d.readInt();
        int size = d.readInt();
        this.alphabet = new char[size];
        for (i = 0; i < size; ++i) {
            this.alphabet[i] = d.readChar();
        }
        this.charEnc = new HashMap();
        for (i = 0; i < size; ++i) {
            this.charEnc.put(Character.valueOf(this.alphabet[i]), i);
        }
        size = d.readInt();
        this.transitions = new byte[size];
        d.readFully(this.transitions, 0, size);
        this.constructTransTableForInitialState();
        return true;
    }

    @Override
    public boolean readFromByteBuffer(ByteBuffer b) {
        int i;
        this.numTransitions = b.getInt();
        this.numStates = b.getInt();
        this.transitionSize = b.getInt();
        this.nextTransitionInfoOffset = b.getInt();
        this.nextTransitionInfoFLAG = b.getShort();
        this.lastTransitionInfoOffset = b.getInt();
        this.lastTransitionInfoFLAG = b.getShort();
        this.isFinalTransitionOffset = b.getInt();
        this.isFinalTransitionFLAG = b.getShort();
        this.pointsToSentinelOffset = b.getInt();
        this.pointsToSentinelFLAG = b.getShort();
        this.labelBytes = b.getInt();
        this.labelFLAG = b.getInt();
        this.jumpTransitionOffset = b.getInt();
        this.jumpTransitionNumBytes = b.getInt();
        int size = b.getInt();
        this.alphabet = new char[size];
        for (i = 0; i < size; ++i) {
            this.alphabet[i] = b.getChar();
        }
        this.charEnc = new HashMap();
        for (i = 0; i < size; ++i) {
            this.charEnc.put(Character.valueOf(this.alphabet[i]), i);
        }
        size = b.getInt();
        this.transitions = new byte[size];
        b.get(this.transitions);
        this.constructTransTableForInitialState();
        return true;
    }

    private final class State
    implements DictionaryLetterFSA.State {
        private int offset;

        @Override
        public DictionaryLetterFSA.Transition getFirstTransition() {
            return new Transition(this.offset);
        }

        public State(int offset) {
            this.offset = offset;
        }

        @Override
        public DictionaryLetterFSA.Transition getNextTransition(DictionaryLetterFSA.Transition transition) {
            Transition myTransition = (Transition)transition;
            if (myTransition.isLast()) {
                return null;
            }
            if (myTransition.next() || myTransition.pointsToSentinel()) {
                return new Transition(myTransition.offset + DictionaryLetterFSAImpl_1x.this.jumpTransitionOffset);
            }
            return new Transition(myTransition.offset + DictionaryLetterFSAImpl_1x.this.transitionSize);
        }

        @Override
        public DictionaryLetterFSA.Transition getTransitionLabelledWith(char label) {
            if (this.equals(DictionaryLetterFSAImpl_1x.this.getInitialState())) {
                return (DictionaryLetterFSA.Transition)DictionaryLetterFSAImpl_1x.this.targetTransForInitState.get(Character.valueOf(label));
            }
            DictionaryLetterFSA.Transition currentTransition = this.getFirstTransition();
            while (currentTransition != null) {
                if (currentTransition.getLabel() == label) {
                    return currentTransition;
                }
                currentTransition = this.getNextTransition(currentTransition);
            }
            return null;
        }

        public int hashCode() {
            return this.offset;
        }

        public boolean equals(Object o) {
            return this.offset == ((State)o).offset;
        }
    }

    private final class Transition
    implements DictionaryLetterFSA.Transition {
        private int offset;

        @Override
        public DictionaryLetterFSA.State getTargetState() {
            if ((DictionaryLetterFSAImpl_1x.this.transitions[this.offset + DictionaryLetterFSAImpl_1x.this.pointsToSentinelOffset] & DictionaryLetterFSAImpl_1x.this.pointsToSentinelFLAG) != 0) {
                return null;
            }
            if ((DictionaryLetterFSAImpl_1x.this.transitions[this.offset + DictionaryLetterFSAImpl_1x.this.nextTransitionInfoOffset] & DictionaryLetterFSAImpl_1x.this.nextTransitionInfoFLAG) != 0) {
                return new State(this.offset + DictionaryLetterFSAImpl_1x.this.jumpTransitionOffset);
            }
            return new State(Memory.convertByteArrayToInt(DictionaryLetterFSAImpl_1x.this.transitions, this.offset + DictionaryLetterFSAImpl_1x.this.jumpTransitionOffset, DictionaryLetterFSAImpl_1x.this.jumpTransitionNumBytes));
        }

        protected boolean isLast() {
            return (DictionaryLetterFSAImpl_1x.this.transitions[this.offset + DictionaryLetterFSAImpl_1x.this.lastTransitionInfoOffset] & DictionaryLetterFSAImpl_1x.this.lastTransitionInfoFLAG) != 0;
        }

        public Transition(int offset) {
            this.offset = offset;
        }

        @Override
        public char getLabel() {
            if (DictionaryLetterFSAImpl_1x.this.labelBytes == 1) {
                return DictionaryLetterFSAImpl_1x.this.alphabet[DictionaryLetterFSAImpl_1x.this.transitions[this.offset] & DictionaryLetterFSAImpl_1x.this.labelFLAG];
            }
            return DictionaryLetterFSAImpl_1x.this.alphabet[DictionaryLetterFSAImpl_1x.this.transitions[this.offset] & 0xFF | (DictionaryLetterFSAImpl_1x.this.transitions[this.offset + 1] & DictionaryLetterFSAImpl_1x.this.labelFLAG) << 8];
        }

        @Override
        public boolean pointsToFinalState() {
            return (DictionaryLetterFSAImpl_1x.this.transitions[this.offset + DictionaryLetterFSAImpl_1x.this.isFinalTransitionOffset] & DictionaryLetterFSAImpl_1x.this.isFinalTransitionFLAG) != 0;
        }

        protected boolean pointsToSentinel() {
            return (DictionaryLetterFSAImpl_1x.this.transitions[this.offset + DictionaryLetterFSAImpl_1x.this.pointsToSentinelOffset] & DictionaryLetterFSAImpl_1x.this.pointsToSentinelFLAG) != 0;
        }

        protected boolean next() {
            return (DictionaryLetterFSAImpl_1x.this.transitions[this.offset + DictionaryLetterFSAImpl_1x.this.nextTransitionInfoOffset] & DictionaryLetterFSAImpl_1x.this.nextTransitionInfoFLAG) != 0;
        }
    }
}

