/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.FSAAuxilliaryFunctions;
import piskorski.fs.letterfs.fsa.FiniteStateProcessingException;
import piskorski.fs.letterfs.fsa.InOutDegree;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.functions.Arithmetic;
import piskorski.util.functions.Files;
import piskorski.util.functions.Memory;

public class DictionaryLetterFSAImpl_2
extends DictionaryLetterFSA {
    private int numTransitions;
    private int numStates;
    private char[] alphabet;
    protected byte[] transitions;
    private int transitionSize;
    private int nextTransitionInfoOffset;
    private short nextTransitionInfoFLAG;
    private int lastTransitionInfoOffset;
    private short lastTransitionInfoFLAG;
    private int isFinalTransitionOffset;
    private short isFinalTransitionFLAG;
    private int pointsToSentinelOffset;
    private short pointsToSentinelFLAG;
    private int usesRelativePointerOffset;
    private short usesRelativePointerFLAG;
    private int isNegativeOffset;
    private short isNegativeFLAG;
    private int labelBytes;
    private int labelFLAG;
    private int jumpTransitionOffset;
    private int jumpTransitionNumBytes;
    private int[] charEncoding;

    @Override
    public int getNumberOfTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumberOfStates() {
        return this.numStates;
    }

    @Override
    public CharacterArrayList getAlphabet() {
        CharacterArrayList result = new CharacterArrayList();
        for (int i = 0; i < this.alphabet.length; ++i) {
            result.add(this.alphabet[i]);
        }
        return result;
    }

    @Override
    public DictionaryLetterFSA.State getInitialState() {
        return new State(0);
    }

    @Override
    public void initializeFrom(LetterFSAInterface A) {
        int address;
        boolean pointsToSentinel;
        boolean isNext;
        int currentByte = 0;
        int currentBit = 0;
        this.numStates = A.getNumberOfStates();
        this.numTransitions = A.getNumberOfTransitions();
        CharacterArrayList Alphabet = A.getAlphabet();
        int alphabetSize = Alphabet.size();
        this.alphabet = new char[alphabetSize];
        this.charEncoding = new int[65536];
        Arrays.fill(this.charEncoding, -1);
        for (int i = 0; i < alphabetSize; ++i) {
            char symbol = Alphabet.get(i);
            this.charEncoding[symbol] = i;
            this.alphabet[i] = symbol;
        }
        int howManyBits = Memory.howManyBits(alphabetSize);
        if (howManyBits > 8) {
            this.labelBytes = 2;
            this.labelFLAG = ~(-1 << howManyBits - 8);
            currentBit = howManyBits - 8;
            currentByte = 1;
        } else {
            this.labelBytes = 1;
            this.labelFLAG = ~(-1 << howManyBits);
            currentBit = howManyBits;
        }
        if (++currentBit > 8) {
            currentBit = 1;
            ++currentByte;
        }
        this.nextTransitionInfoOffset = currentByte++;
        this.nextTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.lastTransitionInfoOffset = currentByte++;
        this.lastTransitionInfoFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.isFinalTransitionOffset = currentByte++;
        this.isFinalTransitionFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.pointsToSentinelOffset = currentByte++;
        this.pointsToSentinelFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.usesRelativePointerOffset = currentByte++;
        this.usesRelativePointerFLAG = (short)(1 << currentBit - 1);
        if (++currentBit > 8) {
            currentBit = 1;
        }
        this.isNegativeOffset = currentByte;
        this.isNegativeFLAG = (short)(1 << currentBit - 1);
        IntArrayList states = A.getStates();
        int maxIndex = 0;
        int max = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            if (states.get(i) <= max) continue;
            maxIndex = i;
        }
        int[] adressInTransitionArray = new int[++maxIndex];
        boolean[] sequentialState = new boolean[maxIndex];
        Arrays.fill(adressInTransitionArray, 0);
        Arrays.fill(sequentialState, false);
        InOutDegree[] InOut = FSAAuxilliaryFunctions.inOutDegree(A);
        int numberSequentialStates = 0;
        for (int i = 0; i < states.size(); ++i) {
            int nextState = states.get(i);
            if (InOut[nextState].getInDegree() != 1 || InOut[nextState].getOutDegree() != 1 || A.getTransitions(nextState).getTarget(0) == nextState) continue;
            sequentialState[nextState] = true;
            ++numberSequentialStates;
        }
        int howManyBytesForTransitions = this.computNumberOfBytesForTransitionArray(this.numTransitions, currentByte + 1, numberSequentialStates);
        int howmanyBitsforTransitionIndex = Memory.howManyBits(howManyBytesForTransitions);
        this.jumpTransitionNumBytes = howmanyBitsforTransitionIndex / 8;
        if (howmanyBitsforTransitionIndex % 8 != 0) {
            ++this.jumpTransitionNumBytes;
        }
        this.transitionSize = ++currentByte + this.jumpTransitionNumBytes;
        this.jumpTransitionOffset = currentByte;
        byte[] tempTransitions = new byte[howManyBytesForTransitions + 1];
        Arrays.fill(tempTransitions, (byte)0);
        boolean[] visited = new boolean[maxIndex];
        Arrays.fill(visited, false);
        IntArrayList statesToBeProcessed = new IntArrayList(this.numStates / 2);
        statesToBeProcessed.add(A.getInitialState());
        currentByte = 0;
        while (!statesToBeProcessed.empty()) {
            boolean isFinal;
            int consumedBytes;
            TransitionArrayList newTransitions;
            int nextState = statesToBeProcessed.removeLast();
            visited[nextState] = true;
            adressInTransitionArray[nextState] = currentByte;
            if (sequentialState[nextState]) {
                newTransitions = A.getTransitions(nextState);
                int targetState = newTransitions.getTarget(0);
                boolean isFinal2 = A.isFinalState(targetState);
                boolean isNext2 = true;
                boolean pointsToSentinel2 = false;
                if (InOut[targetState].getOutDegree() == 0) {
                    isNext2 = false;
                    pointsToSentinel2 = true;
                } else if (visited[targetState]) {
                    isNext2 = false;
                } else {
                    statesToBeProcessed.add(targetState);
                }
                consumedBytes = this.insertTransition(tempTransitions, currentByte, this.charEncoding[newTransitions.getSymbol(0)], true, isNext2, isFinal2, pointsToSentinel2, targetState);
                currentByte += consumedBytes;
                continue;
            }
            newTransitions = A.getTransitions(nextState);
            boolean foundOneNotVisited = false;
            int whichIsNotVisited = 0;
            for (int j = 0; j < newTransitions.size(); ++j) {
                boolean pointsToSentinel3;
                int targetState = newTransitions.getTarget(j);
                boolean bl = pointsToSentinel3 = InOut[targetState].getOutDegree() == 0;
                if (!visited[targetState]) {
                    if (!foundOneNotVisited && !pointsToSentinel3) {
                        foundOneNotVisited = true;
                        whichIsNotVisited = j;
                        continue;
                    }
                    if (!pointsToSentinel3) {
                        statesToBeProcessed.add(targetState);
                    }
                }
                char label = newTransitions.getSymbol(j);
                isFinal = A.isFinalState(targetState);
                consumedBytes = j == newTransitions.size() - 1 && !foundOneNotVisited ? this.insertTransition(tempTransitions, currentByte, this.charEncoding[label], true, false, isFinal, pointsToSentinel3, targetState) : this.insertTransition(tempTransitions, currentByte, this.charEncoding[label], false, false, isFinal, pointsToSentinel3, targetState);
                currentByte += consumedBytes;
            }
            if (!foundOneNotVisited) continue;
            int targetState = newTransitions.getTarget(whichIsNotVisited);
            isFinal = A.isFinalState(targetState);
            consumedBytes = this.insertTransition(tempTransitions, currentByte, this.charEncoding[newTransitions.getSymbol(whichIsNotVisited)], true, true, isFinal, false, 0);
            currentByte += consumedBytes;
            statesToBeProcessed.add(targetState);
        }
        int tempTransitionsLen = currentByte;
        int[] relativeAddress = new int[currentByte + 1];
        System.out.println("tempTransitionsLen: " + tempTransitionsLen);
        System.out.println("relativeAddress: " + relativeAddress.length);
        System.out.println("addressInTransitionArray: " + adressInTransitionArray.length);
        currentByte = 0;
        int how_many_next = 0;
        while (currentByte < tempTransitionsLen) {
            isNext = (tempTransitions[currentByte + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean bl = pointsToSentinel = (tempTransitions[currentByte + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            if (isNext || pointsToSentinel) {
                currentByte += this.jumpTransitionOffset;
                ++how_many_next;
                continue;
            }
            address = Memory.convertByteArrayToInt(tempTransitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            if (Math.abs(adressInTransitionArray[address] - currentByte) < 256) {
                int e = adressInTransitionArray[address] - currentByte;
                tempTransitions[currentByte + this.usesRelativePointerOffset] = (byte)(tempTransitions[currentByte + this.usesRelativePointerOffset] | this.usesRelativePointerFLAG);
                int old_e = e;
                if (e < 0) {
                    e *= -1;
                    tempTransitions[currentByte + this.isNegativeOffset] = (byte)(tempTransitions[currentByte + this.isNegativeOffset] | this.isNegativeFLAG);
                }
                Memory.convertIntToByteArray(e, tempTransitions, currentByte + this.jumpTransitionOffset, 1);
                int new_e = Memory.convertByteArrayToInt(tempTransitions, currentByte + this.jumpTransitionOffset, 1);
                if (old_e < 0) {
                    new_e *= -1;
                }
                if (old_e != new_e) {
                    System.out.println(old_e + " * " + new_e);
                }
                relativeAddress[currentByte + 1] = this.jumpTransitionNumBytes - 1;
                currentByte += this.transitionSize;
                continue;
            }
            Memory.convertIntToByteArray(adressInTransitionArray[address], tempTransitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            currentByte += this.transitionSize;
        }
        int counter = 0;
        for (int i = 0; i < tempTransitionsLen; ++i) {
            if (relativeAddress[i] > 0) {
                counter += relativeAddress[i];
            }
            relativeAddress[i] = counter;
        }
        this.transitions = new byte[tempTransitionsLen - counter];
        currentByte = 0;
        int currentPos = 0;
        while (currentByte < tempTransitionsLen) {
            int newAddress;
            boolean usesRel;
            isNext = (tempTransitions[currentByte + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean bl = pointsToSentinel = (tempTransitions[currentByte + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            if (isNext || pointsToSentinel) {
                System.arraycopy(tempTransitions, currentByte, this.transitions, currentPos, this.jumpTransitionOffset);
                currentByte += this.jumpTransitionOffset;
                currentPos += this.jumpTransitionOffset;
                continue;
            }
            boolean bl2 = usesRel = (tempTransitions[currentByte + this.usesRelativePointerOffset] & this.usesRelativePointerFLAG) != 0;
            if (usesRel) {
                System.arraycopy(tempTransitions, currentByte, this.transitions, currentPos, this.jumpTransitionOffset + 1);
                address = Memory.convertByteArrayToInt(tempTransitions, currentByte + this.jumpTransitionOffset, 1);
                boolean negativeJump = (tempTransitions[currentByte + this.isNegativeOffset] & this.isNegativeFLAG) != 0;
                newAddress = negativeJump ? address - (relativeAddress[currentByte] - relativeAddress[currentByte - address]) : address - (relativeAddress[currentByte + address] - relativeAddress[currentByte]);
                Memory.convertIntToByteArray(newAddress, this.transitions, currentPos + this.jumpTransitionOffset, 1);
                currentByte += this.transitionSize;
                currentPos = currentPos + this.jumpTransitionOffset + 1;
                continue;
            }
            System.arraycopy(tempTransitions, currentByte, this.transitions, currentPos, this.transitionSize);
            address = Memory.convertByteArrayToInt(tempTransitions, currentByte + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            newAddress = address - relativeAddress[address];
            Memory.convertIntToByteArray(newAddress, this.transitions, currentPos + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
            currentByte += this.transitionSize;
            currentPos += this.transitionSize;
        }
        this.internalPrint();
    }

    public void printAtState(String currentEntry, DictionaryLetterFSA.State state) {
        DictionaryLetterFSA.Transition nextTransition = state.getFirstTransition();
        while (nextTransition != null) {
            DictionaryLetterFSA.State nextState;
            String nextLabel = new Character(nextTransition.getLabel()).toString();
            if (nextTransition.pointsToFinalState()) {
                System.out.println("ENTRY: " + currentEntry + nextLabel);
            }
            if ((nextState = nextTransition.getTargetState()) != null) {
                this.printAtState(currentEntry + nextLabel, nextState);
            }
            nextTransition = state.getNextTransition(nextTransition);
        }
    }

    private int insertTransition(byte[] trans, int position, int label, boolean last, boolean next, boolean isFinal, boolean pointsToSentinel, int targetAddress) {
        if (this.labelBytes == 1) {
            trans[position] = (byte)(label & this.labelFLAG);
        } else {
            trans[position] = (byte)(label & 0xFF);
            trans[position + 1] = (byte)(label >>> 8 & this.labelFLAG);
        }
        trans[position + this.lastTransitionInfoOffset] = last ? (byte)(trans[position + this.lastTransitionInfoOffset] | this.lastTransitionInfoFLAG) : (byte)(trans[position + this.lastTransitionInfoOffset] & ~this.lastTransitionInfoFLAG);
        trans[position + this.nextTransitionInfoOffset] = next ? (byte)(trans[position + this.nextTransitionInfoOffset] | this.nextTransitionInfoFLAG) : (byte)(trans[position + this.nextTransitionInfoOffset] & ~this.nextTransitionInfoFLAG);
        trans[position + this.isFinalTransitionOffset] = isFinal ? (byte)(trans[position + this.isFinalTransitionOffset] | this.isFinalTransitionFLAG) : (byte)(trans[position + this.isFinalTransitionOffset] & ~this.isFinalTransitionFLAG);
        trans[position + this.pointsToSentinelOffset] = pointsToSentinel ? (byte)(trans[position + this.pointsToSentinelOffset] | this.pointsToSentinelFLAG) : (byte)(trans[position + this.pointsToSentinelOffset] & ~this.pointsToSentinelFLAG);
        if (!next && !pointsToSentinel) {
            Memory.convertIntToByteArray(targetAddress, trans, position + this.jumpTransitionOffset, this.jumpTransitionNumBytes);
        }
        if (next || pointsToSentinel) {
            return this.jumpTransitionOffset;
        }
        return this.transitionSize;
    }

    public void printTransToText(String Filename) throws FiniteStateProcessingException {
        int start = 0;
        int max = this.transitions.length;
        StringBuffer Result = new StringBuffer();
        Result.append(this.transitions.length);
        Result.append(" bytes needed for storing transitions\n");
        Result.append(Memory.howManyBits(this.alphabet.length));
        Result.append(" bits needed for representing labels\n");
        Result.append(this.labelBytes);
        Result.append(" bytes needed for representing labels\n");
        while (start < max) {
            int relativeP;
            boolean next = (this.transitions[start + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0;
            boolean pointsToS = (this.transitions[start + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0;
            boolean relativePointer = (this.transitions[start + this.usesRelativePointerOffset] & this.usesRelativePointerFLAG) != 0;
            boolean negative = (this.transitions[start + this.isNegativeOffset] & this.isNegativeFLAG) != 0;
            int label = this.labelBytes == 1 ? this.transitions[start] & this.labelFLAG : this.transitions[start] & 0xFF | (this.transitions[start + 1] & this.labelFLAG) << 8;
            int lastE = (this.transitions[start + this.lastTransitionInfoOffset] & this.lastTransitionInfoFLAG) != 0 ? 1 : 0;
            int nextE = (this.transitions[start + this.nextTransitionInfoOffset] & this.nextTransitionInfoFLAG) != 0 ? 1 : 0;
            int finalE = (this.transitions[start + this.isFinalTransitionOffset] & this.isFinalTransitionFLAG) != 0 ? 1 : 0;
            int pointToSE = (this.transitions[start + this.pointsToSentinelOffset] & this.pointsToSentinelFLAG) != 0 ? 1 : 0;
            int n = relativeP = (this.transitions[start + this.usesRelativePointerOffset] & this.usesRelativePointerFLAG) != 0 ? 1 : 0;
            if (!next && !pointsToS) {
                if (relativePointer) {
                    Result.append(start);
                    Result.append(" ");
                    Result.append(label);
                    Result.append(" ");
                    Result.append(lastE);
                    Result.append(" ");
                    Result.append(nextE);
                    Result.append(" ");
                    Result.append(pointToSE);
                    Result.append(" ");
                    Result.append(finalE);
                    Result.append(" ");
                    Result.append(relativeP);
                    Result.append(" ");
                    int address = Memory.convertByteArrayToInt(this.transitions, start + this.jumpTransitionOffset, 1);
                    if (negative) {
                        address *= -1;
                    }
                    Result.append(address);
                    Result.append("\n");
                    start = start + this.jumpTransitionOffset + 1;
                    continue;
                }
                Result.append(start);
                Result.append(" ");
                Result.append(label);
                Result.append(" ");
                Result.append(lastE);
                Result.append(" ");
                Result.append(nextE);
                Result.append(" ");
                Result.append(pointToSE);
                Result.append(" ");
                Result.append(finalE);
                Result.append(" ");
                Result.append(relativeP);
                Result.append(" ");
                Result.append(Memory.convertByteArrayToInt(this.transitions, start + this.jumpTransitionOffset, this.jumpTransitionNumBytes));
                Result.append("\n");
                start += this.transitionSize;
                continue;
            }
            Result.append(start);
            Result.append(" ");
            Result.append(label);
            Result.append(" ");
            Result.append(lastE);
            Result.append(" ");
            Result.append(nextE);
            Result.append(" ");
            Result.append(pointToSE);
            Result.append(" ");
            Result.append(finalE);
            Result.append(" ");
            Result.append(relativeP);
            Result.append("\n");
            start += this.jumpTransitionOffset;
        }
        try {
            Files.StringBufferToFile(Filename, Result, "UTF-8");
        }
        catch (Exception e) {
            throw new FiniteStateProcessingException("Could not write to file: " + Filename);
        }
    }

    private int computNumberOfBytesForTransitionArray(int numTrans, int minSizeForTrans, int numTransWithNext) {
        long T = numTrans;
        long C = minSizeForTrans;
        long X = T * C;
        long E = numTransWithNext;
        long currentVal = 0L;
        while ((X += T) < (currentVal = T * C + Math.round((double)(T - E) / 8.0 + 1.0) * (long)Arithmetic.log2(X))) {
        }
        return (int)(X + T);
    }

    private void internalPrint() {
        System.out.println("numTransitions: " + this.numTransitions);
        System.out.println("alphabetSize " + this.alphabet.length);
        System.out.println("numStates " + this.numStates);
        System.out.println("transitionSize " + this.transitionSize);
        System.out.println("nextTransitionInfoOffset " + this.nextTransitionInfoOffset);
        System.out.println("nextTransitionInfoFLAG " + this.nextTransitionInfoFLAG);
        System.out.println("lastTransitionInfoOffset " + this.lastTransitionInfoOffset);
        System.out.println("lastTransitionInfoFLAG " + this.lastTransitionInfoFLAG);
        System.out.println("pointsToSentinelOffset " + this.pointsToSentinelOffset);
        System.out.println("pointsToSentinelFLAG " + this.pointsToSentinelFLAG);
        System.out.println("isFinalTransitionOffset " + this.isFinalTransitionOffset);
        System.out.println("isFinalTransitionFLAG " + this.isFinalTransitionFLAG);
        System.out.println("labelBytes " + this.labelBytes);
        System.out.println("labelFLAG " + this.labelFLAG);
        System.out.println("jumpTransitionOffset " + this.jumpTransitionOffset);
        System.out.println("jumpTransitionNumBytes " + this.jumpTransitionNumBytes);
    }

    @Override
    public boolean saveToFile(String File2) {
        ByteBuffer b = ByteBuffer.allocate(this.transitions.length + 131072 + 1000);
        this.writeToByteBuffer(b);
        byte[] fill = b.array();
        File FileName = new File(File2);
        try {
            FileOutputStream out = new FileOutputStream(FileName);
            DataOutputStream s = new DataOutputStream(out);
            s.write(fill, 0, fill.length);
            s.flush();
            s.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        fill = null;
        return true;
    }

    @Override
    public boolean readFromFile(String File2) {
        File FileName = new File(File2);
        int maxLen = (int)FileName.length();
        byte[] randomAccess = new byte[maxLen];
        try {
            FileInputStream out = new FileInputStream(FileName);
            DataInputStream s = new DataInputStream(out);
            s.readFully(randomAccess, 0, maxLen);
            s.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Exception while reading File: " + File2);
            return false;
        }
        ByteBuffer b = ByteBuffer.allocate(maxLen);
        b.put(randomAccess);
        b.rewind();
        this.readFromByteBuffer(b);
        randomAccess = null;
        return true;
    }

    @Override
    public boolean writeToByteBuffer(ByteBuffer b) {
        b.putInt(this.numTransitions);
        b.putInt(this.numStates);
        b.putInt(this.transitionSize);
        b.putInt(this.nextTransitionInfoOffset);
        b.putShort(this.nextTransitionInfoFLAG);
        b.putInt(this.lastTransitionInfoOffset);
        b.putShort(this.lastTransitionInfoFLAG);
        b.putInt(this.isFinalTransitionOffset);
        b.putShort(this.isFinalTransitionFLAG);
        b.putInt(this.pointsToSentinelOffset);
        b.putShort(this.pointsToSentinelFLAG);
        b.putInt(this.usesRelativePointerOffset);
        b.putShort(this.usesRelativePointerFLAG);
        b.putInt(this.isNegativeOffset);
        b.putShort(this.isNegativeFLAG);
        b.putInt(this.labelBytes);
        b.putInt(this.labelFLAG);
        b.putInt(this.jumpTransitionOffset);
        b.putInt(this.jumpTransitionNumBytes);
        b.putInt(this.alphabet.length);
        for (int i = 0; i < this.alphabet.length; ++i) {
            b.putChar(this.alphabet[i]);
        }
        b.putInt(this.transitions.length);
        b.put(this.transitions);
        return true;
    }

    @Override
    public boolean writeToDataOutputStream(DataOutputStream d) throws IOException {
        d.writeInt(this.numTransitions);
        d.writeInt(this.numStates);
        d.writeInt(this.transitionSize);
        d.writeInt(this.nextTransitionInfoOffset);
        d.writeShort(this.nextTransitionInfoFLAG);
        d.writeInt(this.lastTransitionInfoOffset);
        d.writeShort(this.lastTransitionInfoFLAG);
        d.writeInt(this.isFinalTransitionOffset);
        d.writeShort(this.isFinalTransitionFLAG);
        d.writeInt(this.pointsToSentinelOffset);
        d.writeShort(this.pointsToSentinelFLAG);
        d.writeInt(this.usesRelativePointerOffset);
        d.writeShort(this.usesRelativePointerFLAG);
        d.writeInt(this.isNegativeOffset);
        d.writeShort(this.isNegativeFLAG);
        d.writeInt(this.labelBytes);
        d.writeInt(this.labelFLAG);
        d.writeInt(this.jumpTransitionOffset);
        d.writeInt(this.jumpTransitionNumBytes);
        d.writeInt(this.alphabet.length);
        for (int i = 0; i < this.alphabet.length; ++i) {
            d.writeChar(this.alphabet[i]);
        }
        d.writeInt(this.transitions.length);
        d.write(this.transitions, 0, this.transitions.length);
        return true;
    }

    @Override
    public boolean readFromDataInputStream(DataInputStream d) throws IOException {
        int i;
        this.numTransitions = d.readInt();
        this.numStates = d.readInt();
        this.transitionSize = d.readInt();
        this.nextTransitionInfoOffset = d.readInt();
        this.nextTransitionInfoFLAG = d.readShort();
        this.lastTransitionInfoOffset = d.readInt();
        this.lastTransitionInfoFLAG = d.readShort();
        this.isFinalTransitionOffset = d.readInt();
        this.isFinalTransitionFLAG = d.readShort();
        this.pointsToSentinelOffset = d.readInt();
        this.pointsToSentinelFLAG = d.readShort();
        this.usesRelativePointerOffset = d.readInt();
        this.usesRelativePointerFLAG = d.readShort();
        this.isNegativeOffset = d.readInt();
        this.isNegativeFLAG = d.readShort();
        this.labelBytes = d.readInt();
        this.labelFLAG = d.readInt();
        this.jumpTransitionOffset = d.readInt();
        this.jumpTransitionNumBytes = d.readInt();
        int size = d.readInt();
        this.alphabet = new char[size];
        for (i = 0; i < size; ++i) {
            this.alphabet[i] = d.readChar();
        }
        this.charEncoding = new int[65536];
        Arrays.fill(this.charEncoding, -1);
        for (i = 0; i < size; ++i) {
            this.charEncoding[this.alphabet[i]] = i;
        }
        size = d.readInt();
        this.transitions = new byte[size];
        d.readFully(this.transitions, 0, size);
        return true;
    }

    @Override
    public boolean readFromByteBuffer(ByteBuffer b) {
        int i;
        this.numTransitions = b.getInt();
        this.numStates = b.getInt();
        this.transitionSize = b.getInt();
        this.nextTransitionInfoOffset = b.getInt();
        this.nextTransitionInfoFLAG = b.getShort();
        this.lastTransitionInfoOffset = b.getInt();
        this.lastTransitionInfoFLAG = b.getShort();
        this.isFinalTransitionOffset = b.getInt();
        this.isFinalTransitionFLAG = b.getShort();
        this.pointsToSentinelOffset = b.getInt();
        this.pointsToSentinelFLAG = b.getShort();
        this.usesRelativePointerOffset = b.getInt();
        this.usesRelativePointerFLAG = b.getShort();
        this.isNegativeOffset = b.getInt();
        this.isNegativeFLAG = b.getShort();
        this.labelBytes = b.getInt();
        this.labelFLAG = b.getInt();
        this.jumpTransitionOffset = b.getInt();
        this.jumpTransitionNumBytes = b.getInt();
        int size = b.getInt();
        this.alphabet = new char[size];
        for (i = 0; i < size; ++i) {
            this.alphabet[i] = b.getChar();
        }
        this.charEncoding = new int[65536];
        Arrays.fill(this.charEncoding, -1);
        for (i = 0; i < size; ++i) {
            this.charEncoding[this.alphabet[i]] = i;
        }
        size = b.getInt();
        this.transitions = new byte[size];
        b.get(this.transitions);
        return true;
    }

    private final class State
    implements DictionaryLetterFSA.State {
        private int offset;

        @Override
        public DictionaryLetterFSA.Transition getFirstTransition() {
            return new Transition(this.offset);
        }

        public State(int offset) {
            this.offset = offset;
        }

        @Override
        public DictionaryLetterFSA.Transition getNextTransition(DictionaryLetterFSA.Transition transition) {
            Transition myTransition = (Transition)transition;
            if (myTransition.isLast()) {
                return null;
            }
            if (myTransition.next() || myTransition.pointsToSentinel()) {
                return new Transition(myTransition.offset + DictionaryLetterFSAImpl_2.this.jumpTransitionOffset);
            }
            if (myTransition.usesRelativePointer()) {
                return new Transition(myTransition.offset + DictionaryLetterFSAImpl_2.this.jumpTransitionOffset + 1);
            }
            return new Transition(myTransition.offset + DictionaryLetterFSAImpl_2.this.transitionSize);
        }

        @Override
        public DictionaryLetterFSA.Transition getTransitionLabelledWith(char label) {
            DictionaryLetterFSA.Transition currentTransition = this.getFirstTransition();
            while (currentTransition != null) {
                if (currentTransition.getLabel() == label) {
                    return currentTransition;
                }
                currentTransition = this.getNextTransition(currentTransition);
            }
            return null;
        }

        public boolean equals(Object s) {
            return this.offset == ((State)s).offset;
        }
    }

    private final class Transition
    implements DictionaryLetterFSA.Transition {
        private int offset;

        @Override
        public DictionaryLetterFSA.State getTargetState() {
            if ((DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.pointsToSentinelOffset] & DictionaryLetterFSAImpl_2.this.pointsToSentinelFLAG) != 0) {
                return null;
            }
            if ((DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.nextTransitionInfoOffset] & DictionaryLetterFSAImpl_2.this.nextTransitionInfoFLAG) != 0) {
                return new State(this.offset + DictionaryLetterFSAImpl_2.this.jumpTransitionOffset);
            }
            if ((DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.usesRelativePointerOffset] & DictionaryLetterFSAImpl_2.this.usesRelativePointerFLAG) != 0) {
                if ((DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.isNegativeOffset] & DictionaryLetterFSAImpl_2.this.isNegativeFLAG) != 0) {
                    return new State(this.offset - Memory.convertByteArrayToInt(DictionaryLetterFSAImpl_2.this.transitions, this.offset + DictionaryLetterFSAImpl_2.this.jumpTransitionOffset, 1));
                }
                return new State(this.offset + Memory.convertByteArrayToInt(DictionaryLetterFSAImpl_2.this.transitions, this.offset + DictionaryLetterFSAImpl_2.this.jumpTransitionOffset, 1));
            }
            return new State(Memory.convertByteArrayToInt(DictionaryLetterFSAImpl_2.this.transitions, this.offset + DictionaryLetterFSAImpl_2.this.jumpTransitionOffset, DictionaryLetterFSAImpl_2.this.jumpTransitionNumBytes));
        }

        protected boolean isLast() {
            return (DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.lastTransitionInfoOffset] & DictionaryLetterFSAImpl_2.this.lastTransitionInfoFLAG) != 0;
        }

        public Transition(int offset) {
            this.offset = offset;
        }

        @Override
        public char getLabel() {
            if (DictionaryLetterFSAImpl_2.this.labelBytes == 1) {
                return DictionaryLetterFSAImpl_2.this.alphabet[DictionaryLetterFSAImpl_2.this.transitions[this.offset] & DictionaryLetterFSAImpl_2.this.labelFLAG];
            }
            return DictionaryLetterFSAImpl_2.this.alphabet[DictionaryLetterFSAImpl_2.this.transitions[this.offset] & 0xFF | (DictionaryLetterFSAImpl_2.this.transitions[this.offset + 1] & DictionaryLetterFSAImpl_2.this.labelFLAG) << 8];
        }

        @Override
        public boolean pointsToFinalState() {
            return (DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.isFinalTransitionOffset] & DictionaryLetterFSAImpl_2.this.isFinalTransitionFLAG) != 0;
        }

        protected boolean pointsToSentinel() {
            return (DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.pointsToSentinelOffset] & DictionaryLetterFSAImpl_2.this.pointsToSentinelFLAG) != 0;
        }

        protected boolean next() {
            return (DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.nextTransitionInfoOffset] & DictionaryLetterFSAImpl_2.this.nextTransitionInfoFLAG) != 0;
        }

        protected boolean usesRelativePointer() {
            return (DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.usesRelativePointerOffset] & DictionaryLetterFSAImpl_2.this.usesRelativePointerFLAG) != 0;
        }

        protected boolean isNegative() {
            return (DictionaryLetterFSAImpl_2.this.transitions[this.offset + DictionaryLetterFSAImpl_2.this.isNegativeOffset] & DictionaryLetterFSAImpl_2.this.isNegativeFLAG) != 0;
        }
    }
}

