/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;

public final class DictionaryLetterFSAStatesArrayList {
    private transient DictionaryLetterFSA.State[] elementData;
    private int size;
    private int minCapacity;

    public DictionaryLetterFSAStatesArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new DictionaryLetterFSA.State[initialCapacity];
    }

    public DictionaryLetterFSAStatesArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            DictionaryLetterFSA.State[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new DictionaryLetterFSA.State[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public DictionaryLetterFSA.State get(int index) {
        return this.elementData[index];
    }

    public void set(int index, DictionaryLetterFSA.State value) {
        this.elementData[index] = value;
    }

    public boolean add(DictionaryLetterFSA.State o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            DictionaryLetterFSA.State[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new DictionaryLetterFSA.State[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public DictionaryLetterFSA.State removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public DictionaryLetterFSA.State remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        DictionaryLetterFSA.State temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }
}

