/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.functions.Files;
import piskorski.util.functions.Memory;

public class DictionaryLetterFSA_Impl_TransMatrixCompressed
extends DictionaryLetterFSA {
    private int numTransitions;
    private int numStates;
    private char[] alphabet;
    private boolean[] isFinal;
    private int[] row;
    private byte[] transitions;
    private byte[] owner;
    private int numBytesForTransition;
    private int undefinedState;
    private int initialState;
    private int[] symbolIndex;
    private static final int UNDEFINED_SYMBOL = -1;

    @Override
    public int getNumberOfTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumberOfStates() {
        return this.numStates;
    }

    @Override
    public CharacterArrayList getAlphabet() {
        CharacterArrayList result = new CharacterArrayList();
        for (int i = 0; i < this.alphabet.length; ++i) {
            result.add(this.alphabet[i]);
        }
        return result;
    }

    @Override
    public DictionaryLetterFSA.State getInitialState() {
        return new State(this.initialState);
    }

    @Override
    public void initializeFrom(LetterFSAInterface A) {
        int i;
        this.numStates = A.getNumberOfStates();
        this.numTransitions = A.getNumberOfTransitions();
        CharacterArrayList alphabet = A.getAlphabet();
        int len = alphabet.size();
        this.alphabet = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            this.alphabet[i2] = alphabet.get(i2);
        }
        this.isFinal = new boolean[this.numStates];
        Arrays.fill(this.isFinal, false);
        HashMap<Integer, Integer> stateID = new HashMap<Integer, Integer>();
        IntArrayList states = A.getStates();
        len = states.size();
        for (i = 0; i < len; ++i) {
            int nextState = states.get(i);
            stateID.put(new Integer(nextState), new Integer(i));
            if (!A.isFinalState(nextState)) continue;
            this.isFinal[i] = true;
        }
        this.initialState = (Integer)stateID.get(new Integer(A.getInitialState()));
        this.symbolIndex = new int[65536];
        Arrays.fill(this.symbolIndex, -1);
        len = this.alphabet.length;
        for (i = 0; i < len; ++i) {
            this.symbolIndex[this.alphabet[i]] = i;
        }
        this.undefinedState = this.numStates + 1;
        this.row = new int[this.numStates];
        this.numBytesForTransition = Memory.howManyBytes(this.numStates + 1);
        IntArrayList trans = new IntArrayList(this.numStates * this.alphabet.length / 2);
        IntArrayList own = new IntArrayList(this.numStates * this.alphabet.length / 2);
        int[] tempTrans = new int[this.alphabet.length];
        int currentStart = 0;
        for (int i3 = 0; i3 < this.numStates; ++i3) {
            int k;
            Arrays.fill(tempTrans, this.undefinedState);
            int nextState = states.get(i3);
            int nextStateID = (Integer)stateID.get(new Integer(nextState));
            TransitionArrayList transitions = A.getTransitions(nextState);
            int numTransitions = transitions.size();
            for (int j = 0; j < numTransitions; ++j) {
                int nextTarget = transitions.getTarget(j);
                int nextTargetID = (Integer)stateID.get(new Integer(nextTarget));
                char nextLabel = transitions.getSymbol(j);
                int nextLabelID = this.symbolIndex[nextLabel];
                tempTrans[nextLabelID] = nextTargetID;
            }
            while (currentStart < trans.size() && this.match(trans, tempTrans, currentStart)) {
                ++currentStart;
            }
            this.row[nextStateID] = currentStart;
            int howManyNewCells = len - (trans.size() - currentStart);
            for (k = 0; k < howManyNewCells; ++k) {
                trans.add(this.undefinedState);
                own.add(this.undefinedState);
            }
            len = tempTrans.length;
            for (k = 0; k < len; ++k) {
                if (tempTrans[k] == this.undefinedState) continue;
                trans.set(currentStart + k, tempTrans[k]);
                own.set(currentStart + k, nextStateID);
            }
        }
        len = trans.size();
        this.transitions = new byte[this.numBytesForTransition * len];
        this.owner = new byte[this.numBytesForTransition * len];
        int nextIndex = 0;
        for (int i4 = 0; i4 < len; ++i4) {
            Memory.convertIntToByteArray(trans.get(i4), this.transitions, nextIndex, this.numBytesForTransition);
            Memory.convertIntToByteArray(own.get(i4), this.owner, nextIndex, this.numBytesForTransition);
            nextIndex += this.numBytesForTransition;
        }
    }

    private boolean match(IntArrayList trans, int[] tempTrans, int index) {
        int len = tempTrans.length;
        for (int i = 0; i < len; ++i) {
            if (tempTrans[i] == this.undefinedState) continue;
            if (index + i >= trans.size()) break;
            if (trans.get(index + i) == this.undefinedState) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean saveToFile(String file) {
        byte[] fill = null;
        boolean status = true;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            status = this.writeToDataOutputStream(d);
            d.close();
            byteOS.close();
            if (status) {
                fill = byteOS.toByteArray();
            }
        }
        catch (IOException e) {
            return false;
        }
        if (status) {
            status = Files.writeByteArrayToFile(fill, file);
        }
        fill = null;
        return status;
    }

    @Override
    public boolean readFromFile(String file) {
        byte[] randomAccess = null;
        File FileName = new File(file);
        int size = (int)FileName.length();
        randomAccess = new byte[size];
        boolean status = Files.readByteArrayFromFile(randomAccess, file);
        if (!status) {
            return false;
        }
        try {
            ByteArrayInputStream byteIS = new ByteArrayInputStream(randomAccess);
            DataInputStream d = new DataInputStream(byteIS);
            this.readFromDataInputStream(d);
            d.close();
            byteIS.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeToDataOutputStream(DataOutputStream d) throws IOException {
        int i;
        d.writeInt(this.numTransitions);
        d.writeInt(this.numStates);
        d.writeInt(this.initialState);
        int len = this.alphabet.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeChar(this.alphabet[i]);
        }
        len = this.symbolIndex.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeInt(this.symbolIndex[i]);
        }
        len = this.numStates;
        for (i = 0; i < len; ++i) {
            d.writeBoolean(this.isFinal[i]);
        }
        d.writeInt(this.numBytesForTransition);
        d.writeInt(this.undefinedState);
        for (i = 0; i < this.numStates; ++i) {
            d.writeInt(this.row[i]);
        }
        d.writeInt(this.transitions.length);
        d.write(this.transitions);
        d.write(this.owner);
        return true;
    }

    @Override
    public boolean readFromDataInputStream(DataInputStream d) throws IOException {
        int i;
        this.numTransitions = d.readInt();
        this.numStates = d.readInt();
        this.initialState = d.readInt();
        int len = d.readInt();
        this.alphabet = new char[len];
        for (i = 0; i < len; ++i) {
            this.alphabet[i] = d.readChar();
        }
        len = d.readInt();
        this.symbolIndex = new int[len];
        for (i = 0; i < len; ++i) {
            this.symbolIndex[i] = d.readInt();
        }
        this.isFinal = new boolean[this.numStates];
        for (i = 0; i < this.isFinal.length; ++i) {
            this.isFinal[i] = d.readBoolean();
        }
        this.numBytesForTransition = d.readInt();
        this.undefinedState = d.readInt();
        this.row = new int[this.numStates];
        for (i = 0; i < this.numStates; ++i) {
            this.row[i] = d.readInt();
        }
        len = d.readInt();
        this.transitions = new byte[len];
        this.owner = new byte[len];
        for (i = 0; i < len; ++i) {
            this.transitions[i] = d.readByte();
        }
        for (i = 0; i < len; ++i) {
            this.owner[i] = d.readByte();
        }
        return true;
    }

    @Override
    public boolean writeToByteBuffer(ByteBuffer b) {
        return true;
    }

    @Override
    public boolean readFromByteBuffer(ByteBuffer b) {
        return true;
    }

    private final class Transition
    implements DictionaryLetterFSA.Transition {
        private int state;
        private int index;

        @Override
        public DictionaryLetterFSA.State getTargetState() {
            return new State(Memory.convertByteArrayToInt(DictionaryLetterFSA_Impl_TransMatrixCompressed.this.transitions, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.row[this.state] + this.index * DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition));
        }

        public Transition(int state, int index) {
            this.state = state;
            this.index = index;
        }

        @Override
        public char getLabel() {
            return DictionaryLetterFSA_Impl_TransMatrixCompressed.this.alphabet[this.index];
        }

        @Override
        public boolean pointsToFinalState() {
            return DictionaryLetterFSA_Impl_TransMatrixCompressed.this.isFinal[Memory.convertByteArrayToInt(DictionaryLetterFSA_Impl_TransMatrixCompressed.this.transitions, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.row[this.state] + this.index * DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition)];
        }
    }

    private final class State
    implements DictionaryLetterFSA.State {
        private int state;

        @Override
        public DictionaryLetterFSA.Transition getFirstTransition() {
            int len = DictionaryLetterFSA_Impl_TransMatrixCompressed.this.alphabet.length;
            int nextPotTrans = DictionaryLetterFSA_Impl_TransMatrixCompressed.this.row[this.state];
            for (int i = 0; i < len; ++i) {
                int ownedBy = Memory.convertByteArrayToInt(DictionaryLetterFSA_Impl_TransMatrixCompressed.this.owner, nextPotTrans, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition);
                if (ownedBy == this.state) {
                    return new Transition(this.state, i);
                }
                nextPotTrans += DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition;
            }
            return null;
        }

        public State(int state) {
            this.state = state;
        }

        @Override
        public DictionaryLetterFSA.Transition getNextTransition(DictionaryLetterFSA.Transition transition) {
            Transition myTransition = (Transition)transition;
            int count = myTransition.index + 1;
            int len = DictionaryLetterFSA_Impl_TransMatrixCompressed.this.alphabet.length;
            int nextPotTrans = DictionaryLetterFSA_Impl_TransMatrixCompressed.this.row[this.state] + count * DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition;
            while (count < len) {
                int ownedBy = Memory.convertByteArrayToInt(DictionaryLetterFSA_Impl_TransMatrixCompressed.this.owner, nextPotTrans, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition);
                if (ownedBy == this.state) {
                    return new Transition(this.state, count);
                }
                ++count;
                nextPotTrans += DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition;
            }
            return null;
        }

        @Override
        public DictionaryLetterFSA.Transition getTransitionLabelledWith(char label) {
            if (DictionaryLetterFSA_Impl_TransMatrixCompressed.this.symbolIndex[label] == -1) {
                return null;
            }
            int where = DictionaryLetterFSA_Impl_TransMatrixCompressed.this.row[this.state] + DictionaryLetterFSA_Impl_TransMatrixCompressed.this.symbolIndex[label] * DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition;
            if (Memory.convertByteArrayToInt(DictionaryLetterFSA_Impl_TransMatrixCompressed.this.owner, where, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.numBytesForTransition) == this.state) {
                return new Transition(this.state, DictionaryLetterFSA_Impl_TransMatrixCompressed.this.symbolIndex[label]);
            }
            return null;
        }

        public boolean equals(Object s) {
            return this.state == ((State)s).state;
        }
    }
}

