/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.util.Arrays;
import piskorski.fs.letterfs.fsa.AbstractLetterFSA;
import piskorski.fs.letterfs.fsa.DynamicLetterMarkedFSAInterface;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.BooleanArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;

public class DynamicLetterMarkedFSA_Impl
extends AbstractLetterFSA
implements DynamicLetterMarkedFSAInterface {
    private IntArrayList states;
    private BooleanArrayList finalStates;
    private BooleanArrayList markedStates;
    private IntArrayList targets;
    private CharacterArrayList symbols;
    private IntArrayList next;
    private IntArrayList freeStates;
    private IntArrayList freeTransitions;
    private BooleanArrayList isState;
    private boolean stateMarkingActive;
    private int[] firstStatTransitions;

    @Override
    public int getInitialState() {
        return 0;
    }

    @Override
    public void unmarkState(int state) {
        if (this.isState.get(state)) {
            this.markedStates.set(state, false);
        }
    }

    @Override
    public void markState(int state) {
        if (this.isState.get(state)) {
            this.markedStates.set(state, true);
        }
    }

    @Override
    public boolean isMarkedState(int state) {
        if (this.isState.get(state)) {
            return this.markedStates.get(state);
        }
        return false;
    }

    @Override
    public boolean isFinalState(int state) {
        if (this.isState.get(state)) {
            return this.finalStates.get(state);
        }
        return false;
    }

    @Override
    public TransitionArrayList getTransitions(int source) {
        if (!this.isState.get(source)) {
            return null;
        }
        TransitionArrayList T = new TransitionArrayList();
        int nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            T.add(this.targets.get(nextEdgeIndex), this.symbols.get(nextEdgeIndex));
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return T;
    }

    @Override
    public boolean hasTransitions(int source) {
        return this.getFirstEdge(source) != -1;
    }

    private int getFirstEdge(int state) {
        if (!this.isState.get(state)) {
            return -1;
        }
        return this.states.get(state);
    }

    private int getTargetState(int edgeIndex) {
        if (edgeIndex < 0) {
            return -1;
        }
        return this.targets.get(edgeIndex);
    }

    @Override
    public int getFirstTargetState(int source, char symbol) {
        if (!this.isState.get(source)) {
            return -1;
        }
        int nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol) {
                return this.targets.get(nextEdgeIndex);
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return -1;
    }

    @Override
    public IntArrayList getAllTargetStates(int source, char symbol) {
        IntArrayList Targets = new IntArrayList();
        if (this.isState.get(source)) {
            int nextEdgeIndex = this.states.get(source);
            while (nextEdgeIndex != -1) {
                if (this.symbols.get(nextEdgeIndex) == symbol) {
                    Targets.add(this.targets.get(nextEdgeIndex));
                    continue;
                }
                nextEdgeIndex = this.next.get(nextEdgeIndex);
            }
        }
        return Targets;
    }

    @Override
    public IntArrayList getStates() {
        IntArrayList States = new IntArrayList(this.getNumberOfStates() + 1);
        int len = this.states.size();
        for (int i = 0; i < len; ++i) {
            if (!this.isState.get(i)) continue;
            States.add(i);
        }
        return States;
    }

    @Override
    public CharacterArrayList getAlphabet() {
        int i;
        IntArrayList States = this.getStates();
        CharacterArrayList CharList = new CharacterArrayList(65536);
        boolean[] charCheck = new boolean[65536];
        Arrays.fill(charCheck, false);
        for (i = 0; i < States.size(); ++i) {
            TransitionArrayList TransList = this.getTransitions(States.get(i));
            for (int j = 0; j < TransList.size(); ++j) {
                charCheck[TransList.getSymbol((int)j)] = true;
            }
        }
        for (i = 0; i < 65536; ++i) {
            if (!charCheck[i]) continue;
            CharList.add((char)i);
        }
        return CharList;
    }

    @Override
    public int addState() {
        if (!this.freeStates.empty()) {
            int which = this.freeStates.removeLast();
            this.isState.set(which, true);
            this.finalStates.set(which, false);
            this.states.set(which, -1);
            this.markedStates.set(which, false);
            ++this.numStates;
            return which;
        }
        this.isState.add(true);
        this.finalStates.add(false);
        this.states.add(-1);
        this.markedStates.add(false);
        ++this.numStates;
        return this.states.size() - 1;
    }

    @Override
    public int removeState(int state) {
        if (this.isState.get(state)) {
            this.removeAllTransitionsFromState(state);
            this.freeStates.add(state);
            this.markedStates.set(state, false);
            this.isState.set(state, false);
            --this.numStates;
        }
        return this.numStates;
    }

    @Override
    public boolean setFinalState(int state) {
        if (this.isState.get(state)) {
            this.finalStates.set(state, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean setNonFinalState(int state) {
        if (this.isState.get(state)) {
            this.finalStates.set(state, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTransition(int source, int target, char symbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target && this.symbols.get(nextEdgeIndex) == symbol) {
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        if (!this.freeTransitions.empty()) {
            nextEdgeIndex = this.freeTransitions.removeLast();
            this.targets.set(nextEdgeIndex, target);
            this.symbols.set(nextEdgeIndex, symbol);
            this.next.set(nextEdgeIndex, firstEdgeIndex);
            this.states.set(source, nextEdgeIndex);
        } else {
            nextEdgeIndex = this.targets.size();
            this.targets.add(target);
            this.symbols.add(symbol);
            this.next.add(firstEdgeIndex);
            this.states.set(source, nextEdgeIndex);
        }
        ++this.numTransitions;
        return true;
    }

    @Override
    public void removeAllTransitionsFromState(int state) {
        if (this.isState.get(state)) {
            int nextEdge = this.getFirstEdge(state);
            this.states.set(state, -1);
            while (nextEdge != -1) {
                this.freeTransitions.add(nextEdge);
                --this.numTransitions;
                nextEdge = this.next.get(nextEdge);
            }
        }
    }

    @Override
    public boolean removeTransition(int source, char symbol) {
        if (!this.isState.get(source)) {
            return false;
        }
        boolean found = false;
        int nextEdgeIndex = this.states.get(source);
        int previousEdge = -1;
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol) {
                found = true;
                int nextEdge = this.next.get(nextEdgeIndex);
                if (previousEdge != -1) {
                    this.next.set(previousEdge, nextEdge);
                } else if (nextEdge != -1) {
                    this.states.set(source, nextEdge);
                } else {
                    this.states.set(source, -1);
                }
                this.freeTransitions.add(nextEdgeIndex);
                --this.numTransitions;
                nextEdgeIndex = nextEdge;
                continue;
            }
            previousEdge = nextEdgeIndex;
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return found;
    }

    @Override
    public boolean removeFirstTransition(int source, char symbol) {
        if (!this.isState.get(source)) {
            return false;
        }
        int nextEdgeIndex = this.states.get(source);
        int previousEdge = -1;
        while (nextEdgeIndex != -1 && this.symbols.get(nextEdgeIndex) != symbol) {
            previousEdge = nextEdgeIndex;
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        if (nextEdgeIndex == -1) {
            return false;
        }
        int nextEdge = this.next.get(nextEdgeIndex);
        if (previousEdge != -1) {
            this.next.set(previousEdge, nextEdge);
        } else if (nextEdge != -1) {
            this.states.set(source, nextEdge);
        } else {
            this.states.set(source, -1);
        }
        this.freeTransitions.add(nextEdgeIndex);
        --this.numTransitions;
        return true;
    }

    @Override
    public boolean removeTransition(int source, int target) {
        if (!this.isState.get(source)) {
            return false;
        }
        boolean found = false;
        int nextEdgeIndex = this.states.get(source);
        int previousEdge = -1;
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target) {
                found = true;
                int nextEdge = this.next.get(nextEdgeIndex);
                if (previousEdge != -1) {
                    this.next.set(previousEdge, nextEdge);
                } else if (nextEdge != -1) {
                    this.states.set(source, nextEdge);
                } else {
                    this.states.set(source, -1);
                }
                this.freeTransitions.add(nextEdgeIndex);
                --this.numTransitions;
                nextEdgeIndex = nextEdge;
                continue;
            }
            previousEdge = nextEdgeIndex;
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return found;
    }

    @Override
    public boolean removeFirstTransition(int source, int target) {
        if (!this.isState.get(source)) {
            return false;
        }
        int nextEdgeIndex = this.states.get(source);
        int previousEdge = -1;
        while (nextEdgeIndex != -1 && this.targets.get(nextEdgeIndex) != target) {
            previousEdge = nextEdgeIndex;
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        if (nextEdgeIndex == -1) {
            return false;
        }
        int nextEdge = this.next.get(nextEdgeIndex);
        if (previousEdge != -1) {
            this.next.set(previousEdge, nextEdge);
        } else if (nextEdge != -1) {
            this.states.set(source, nextEdge);
        } else {
            this.states.set(source, -1);
        }
        this.freeTransitions.add(nextEdgeIndex);
        --this.numTransitions;
        return true;
    }

    @Override
    public boolean addBranch(int state, String word) {
        if (!this.isState.get(state)) {
            return false;
        }
        int len = word.length();
        int lastState = state;
        for (int i = 0; i < len; ++i) {
            int nextState = this.addState();
            this.addTransition(lastState, nextState, word.charAt(i));
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return true;
    }

    @Override
    public IntArrayList addWordReturnNewStates(int state, String word) {
        if (!this.isState.get(state)) {
            return null;
        }
        IntArrayList newStates = new IntArrayList();
        int len = word.length();
        int lastState = state;
        for (int i = 0; i < len; ++i) {
            int nextState = this.addState();
            this.addTransition(lastState, nextState, word.charAt(i));
            newStates.add(nextState);
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return newStates;
    }

    @Override
    public boolean addWord(int state, String word, int start) {
        if (!this.isState.get(state)) {
            return false;
        }
        int len = word.length();
        int lastState = state;
        int i = start;
        while (i < len) {
            int nextState = this.addState();
            this.addTransition(lastState, nextState, word.charAt(i++));
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return true;
    }

    @Override
    public IntArrayList addWordReturnNewStates(int state, String word, int start) {
        if (!this.isState.get(state)) {
            return null;
        }
        IntArrayList newStates = new IntArrayList();
        int len = word.length();
        int lastState = state;
        int i = start;
        while (i < len) {
            int nextState = this.addState();
            this.addTransition(lastState, nextState, word.charAt(i++));
            newStates.add(nextState);
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return newStates;
    }

    @Override
    public boolean replaceTransition(int source, int target, char symbol, int newTarget, char newSymbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        boolean replaced = false;
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target && this.symbols.get(nextEdgeIndex) == symbol) {
                this.targets.set(nextEdgeIndex, newTarget);
                this.symbols.set(nextEdgeIndex, newSymbol);
                replaced = true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return replaced;
    }

    @Override
    public boolean replaceFirstTransition(int source, int target, char symbol, int newTarget, char newSymbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target && this.symbols.get(nextEdgeIndex) == symbol) {
                this.targets.set(nextEdgeIndex, newTarget);
                this.symbols.set(nextEdgeIndex, newSymbol);
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    @Override
    public boolean modifyTargetInTransitions(int source, int target, int newTarget) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        boolean modified = false;
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target) {
                this.targets.set(nextEdgeIndex, newTarget);
                modified = true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return modified;
    }

    @Override
    public boolean modifyTargetInFirstTransition(int source, int target, int newTarget) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target) {
                this.targets.set(nextEdgeIndex, newTarget);
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    @Override
    public boolean modifyLabelInTransitions(int source, char symbol, char newSymbol) {
        if (!this.isState.get(source)) {
            return false;
        }
        int nextEdgeIndex = this.states.get(source);
        boolean modified = false;
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol) {
                this.symbols.set(nextEdgeIndex, newSymbol);
                modified = true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return modified;
    }

    @Override
    public boolean modifyLabelInFirstTransition(int source, char symbol, char newSymbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol) {
                this.symbols.set(nextEdgeIndex, newSymbol);
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    @Override
    public boolean modifyLabelInTransition(int source, int target, char symbol, char newSymbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol && this.targets.get(nextEdgeIndex) == target) {
                this.symbols.set(nextEdgeIndex, newSymbol);
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    @Override
    public boolean modifyTargetInTransition(int source, int target, char symbol, int newTarget) {
        int nextEdgeIndex;
        if (!this.isState.get(source)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol && this.targets.get(nextEdgeIndex) == target) {
                this.targets.set(nextEdgeIndex, newTarget);
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    private void standardInit() {
        this.states = new IntArrayList();
        this.finalStates = new BooleanArrayList();
        this.targets = new IntArrayList();
        this.symbols = new CharacterArrayList();
        this.next = new IntArrayList();
        this.freeStates = new IntArrayList();
        this.freeTransitions = new IntArrayList();
        this.isState = new BooleanArrayList();
        this.numStates = 0;
        this.numTransitions = 0;
        this.markedStates = new BooleanArrayList();
        this.addState();
    }

    public DynamicLetterMarkedFSA_Impl() {
        this.standardInit();
    }

    public DynamicLetterMarkedFSA_Impl(int numStates, int numTransitions) {
        this.states = new IntArrayList(numStates);
        this.finalStates = new BooleanArrayList(numStates);
        this.isState = new BooleanArrayList(numStates);
        this.targets = new IntArrayList(numTransitions);
        this.symbols = new CharacterArrayList(numTransitions);
        this.next = new IntArrayList(numTransitions);
        this.freeStates = new IntArrayList();
        this.freeTransitions = new IntArrayList();
        this.numStates = 0;
        this.numTransitions = 0;
        this.markedStates = new BooleanArrayList(numStates);
        this.addState();
    }
}

