/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.util.Arrays;
import piskorski.fs.letterfs.fsa.InOutDegree;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;

public final class FSAAuxilliaryFunctions {
    public static int outDegree(LetterFSAInterface A, int state) {
        boolean numTrans = false;
        TransitionArrayList T = A.getTransitions(state);
        if (T != null) {
            return T.size();
        }
        return -1;
    }

    public static InOutDegree[] inOutDegree(LetterFSAInterface A) {
        IntArrayList States = A.getStates();
        int len = States.size();
        if (len == 0) {
            return null;
        }
        int maxIndex = 0;
        int max = States.get(0);
        for (int i = 1; i < len; ++i) {
            if (States.get(i) <= max) continue;
            maxIndex = i;
        }
        InOutDegree[] iOMap = new InOutDegree[++maxIndex + 1];
        for (int i = 0; i <= maxIndex; ++i) {
            iOMap[i] = new InOutDegree(-1, -1);
        }
        for (int state = 0; state < len; ++state) {
            TransitionArrayList T = A.getTransitions(States.get(state));
            for (int j = 0; j < T.size(); ++j) {
                int targetState = T.getTarget(j);
                if (iOMap[state].getOutDegree() != -1) {
                    iOMap[state].incrementOutDegree();
                } else {
                    iOMap[state].set(0, 1);
                }
                if (iOMap[targetState].getInDegree() != -1) {
                    iOMap[targetState].incrementInDegree();
                    continue;
                }
                iOMap[targetState].set(1, 0);
            }
        }
        return iOMap;
    }

    public static boolean[] computeCharInAlphabetArray(LetterFSAInterface A) {
        boolean[] isInAlphabet = new boolean[65536];
        Arrays.fill(isInAlphabet, false);
        CharacterArrayList charList = A.getAlphabet();
        for (int i = 0; i < charList.size(); ++i) {
            isInAlphabet[charList.get((int)i)] = true;
        }
        return isInAlphabet;
    }

    public static void printOverview(LetterFSAInterface A) {
        IntArrayList States = A.getStates();
        int numFinal = 0;
        for (int i = 0; i < States.size(); ++i) {
            if (!A.isFinalState(States.get(i))) continue;
            ++numFinal;
        }
        System.out.println("Number of States: " + A.getNumberOfStates());
        System.out.println("Number of Final States: " + numFinal);
        System.out.println("Number of Transitions: " + A.getNumberOfTransitions());
        System.out.println("Number of Symbols in the Alphabet: " + A.getAlphabet().size());
    }
}

