/*
 * Decompiled with CFR 0.152.
 */
package piskorski.obscure.fsm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import piskorski.fs.letterfs.fsa.FiniteStateProcessingException;

public class FSM
implements Serializable {
    static final long serialVersionUID = -1932216829980703105L;
    private int num_stat;
    private int ia_size;
    private int oa_size;
    private int num_trans;
    private int num_final;
    private float initialweight;
    private int initialstate;
    private float[] F_WEIGHT;
    private int[] ISFINAL;
    private int[] TR_OF;
    private int[] ADRESS;
    private int[] ARCS_SIGN;
    private int[] ARCS_TARGET;
    private float[] ARCS_WEIGHT;
    private int[] NUM_ARCS;
    private int[] ROWPT;
    private int[] NUM_SYMBOLS;
    private int[] POINTER_SYMBOLS;
    private int[] SYMBOLS;
    public static final int UNDEFINED = -1;
    public static final float DEFAULT_WEIGHT = 0.0f;
    private String[] I_ALPHABET;
    private String[] O_ALPHABET;
    private int a_tab_size;

    private void allocation() {
        this.F_WEIGHT = new float[this.num_final];
        this.ISFINAL = new int[this.num_stat];
        this.TR_OF = new int[this.a_tab_size];
        this.ADRESS = new int[this.a_tab_size];
        this.ARCS_SIGN = new int[this.num_trans];
        this.ARCS_TARGET = new int[this.num_trans];
        this.ARCS_WEIGHT = new float[this.num_trans];
        this.NUM_ARCS = new int[this.a_tab_size];
        this.ROWPT = new int[this.num_stat];
        this.I_ALPHABET = new String[this.ia_size];
        this.O_ALPHABET = new String[this.oa_size];
        this.NUM_SYMBOLS = new int[this.num_stat];
        this.POINTER_SYMBOLS = new int[this.num_stat];
        this.SYMBOLS = new int[this.num_trans];
    }

    public int num_states() {
        return this.num_stat;
    }

    public int num_transitions() {
        return this.num_trans;
    }

    public int ialphabet_size() {
        return this.ia_size;
    }

    public int oalphabet_size() {
        return this.oa_size;
    }

    public int num_finalstates() {
        return this.num_final;
    }

    public int initial_state() {
        return this.initialstate;
    }

    public float initial_weight() {
        return this.initialweight;
    }

    public float final_weight(int i) {
        if (i < 0 || i >= this.num_stat) {
            return 0.0f;
        }
        if (!this.is_final(i)) {
            return 0.0f;
        }
        return this.F_WEIGHT[this.ISFINAL[i]];
    }

    public int get_numarcs(int state, int sign) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return -1;
        }
        int index = this.ROWPT[state] + sign;
        return this.TR_OF[index] == state ? this.NUM_ARCS[index] : 0;
    }

    public float get_average_numarcs() {
        return (float)this.num_transitions() / (float)this.num_states();
    }

    public int get_num_nondeterministic_moves() {
        int nonDet = 0;
        for (int i = 0; i < this.num_states(); ++i) {
            for (int j = 0; j < this.get_num_symbols(i); ++j) {
                if (this.get_numarcs(i, this.get_symbol(i, j)) <= 1) continue;
                ++nonDet;
            }
        }
        return nonDet;
    }

    public int get_nextstate(int state, int sign) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return -1;
        }
        int index = this.ROWPT[state] + sign;
        return this.TR_OF[index] == state ? this.ARCS_TARGET[this.ADRESS[index]] : -1;
    }

    public int get_num_symbols(int state) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        return this.NUM_SYMBOLS[state];
    }

    public int get_symbol(int state, int i) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        if (i < 0 || i >= this.get_num_symbols(state)) {
            return -1;
        }
        return this.SYMBOLS[this.POINTER_SYMBOLS[state] + i];
    }

    public int get_nextstate(int state, int sign, int i) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return -1;
        }
        if (i < 0 || i >= this.get_numarcs(state, sign)) {
            return -1;
        }
        return this.ARCS_TARGET[this.ADRESS[this.ROWPT[state] + sign] + i];
    }

    public int get_output(int state, int sign) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return -1;
        }
        int index = this.ROWPT[state] + sign;
        return this.TR_OF[index] == state ? this.ARCS_SIGN[this.ADRESS[index]] : -1;
    }

    public int get_output(int state, int sign, int i) {
        if (state < 0 || state >= this.num_stat) {
            return -1;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return -1;
        }
        if (i < 0 || i >= this.get_numarcs(state, sign)) {
            return -1;
        }
        return this.ARCS_SIGN[this.ADRESS[this.ROWPT[state] + sign] + i];
    }

    public float get_cost(int state, int sign) {
        if (state < 0 || state >= this.num_stat) {
            return 0.0f;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return 0.0f;
        }
        int index = this.ROWPT[state] + sign;
        return this.TR_OF[index] == state ? this.ARCS_WEIGHT[this.ADRESS[index]] : 0.0f;
    }

    public float get_cost(int state, int sign, int i) {
        if (state < 0 || state >= this.num_stat) {
            return 0.0f;
        }
        if (sign < 0 || sign >= this.ia_size) {
            return 0.0f;
        }
        if (i < 0 || i >= this.get_numarcs(state, sign)) {
            return 0.0f;
        }
        return this.ARCS_WEIGHT[this.ADRESS[this.ROWPT[state] + sign] + i];
    }

    public String getstring_OA(int i) {
        if (i < 0 || i >= this.oa_size) {
            return null;
        }
        return this.O_ALPHABET[i];
    }

    public String getstring_IA(int i) {
        if (i < 0 || i >= this.ia_size) {
            return null;
        }
        return this.I_ALPHABET[i];
    }

    public boolean is_final(int state) {
        if (state < 0 || state >= this.num_stat) {
            return false;
        }
        return this.ISFINAL[state] >= 0;
    }

    public void print_info(boolean detailed) {
        System.out.println("FSM INFORMATION:");
        System.out.println("----------------");
        System.out.println("# of states: " + this.num_stat);
        System.out.println("# of symbols in input alphabet: " + this.ia_size);
        System.out.println("# of symbols in output alphabet: " + this.oa_size);
        System.out.println("# of transitions: " + this.num_trans);
        System.out.println("# of final_states: " + this.num_final);
        System.out.println("# of nondeterministic moves: " + this.get_num_nondeterministic_moves());
        System.out.println("# of average outgoing transitions: " + this.get_average_numarcs());
        if (detailed) {
            int i;
            System.out.println("DETAILED INFORMATION:");
            System.out.println("---------------------");
            System.out.println("INPUT ALPHABET:");
            System.out.println("---------------");
            for (i = 0; i < this.ia_size; ++i) {
                System.out.println(this.getstring_IA(i));
            }
            System.out.println("OUTPUT ALPHABET:");
            System.out.println("---------------");
            for (i = 0; i < this.oa_size; ++i) {
                System.out.println(this.getstring_OA(i));
            }
            System.out.println("STATES:");
            System.out.println("-------");
            System.out.println("Initial state: " + this.initialstate + "  Initial weight: " + this.initialweight);
            for (int state = 0; state < this.num_stat; ++state) {
                System.out.println("S: " + state);
                if (this.is_final(state)) {
                    System.out.println("is final state");
                    System.out.println("final weight: " + this.final_weight(state));
                }
                for (int j = 0; j < this.ia_size; ++j) {
                    int na = this.get_numarcs(state, j);
                    if (na <= 0) continue;
                    for (int k = 0; k < na; ++k) {
                        int target = this.get_nextstate(state, j, k);
                        int o_sign = this.get_output(state, j, k);
                        float weight = this.get_cost(state, j, k);
                        System.out.println("(" + state + "," + target + "," + this.getstring_IA(j) + "," + this.getstring_OA(o_sign) + "," + weight + ")");
                    }
                }
            }
        }
    }

    public void extraPrint(String fileName) throws FiniteStateProcessingException {
        int initialState = this.initial_state();
        try {
            int source;
            int i;
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "ISO-8859-1"));
            out.write(String.valueOf(this.num_stat));
            out.newLine();
            for (i = 0; i < this.num_stat; ++i) {
                boolean isFinal = this.is_final(i);
                source = i;
                if (source == initialState) {
                    source = 0;
                } else if (source == 0) {
                    source = initialState;
                }
                out.write(String.valueOf(source));
                out.write(32);
                out.write(isFinal ? String.valueOf(1) : String.valueOf(0));
                out.newLine();
            }
            for (i = 0; i < this.num_stat; ++i) {
                source = i;
                if (source == initialState) {
                    source = 0;
                } else if (source == 0) {
                    source = initialState;
                }
                int finalTarget = -1;
                String finalEmmision = null;
                int currentFinalValue = -1;
                for (int j = 0; j < this.ia_size; ++j) {
                    int na = this.get_numarcs(i, j);
                    if (na <= 0) continue;
                    for (int k = 0; k < na; ++k) {
                        int target = this.get_nextstate(i, j, k);
                        if (target == initialState) {
                            target = 0;
                        } else if (target == 0) {
                            target = initialState;
                        }
                        String sign = this.getstring_IA(j);
                        if (sign.charAt(0) == '$') {
                            sign = "\\u" + sign.substring(1);
                            out.write(String.valueOf(source));
                            out.write(32);
                            out.write(String.valueOf(target));
                            out.write(32);
                            out.write(sign);
                            out.newLine();
                            continue;
                        }
                        if (finalEmmision == null) {
                            finalEmmision = sign;
                            finalTarget = target;
                            currentFinalValue = Integer.valueOf(sign.substring(1));
                            continue;
                        }
                        int newFinalValue = Integer.valueOf(sign.substring(1));
                        if (newFinalValue >= currentFinalValue) continue;
                        finalEmmision = sign;
                        finalTarget = target;
                        currentFinalValue = newFinalValue;
                    }
                }
                if (finalEmmision == null) continue;
                out.write(String.valueOf(source));
                out.write(32);
                out.write(String.valueOf(finalTarget));
                out.write(32);
                out.write(finalEmmision);
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("IO Exception while processing file: " + fileName);
            System.exit(0);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public boolean save(String filename) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            BufferedOutputStream buf = new BufferedOutputStream(out);
            ObjectOutputStream s = new ObjectOutputStream(buf);
            s.writeObject(this);
            s.flush();
            s.close();
            buf.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean read(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            BufferedInputStream inBuf = new BufferedInputStream(in);
            ObjectInputStream s = new ObjectInputStream(inBuf);
            FSM F = (FSM)s.readObject();
            s.close();
            inBuf.close();
            in.close();
            this.set(F);
        }
        catch (IOException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static FSM readFSM(String filename) {
        FSM F;
        try {
            FileInputStream in = new FileInputStream(filename);
            BufferedInputStream inBuf = new BufferedInputStream(in);
            ObjectInputStream s = new ObjectInputStream(inBuf);
            F = (FSM)s.readObject();
            s.close();
            inBuf.close();
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return F;
    }

    public boolean read(InputStream in) {
        try {
            ObjectInputStream s = new ObjectInputStream(in);
            FSM F = (FSM)s.readObject();
            s.close();
            this.set(F);
        }
        catch (IOException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static FSM readFSM(InputStream in) {
        FSM F;
        try {
            ObjectInputStream s = new ObjectInputStream(in);
            F = (FSM)s.readObject();
            s.close();
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return F;
    }

    public boolean initialize(String filename) {
        boolean floating_exception = false;
        String FloatMem = new String();
        floating_exception = false;
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            in.readLine();
            FloatMem = in.readLine();
            char floatSeparatorInC = FloatMem.charAt(1);
            Float TestFloat = new Float(1.5);
            char floatSeparatorInJava = TestFloat.toString().charAt(1);
            floating_exception = floatSeparatorInC != floatSeparatorInJava;
            this.num_stat = Integer.valueOf(in.readLine());
            this.ia_size = Integer.valueOf(in.readLine());
            this.oa_size = Integer.valueOf(in.readLine());
            this.num_trans = Integer.valueOf(in.readLine());
            this.num_final = Integer.valueOf(in.readLine());
            if (floating_exception) {
                FloatMem = in.readLine();
                FloatMem = FloatMem.replace(floatSeparatorInC, floatSeparatorInJava);
                this.initialweight = Float.valueOf(FloatMem).floatValue();
            } else {
                this.initialweight = Float.valueOf(in.readLine()).floatValue();
            }
            this.initialstate = Integer.valueOf(in.readLine());
            this.a_tab_size = Integer.valueOf(in.readLine());
            this.allocation();
            if (floating_exception) {
                for (i = 0; i < this.num_final; ++i) {
                    FloatMem = in.readLine();
                    FloatMem = FloatMem.replace(floatSeparatorInC, floatSeparatorInJava);
                    this.F_WEIGHT[i] = Float.valueOf(FloatMem).floatValue();
                }
            } else {
                for (i = 0; i < this.num_final; ++i) {
                    this.F_WEIGHT[i] = Float.valueOf(in.readLine()).floatValue();
                }
            }
            for (i = 0; i < this.num_stat; ++i) {
                this.ISFINAL[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.a_tab_size; ++i) {
                this.TR_OF[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.a_tab_size; ++i) {
                this.ADRESS[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.num_trans; ++i) {
                this.ARCS_SIGN[i] = Integer.valueOf(in.readLine());
                this.ARCS_TARGET[i] = Integer.valueOf(in.readLine());
                if (floating_exception) {
                    FloatMem = in.readLine();
                    FloatMem = FloatMem.replace(floatSeparatorInC, floatSeparatorInJava);
                    this.ARCS_WEIGHT[i] = Float.valueOf(FloatMem).floatValue();
                    continue;
                }
                this.ARCS_WEIGHT[i] = Float.valueOf(in.readLine()).floatValue();
            }
            for (i = 0; i < this.a_tab_size; ++i) {
                this.NUM_ARCS[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.num_stat; ++i) {
                this.ROWPT[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.ia_size; ++i) {
                this.I_ALPHABET[i] = new String(in.readLine());
            }
            for (i = 0; i < this.oa_size; ++i) {
                this.O_ALPHABET[i] = new String(in.readLine());
            }
            for (i = 0; i < this.num_stat; ++i) {
                this.NUM_SYMBOLS[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.num_stat; ++i) {
                this.POINTER_SYMBOLS[i] = Integer.valueOf(in.readLine());
            }
            for (i = 0; i < this.num_trans; ++i) {
                this.SYMBOLS[i] = Integer.valueOf(in.readLine());
            }
            in.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void set(FSM A) {
        if (A == null) {
            return;
        }
        this.num_stat = A.num_stat;
        this.ia_size = A.ia_size;
        this.oa_size = A.oa_size;
        this.num_trans = A.num_trans;
        this.num_final = A.num_final;
        this.initialweight = A.initialweight;
        this.initialstate = A.initialstate;
        this.a_tab_size = A.a_tab_size;
        this.allocation();
        System.arraycopy(A.F_WEIGHT, 0, this.F_WEIGHT, 0, this.num_final);
        System.arraycopy(A.ISFINAL, 0, this.ISFINAL, 0, this.num_stat);
        System.arraycopy(A.TR_OF, 0, this.TR_OF, 0, this.a_tab_size);
        System.arraycopy(A.ADRESS, 0, this.ADRESS, 0, this.a_tab_size);
        System.arraycopy(A.ARCS_SIGN, 0, this.ARCS_SIGN, 0, this.num_trans);
        System.arraycopy(A.ARCS_TARGET, 0, this.ARCS_TARGET, 0, this.num_trans);
        System.arraycopy(A.ARCS_WEIGHT, 0, this.ARCS_WEIGHT, 0, this.num_trans);
        System.arraycopy(A.NUM_ARCS, 0, this.NUM_ARCS, 0, this.a_tab_size);
        System.arraycopy(A.ROWPT, 0, this.ROWPT, 0, this.num_stat);
        System.arraycopy(A.I_ALPHABET, 0, this.I_ALPHABET, 0, this.ia_size);
        System.arraycopy(A.O_ALPHABET, 0, this.O_ALPHABET, 0, this.oa_size);
        System.arraycopy(A.NUM_SYMBOLS, 0, this.NUM_SYMBOLS, 0, this.num_stat);
        System.arraycopy(A.POINTER_SYMBOLS, 0, this.POINTER_SYMBOLS, 0, this.num_stat);
        System.arraycopy(A.SYMBOLS, 0, this.SYMBOLS, 0, this.num_trans);
    }

    public void writeToStream(DataOutputStream s) throws IOException {
        int i;
        s.writeInt(this.num_stat);
        for (i = 0; i < this.num_stat; ++i) {
            s.writeInt(this.ISFINAL[i]);
        }
        for (i = 0; i < this.num_stat; ++i) {
            s.writeInt(this.ROWPT[i]);
        }
        for (i = 0; i < this.num_stat; ++i) {
            s.writeInt(this.NUM_SYMBOLS[i]);
        }
        for (i = 0; i < this.num_stat; ++i) {
            s.writeInt(this.POINTER_SYMBOLS[i]);
        }
        s.writeInt(this.num_final);
        for (i = 0; i < this.num_final; ++i) {
            s.writeFloat(this.F_WEIGHT[i]);
        }
        s.writeInt(this.num_trans);
        for (i = 0; i < this.num_trans; ++i) {
            s.writeFloat(this.ARCS_WEIGHT[i]);
        }
        for (i = 0; i < this.num_trans; ++i) {
            s.writeInt(this.ARCS_SIGN[i]);
        }
        for (i = 0; i < this.num_trans; ++i) {
            s.writeInt(this.ARCS_TARGET[i]);
        }
        for (i = 0; i < this.num_trans; ++i) {
            s.writeInt(this.SYMBOLS[i]);
        }
        s.writeInt(this.a_tab_size);
        for (i = 0; i < this.a_tab_size; ++i) {
            s.writeInt(this.TR_OF[i]);
        }
        for (i = 0; i < this.a_tab_size; ++i) {
            s.writeInt(this.ADRESS[i]);
        }
        for (i = 0; i < this.a_tab_size; ++i) {
            s.writeInt(this.NUM_ARCS[i]);
        }
        s.writeInt(this.ia_size);
        for (i = 0; i < this.ia_size; ++i) {
            s.writeInt(this.I_ALPHABET[i].length());
            s.writeChars(this.I_ALPHABET[i]);
        }
        s.writeInt(this.oa_size);
        for (i = 0; i < this.oa_size; ++i) {
            s.writeInt(this.O_ALPHABET[i].length());
            s.writeChars(this.O_ALPHABET[i]);
        }
        s.writeFloat(this.initialweight);
        s.writeInt(this.initialstate);
    }

    public boolean saveToFile(String filename) {
        byte[] fill;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            this.writeToStream(d);
            d.close();
            byteOS.close();
            fill = byteOS.toByteArray();
        }
        catch (IOException e) {
            return false;
        }
        File FileName = new File(filename);
        try {
            FileOutputStream out = new FileOutputStream(FileName);
            DataOutputStream s = new DataOutputStream(out);
            s.write(fill, 0, fill.length);
            s.flush();
            s.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        fill = null;
        return true;
    }

    public void readFromStream(ByteBuffer b) {
        int j;
        char[] temp2;
        int len;
        int i;
        this.num_stat = b.getInt();
        this.ISFINAL = new int[this.num_stat];
        this.ROWPT = new int[this.num_stat];
        this.NUM_SYMBOLS = new int[this.num_stat];
        this.POINTER_SYMBOLS = new int[this.num_stat];
        for (i = 0; i < this.num_stat; ++i) {
            this.ISFINAL[i] = b.getInt();
        }
        for (i = 0; i < this.num_stat; ++i) {
            this.ROWPT[i] = b.getInt();
        }
        for (i = 0; i < this.num_stat; ++i) {
            this.NUM_SYMBOLS[i] = b.getInt();
        }
        for (i = 0; i < this.num_stat; ++i) {
            this.POINTER_SYMBOLS[i] = b.getInt();
        }
        this.num_final = b.getInt();
        this.F_WEIGHT = new float[this.num_final];
        for (i = 0; i < this.num_final; ++i) {
            this.F_WEIGHT[i] = b.getFloat();
        }
        this.num_trans = b.getInt();
        this.ARCS_SIGN = new int[this.num_trans];
        this.ARCS_TARGET = new int[this.num_trans];
        this.ARCS_WEIGHT = new float[this.num_trans];
        this.SYMBOLS = new int[this.num_trans];
        for (i = 0; i < this.num_trans; ++i) {
            this.ARCS_WEIGHT[i] = b.getFloat();
        }
        for (i = 0; i < this.num_trans; ++i) {
            this.ARCS_SIGN[i] = b.getInt();
        }
        for (i = 0; i < this.num_trans; ++i) {
            this.ARCS_TARGET[i] = b.getInt();
        }
        for (i = 0; i < this.num_trans; ++i) {
            this.SYMBOLS[i] = b.getInt();
        }
        this.a_tab_size = b.getInt();
        this.TR_OF = new int[this.a_tab_size];
        this.ADRESS = new int[this.a_tab_size];
        this.NUM_ARCS = new int[this.a_tab_size];
        for (i = 0; i < this.a_tab_size; ++i) {
            this.TR_OF[i] = b.getInt();
        }
        for (i = 0; i < this.a_tab_size; ++i) {
            this.ADRESS[i] = b.getInt();
        }
        for (i = 0; i < this.a_tab_size; ++i) {
            this.NUM_ARCS[i] = b.getInt();
        }
        this.ia_size = b.getInt();
        this.I_ALPHABET = new String[this.ia_size];
        for (i = 0; i < this.ia_size; ++i) {
            len = b.getInt();
            temp2 = new char[len];
            for (j = 0; j < len; ++j) {
                temp2[j] = b.getChar();
            }
            this.I_ALPHABET[i] = new String(temp2);
        }
        this.oa_size = b.getInt();
        this.O_ALPHABET = new String[this.oa_size];
        for (i = 0; i < this.oa_size; ++i) {
            len = b.getInt();
            temp2 = new char[len];
            for (j = 0; j < len; ++j) {
                temp2[j] = b.getChar();
            }
            this.O_ALPHABET[i] = new String(temp2);
        }
        this.initialweight = b.getFloat();
        this.initialstate = b.getInt();
    }

    public boolean readFromFile(String filename) {
        File FileName = new File(filename);
        int maxLen = (int)FileName.length();
        byte[] randomAccess = new byte[maxLen];
        try {
            FileInputStream out = new FileInputStream(FileName);
            DataInputStream s = new DataInputStream(out);
            s.readFully(randomAccess, 0, maxLen);
            s.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        ByteBuffer b = ByteBuffer.allocate(maxLen);
        b.put(randomAccess);
        b.rewind();
        this.readFromStream(b);
        randomAccess = null;
        return true;
    }

    public FSM(FSM A) {
        this.set(A);
    }

    public FSM() {
    }

    public boolean fsm2text(String filename) {
        try {
            int i;
            BufferedWriter s = new BufferedWriter(new FileWriter(filename));
            s.write(Integer.toString(this.initialstate) + " " + Float.toString(this.initialweight) + "\n");
            for (i = 0; i < this.num_stat; ++i) {
                for (int j = 0; j < this.ia_size; ++j) {
                    int na = this.get_numarcs(i, j);
                    if (na <= 0) continue;
                    for (int k = 0; k < na; ++k) {
                        s.write(Integer.toString(i) + " " + Integer.toString(this.get_nextstate(i, j, k)) + " " + this.getstring_IA(j) + " " + this.getstring_OA(this.get_output(i, j, k)) + " " + Float.toString(this.get_cost(i, j, k)) + "\n");
                    }
                }
            }
            for (i = 0; i < this.num_stat; ++i) {
                if (!this.is_final(i)) continue;
                s.write(Integer.toString(i) + " " + Float.toString(this.final_weight(i)) + "\n");
            }
            s.flush();
            s.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

