/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.arraylist;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class SimpleArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private static final int DEFAULT_MEM_BLOCK_SIZE = 100000;
    private ArrayList<Object[]> memory;
    private int memoryBlockSize;
    private int currentFree;

    public SimpleArrayList(int memoryBlock) {
        if (memoryBlock < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + memoryBlock);
        }
        this.memory = new ArrayList(1);
        this.memoryBlockSize = memoryBlock;
        this.memory.add(new Object[this.memoryBlockSize]);
        this.currentFree = 0;
    }

    public SimpleArrayList() {
        this(100000);
    }

    public SimpleArrayList(Collection<? extends E> c) {
    }

    public void trimToSize() {
    }

    @Override
    public int size() {
        return (this.memory.size() - 1) * this.memoryBlockSize + this.currentFree + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return true;
    }

    @Override
    public int indexOf(Object o) {
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return -1;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public E get(int index) {
        this.RangeCheck(index);
        int whichList = index / this.memoryBlockSize;
        int newIndex = index % this.memoryBlockSize;
        return (E)this.memory.get(whichList)[newIndex];
    }

    @Override
    public E set(int index, E element) {
        return null;
    }

    @Override
    public boolean add(E e) {
        if (this.currentFree >= this.memoryBlockSize) {
            this.memory.add(new Object[this.memoryBlockSize]);
            this.currentFree = 0;
        }
        Object[] targetArray = this.memory.get(this.memory.size() - 1);
        targetArray[this.currentFree++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
    }

    @Override
    public E remove(int index) {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        return true;
    }

    private void fastRemove(int index) {
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return true;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
    }

    private void RangeCheck(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }
}

