/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.sorting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;
import piskorski.util.functions.Files;
import piskorski.util.sorting.StringComparator;

public class ExternSorting {
    private String tapeName;
    private static final String defaultTapeName = "tape";
    protected static Logger logger = Logger.getLogger(ExternSorting.class);
    private int maxSize;
    private static final int maxDeafult = 100;
    private Comparator<String> myComp;
    private char endOfStringMarker;
    private static final char defaultEndOfStringMarker = '$';

    private boolean loggerMessageAndExit(String message) {
        logger.error((Object)message);
        System.exit(0);
        return false;
    }

    public ExternSorting() {
        this.setMaxSize(100);
        this.myComp = new StringComparator();
        this.tapeName = defaultTapeName;
        this.endOfStringMarker = (char)36;
    }

    public ExternSorting(int maxElem) {
        this.setMaxSize(maxElem);
        this.myComp = new StringComparator();
        this.tapeName = defaultTapeName;
        this.endOfStringMarker = (char)36;
    }

    public ExternSorting(int maxElem, Comparator<String> c) {
        this.setMaxSize(maxElem);
        this.myComp = c;
        this.tapeName = defaultTapeName;
        this.endOfStringMarker = (char)36;
    }

    public ExternSorting(int maxElem, Comparator<String> c, String tapeName) {
        this.setMaxSize(maxElem);
        this.myComp = c;
        this.tapeName = tapeName;
        this.endOfStringMarker = (char)36;
    }

    public ExternSorting(int maxElem, Comparator<String> c, String tapeName, char endOfStringMarker) {
        this.setMaxSize(maxElem);
        this.myComp = c;
        this.tapeName = tapeName;
        this.endOfStringMarker = endOfStringMarker;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int aMaxSize) {
        this.maxSize = aMaxSize;
    }

    public int getEndOfStringMarker() {
        return this.endOfStringMarker;
    }

    public void setEndOfStringMarker(char endOfStringMarker) {
        this.endOfStringMarker = endOfStringMarker;
    }

    public void setTapeName(String tapeName) {
        this.tapeName = tapeName;
    }

    public Comparator getComparator() {
        return this.myComp;
    }

    public void setComparator(Comparator<String> c) {
        this.myComp = c;
    }

    private void mergeTapes(BufferedReader inputTape1, BufferedReader inputTape2, BufferedWriter outputTape1, BufferedWriter outputTape2, int blockSize, int mergeSteps) {
        try {
            BufferedWriter currentOutputTape = outputTape1;
            String tape1Val = inputTape1.readLine();
            String tape2Val = inputTape2.readLine();
            for (int i = 0; i < mergeSteps; ++i) {
                int j;
                int tape1Counter = 0;
                int tape2Counter = 0;
                while (tape1Counter < blockSize && tape2Counter < blockSize && tape1Val != null && tape2Val != null) {
                    if (this.myComp.compare(tape1Val, tape2Val) < 0) {
                        currentOutputTape.write(tape1Val);
                        currentOutputTape.newLine();
                        ++tape1Counter;
                        tape1Val = inputTape1.readLine();
                        continue;
                    }
                    currentOutputTape.write(tape2Val);
                    currentOutputTape.newLine();
                    ++tape2Counter;
                    tape2Val = inputTape2.readLine();
                }
                for (j = tape1Counter; j < blockSize && tape1Val != null; ++j) {
                    currentOutputTape.write(tape1Val);
                    currentOutputTape.newLine();
                    tape1Val = inputTape1.readLine();
                }
                for (j = tape2Counter; j < blockSize && tape2Val != null; ++j) {
                    currentOutputTape.write(tape2Val);
                    currentOutputTape.newLine();
                    tape2Val = inputTape2.readLine();
                }
                currentOutputTape = currentOutputTape == outputTape1 ? outputTape2 : outputTape1;
            }
        }
        catch (IOException e) {
            this.loggerMessageAndExit("IO Exception while merging tapes");
        }
    }

    private void mergeTapesSpecial(BufferedReader inputTape1, BufferedReader inputTape2, BufferedWriter outputTape1, BufferedWriter outputTape2, int blockSize, int mergeSteps) {
        StringBuffer tape1ValB = new StringBuffer();
        StringBuffer tape2ValB = new StringBuffer();
        try {
            BufferedWriter currentOutputTape = outputTape1;
            Files.readStringFromBuffer(inputTape1, tape1ValB, this.endOfStringMarker);
            Files.readStringFromBuffer(inputTape2, tape2ValB, this.endOfStringMarker);
            String tape1Val = tape1ValB.length() > 0 ? tape1ValB.toString() : null;
            String tape2Val = tape2ValB.length() > 0 ? tape2ValB.toString() : null;
            for (int i = 0; i < mergeSteps; ++i) {
                int j;
                int tape1Counter = 0;
                int tape2Counter = 0;
                while (tape1Counter < blockSize && tape2Counter < blockSize && tape1Val != null && tape2Val != null) {
                    if (this.myComp.compare(tape1Val, tape2Val) < 0) {
                        currentOutputTape.write(tape1Val);
                        ++tape1Counter;
                        tape1ValB.setLength(0);
                        Files.readStringFromBuffer(inputTape1, tape1ValB, this.endOfStringMarker);
                        tape1Val = tape1ValB.length() > 0 ? tape1ValB.toString() : null;
                        continue;
                    }
                    currentOutputTape.write(tape2Val);
                    ++tape2Counter;
                    tape2ValB.setLength(0);
                    Files.readStringFromBuffer(inputTape2, tape2ValB, this.endOfStringMarker);
                    tape2Val = tape2ValB.length() > 0 ? tape2ValB.toString() : null;
                }
                for (j = tape1Counter; j < blockSize && tape1Val != null; ++j) {
                    currentOutputTape.write(tape1Val);
                    tape1ValB.setLength(0);
                    Files.readStringFromBuffer(inputTape1, tape1ValB, this.endOfStringMarker);
                    tape1Val = tape1ValB.length() > 0 ? tape1ValB.toString() : null;
                }
                for (j = tape2Counter; j < blockSize && tape2Val != null; ++j) {
                    currentOutputTape.write(tape2Val);
                    tape2ValB.setLength(0);
                    Files.readStringFromBuffer(inputTape2, tape2ValB, this.endOfStringMarker);
                    tape2Val = tape2ValB.length() > 0 ? tape2ValB.toString() : null;
                }
                currentOutputTape = currentOutputTape == outputTape1 ? outputTape2 : outputTape1;
            }
        }
        catch (IOException e) {
            this.loggerMessageAndExit("IO Exception while merging tapes");
        }
    }

    private int createInputTapes(String inputFileName, String charEncoding, String tape1FileName, String tape2FileName) {
        int stringsCount = 0;
        try {
            int i;
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFileName), charEncoding), this.maxSize);
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            BufferedWriter tape1 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tape1FileName), charEncoding), this.maxSize);
            BufferedWriter tape2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tape2FileName), charEncoding), this.maxSize);
            BufferedWriter currentTape = tape1;
            ArrayList<String> stringBlock = new ArrayList<String>(this.getMaxSize());
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() > 0) {
                    stringBlock.add(line);
                    ++stringsCount;
                }
                if (this.getMaxSize() != stringBlock.size()) continue;
                Collections.sort(stringBlock, this.myComp);
                for (i = 0; i < this.maxSize; ++i) {
                    currentTape.write((String)stringBlock.get(i));
                    currentTape.newLine();
                }
                stringBlock.clear();
                if (currentTape == tape1) {
                    currentTape = tape2;
                    continue;
                }
                currentTape = tape1;
            }
            Collections.sort(stringBlock, this.myComp);
            for (i = 0; i < stringBlock.size(); ++i) {
                currentTape.write((String)stringBlock.get(i));
                currentTape.newLine();
            }
            tape1.close();
            tape2.close();
            in.close();
        }
        catch (IOException e) {
            this.loggerMessageAndExit("IO Exception while processing input file: " + inputFileName);
        }
        return stringsCount;
    }

    private int createInputTapesSpecial(String inputFileName, String charEncoding, String tape1FileName, String tape2FileName) {
        int stringsCount = 0;
        StringBuffer currentLine = new StringBuffer();
        try {
            int i;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFileName), charEncoding), this.maxSize);
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            BufferedWriter tape1 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tape1FileName), charEncoding), this.maxSize);
            BufferedWriter tape2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tape2FileName), charEncoding), this.maxSize);
            BufferedWriter currentTape = tape1;
            ArrayList<String> stringBlock = new ArrayList<String>(this.getMaxSize());
            while (true) {
                String line;
                currentLine.setLength(0);
                Files.readStringFromBuffer(in, currentLine, this.endOfStringMarker);
                String string = line = currentLine.length() > 0 ? currentLine.toString() : null;
                if (line == null) break;
                stringBlock.add(line);
                ++stringsCount;
                if (this.getMaxSize() != stringBlock.size()) continue;
                Collections.sort(stringBlock, this.myComp);
                for (i = 0; i < this.maxSize; ++i) {
                    currentTape.write((String)stringBlock.get(i));
                }
                stringBlock.clear();
                if (currentTape == tape1) {
                    currentTape = tape2;
                    continue;
                }
                currentTape = tape1;
            }
            Collections.sort(stringBlock, this.myComp);
            for (i = 0; i < stringBlock.size(); ++i) {
                currentTape.write((String)stringBlock.get(i));
            }
            tape1.close();
            tape2.close();
            in.close();
        }
        catch (IOException e) {
            this.loggerMessageAndExit("IO Exception while processing input file: " + inputFileName);
        }
        return stringsCount;
    }

    public void sort(String inputFileName, String outputFileName, String charEncoding, boolean useEndOfStringMarker) {
        logger.info((Object)"Extern Sorting Settings:");
        logger.info((Object)("Input File: " + inputFileName));
        logger.info((Object)("Output File: " + outputFileName));
        logger.info((Object)("Char Encoding: " + charEncoding));
        logger.info((Object)("MultiLines On: " + useEndOfStringMarker));
        logger.info((Object)("End-Of-String Marker: " + this.endOfStringMarker));
        logger.info((Object)("Initial Sorted Block Size: " + this.maxSize));
        logger.info((Object)("Temporary file name to be used: " + this.tapeName));
        logger.info((Object)"Extern sorting starts");
        if (this.tapeName == null) {
            this.loggerMessageAndExit("Tape name is set to null. Can not proceed.");
        }
        String tape1FileName = this.tapeName + "1";
        String tape2FileName = this.tapeName + "2";
        String tape3FileName = this.tapeName + "3";
        String tape4FileName = this.tapeName + "4";
        logger.info((Object)"Extern sorting: Delete tapes if they exist.");
        if (!Files.deleteFile(tape1FileName)) {
            this.loggerMessageAndExit("Problems while deleting temporary file: " + tape1FileName);
        }
        if (!Files.deleteFile(tape2FileName)) {
            this.loggerMessageAndExit("Problems while deleting temporary file: " + tape2FileName);
        }
        if (!Files.deleteFile(tape3FileName)) {
            this.loggerMessageAndExit("Problems while deleting temporary file: " + tape3FileName);
        }
        if (!Files.deleteFile(tape4FileName)) {
            this.loggerMessageAndExit("Problems while deleting temporary file: " + tape4FileName);
        }
        logger.info((Object)"Extern sorting: Create initial tapes with sorted blocks.");
        int stringsCount = useEndOfStringMarker ? this.createInputTapesSpecial(inputFileName, charEncoding, tape1FileName, tape2FileName) : this.createInputTapes(inputFileName, charEncoding, tape1FileName, tape2FileName);
        logger.info((Object)"Extern sorting: Merging sorted blocks starts.");
        int currentBlockSize = this.getMaxSize();
        int count = 0;
        try {
            count = 1;
            while (currentBlockSize < stringsCount) {
                logger.info((Object)("Extern sorting - Merging phase: " + count));
                if (currentBlockSize >= stringsCount / 2) {
                    tape3FileName = outputFileName;
                }
                BufferedReader inputTape1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tape1FileName), charEncoding), this.maxSize);
                BufferedReader inputTape2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tape2FileName), charEncoding), this.maxSize);
                inputTape1.mark(1);
                int FirstSymbol = inputTape1.read();
                if (FirstSymbol != 65279) {
                    inputTape1.reset();
                }
                inputTape2.mark(1);
                FirstSymbol = inputTape2.read();
                if (FirstSymbol != 65279) {
                    inputTape2.reset();
                }
                BufferedWriter outputTape1 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tape3FileName), charEncoding), this.maxSize);
                BufferedWriter outputTape2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tape4FileName), charEncoding), this.maxSize);
                int mergeSteps = stringsCount / (2 * currentBlockSize);
                if (stringsCount % (2 * currentBlockSize) > 0) {
                    ++mergeSteps;
                }
                if (useEndOfStringMarker) {
                    this.mergeTapesSpecial(inputTape1, inputTape2, outputTape1, outputTape2, currentBlockSize, mergeSteps);
                } else {
                    this.mergeTapes(inputTape1, inputTape2, outputTape1, outputTape2, currentBlockSize, mergeSteps);
                }
                inputTape1.close();
                inputTape2.close();
                outputTape1.close();
                outputTape2.close();
                currentBlockSize *= 2;
                String tempFileName = tape1FileName;
                tape1FileName = tape3FileName;
                tape3FileName = tempFileName;
                tempFileName = tape2FileName;
                tape2FileName = tape4FileName;
                tape4FileName = tempFileName;
                ++count;
            }
        }
        catch (IOException e) {
            this.loggerMessageAndExit("IO Exception in merging phase: " + count);
        }
        logger.info((Object)"Extern sorting: Delete temporary files.");
        for (int i = 1; i < 5; ++i) {
            StringBuffer name = new StringBuffer();
            name.append(this.tapeName);
            name.append(i);
            String fileName = name.toString();
            if (Files.deleteFile(fileName)) continue;
            this.loggerMessageAndExit("Problems while deleting temporary file (tape): " + fileName);
        }
        logger.info((Object)"Extern sorting ends succesfuly.");
    }
}

