/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class StringFunctions {
    public static String LongestCommonSubstring(String s1, String s2) {
        int lenS1 = s1.length() + 1;
        int lenS2 = s2.length() + 1;
        short[][] L = new short[lenS1][];
        for (int i = 0; i < lenS1; ++i) {
            L[i] = new short[lenS2];
        }
        Arrays.fill(L[0], (short)0);
        for (int j = 0; j < lenS1; ++j) {
            L[j][0] = 0;
        }
        short currentMaxLen = 0;
        int currentI = 0;
        for (int i = 1; i < lenS1; ++i) {
            for (int j = 1; j < lenS2; ++j) {
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    L[i][j] = 0;
                    continue;
                }
                L[i][j] = (short)(L[i - 1][j - 1] + 1);
                if (L[i][j] <= currentMaxLen) continue;
                currentMaxLen = L[i][j];
                currentI = (short)i;
            }
        }
        return currentMaxLen > 0 ? s1.substring(currentI - currentMaxLen, currentI) : "";
    }

    public static int getLengthOfTheCommonPrefix(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        for (int i = 0; i < minLen; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return minLen;
    }

    public static String removeWhitespaces(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        for (int j = 0; j < len; ++j) {
            char c = s.charAt(j);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeChars(String s, String charsToRemove) {
        StringBuffer sb = new StringBuffer();
        if (charsToRemove == null) {
            return s;
        }
        char[] chars = charsToRemove.toCharArray();
        int numChars = chars.length;
        int len = s.length();
        for (int j = 0; j < len; ++j) {
            char c = s.charAt(j);
            for (int k = 0; k < numChars; ++k) {
                if (c != chars[k]) continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeChar(String s, char x) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        for (int j = 0; j < len; ++j) {
            char c = s.charAt(j);
            if (c == x) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean onlyLatinDigits(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterFollowedByDot(String s) {
        int len = s.length();
        if (len != 2) {
            return false;
        }
        return Character.isUpperCase(s.charAt(0)) && s.charAt(1) == '.';
    }

    public static boolean isNumberRange(String s) {
        char c;
        int i;
        int len = s.length();
        for (i = 0; i < len && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
        }
        if (i < len && i > 0) {
            if (s.charAt(i) != '-' && s.charAt(i) != '\u2013') {
                return false;
            }
        } else {
            return false;
        }
        if (++i < len) {
            while (i < len) {
                c = s.charAt(i);
                if (c < '0' || c > '9') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean lettersFollowedByDigits(String s) {
        int i;
        int len = s.length();
        for (i = 0; i < len && Character.isLetter(s.charAt(i)); ++i) {
        }
        if (i < len && i > 0) {
            if (s.charAt(i) == '-' || s.charAt(i) == '\u2013') {
                ++i;
            }
        } else {
            return false;
        }
        if (i < len) {
            while (i < len) {
                if (!StringFunctions.isLatinDigit(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean digitsFollowedByLetters(String s) {
        char c;
        int i;
        int len = s.length();
        for (i = 0; i < len && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
        }
        if (i < len && i > 0) {
            if (s.charAt(i) == '-' || s.charAt(i) == '\u2013') {
                ++i;
            }
        } else {
            return false;
        }
        if (i < len) {
            while (i < len) {
                if (!Character.isLetter(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean onlyUppercaseLetters(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean onlyLatinUppercaseLetters(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean onlyLatinLettersOrDigits(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCaseLatin(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLatinLettersOrDigits(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c >= 'a' && c <= 'z';
    }

    public static int findIndexOf(String s, char[] symbols) {
        int len = s.length();
        int numSymbols = symbols.length;
        for (int i = 0; i < len; ++i) {
            char next = s.charAt(i);
            for (int j = 0; j < numSymbols; ++j) {
                if (next != symbols[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static char[] getCharArray(int start, int end, char[] text) {
        int len = end - start + 1;
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            result[i] = text[i + start];
        }
        return result;
    }

    public static String convertUnicodeSequenceToString(String unicodeSequence) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(unicodeSequence, ",");
        try {
            while (tokenizer.hasMoreTokens()) {
                String nextEntry = tokenizer.nextToken().trim();
                nextEntry = nextEntry.substring(2, nextEntry.length());
                result.append((char)Long.valueOf(nextEntry, 16).longValue());
            }
        }
        catch (Exception e) {
            return "";
        }
        return result.toString();
    }

    public static boolean containsIntegers(String word) {
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            switch (word.charAt(i)) {
                case '0': {
                    return false;
                }
                case '1': {
                    return false;
                }
                case '2': {
                    return false;
                }
                case '3': {
                    return false;
                }
                case '4': {
                    return false;
                }
                case '5': {
                    return false;
                }
                case '6': {
                    return false;
                }
                case '7': {
                    return false;
                }
                case '8': {
                    return false;
                }
                case '9': {
                    return false;
                }
            }
        }
        return true;
    }

    public static String reverse(String word) {
        int len = word.length();
        char[] Result = new char[len];
        for (int i = 0; i < len; ++i) {
            Result[i] = word.charAt(len - i - 1);
        }
        return new String(Result);
    }

    public static int lengthOfCommonPrefix(String word1, String word2) {
        int i;
        int len = word1.length();
        if (word2.length() < len) {
            len = word2.length();
        }
        for (i = 0; i < len && word1.charAt(i) == word2.charAt(i); ++i) {
        }
        return i;
    }

    public static int lengthOfCommonSufix(String word1, String word2) {
        int len = word1.length();
        int len2 = word2.length();
        int i = 0;
        while (len > 0 && len2 > 0 && word1.charAt(--len) == word2.charAt(--len2)) {
            ++i;
        }
        return i;
    }

    public static String normalizeDiacritics(String word, boolean trimming) {
        StringBuffer result = new StringBuffer();
        int len = word.length();
        block179: for (int i = 0; i < len; ++i) {
            char next = word.charAt(i);
            switch (next) {
                case '\u00c0': {
                    result.append('A');
                    continue block179;
                }
                case '\u00c1': {
                    result.append('A');
                    continue block179;
                }
                case '\u00c2': {
                    result.append('A');
                    continue block179;
                }
                case '\u00c3': {
                    result.append('A');
                    continue block179;
                }
                case '\u00c4': {
                    result.append('A');
                    continue block179;
                }
                case '\u00c5': {
                    result.append('A');
                    continue block179;
                }
                case '\u00c7': {
                    result.append('C');
                    continue block179;
                }
                case '\u00c8': {
                    result.append('E');
                    continue block179;
                }
                case '\u00c9': {
                    result.append('E');
                    continue block179;
                }
                case '\u00ca': {
                    result.append('E');
                    continue block179;
                }
                case '\u00cb': {
                    result.append('E');
                    continue block179;
                }
                case '\u00cc': {
                    result.append('I');
                    continue block179;
                }
                case '\u00cd': {
                    result.append('I');
                    continue block179;
                }
                case '\u00ce': {
                    result.append('I');
                    continue block179;
                }
                case '\u00cf': {
                    result.append('I');
                    continue block179;
                }
                case '\u00d1': {
                    result.append('N');
                    continue block179;
                }
                case '\u00d2': {
                    result.append('O');
                    continue block179;
                }
                case '\u00d3': {
                    result.append('O');
                    continue block179;
                }
                case '\u00d4': {
                    result.append('O');
                    continue block179;
                }
                case '\u00d5': {
                    result.append('O');
                    continue block179;
                }
                case '\u00d6': {
                    result.append('O');
                    continue block179;
                }
                case '\u00d8': {
                    result.append('O');
                    continue block179;
                }
                case '\u00d9': {
                    result.append('U');
                    continue block179;
                }
                case '\u00da': {
                    result.append('U');
                    continue block179;
                }
                case '\u00db': {
                    result.append('U');
                    continue block179;
                }
                case '\u00dc': {
                    result.append('U');
                    continue block179;
                }
                case '\u00dd': {
                    result.append('Y');
                    continue block179;
                }
                case '\u00df': {
                    result.append('s');
                    continue block179;
                }
                case '\u00e0': {
                    result.append('a');
                    continue block179;
                }
                case '\u00e1': {
                    result.append('a');
                    continue block179;
                }
                case '\u00e2': {
                    result.append('a');
                    continue block179;
                }
                case '\u00e3': {
                    result.append('a');
                    continue block179;
                }
                case '\u00e4': {
                    result.append('a');
                    continue block179;
                }
                case '\u00e5': {
                    result.append('a');
                    continue block179;
                }
                case '\u00e7': {
                    result.append('c');
                    continue block179;
                }
                case '\u00e8': {
                    result.append('e');
                    continue block179;
                }
                case '\u00e9': {
                    result.append('e');
                    continue block179;
                }
                case '\u00ea': {
                    result.append('e');
                    continue block179;
                }
                case '\u00eb': {
                    result.append('e');
                    continue block179;
                }
                case '\u00ec': {
                    result.append('i');
                    continue block179;
                }
                case '\u00ed': {
                    result.append('i');
                    continue block179;
                }
                case '\u00ee': {
                    result.append('i');
                    continue block179;
                }
                case '\u00ef': {
                    result.append('i');
                    continue block179;
                }
                case '\u00f1': {
                    result.append('n');
                    continue block179;
                }
                case '\u00f2': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f3': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f4': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f5': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f6': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f7': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f8': {
                    result.append('o');
                    continue block179;
                }
                case '\u00f9': {
                    result.append('u');
                    continue block179;
                }
                case '\u00fa': {
                    result.append('u');
                    continue block179;
                }
                case '\u00fb': {
                    result.append('u');
                    continue block179;
                }
                case '\u00fc': {
                    result.append('u');
                    continue block179;
                }
                case '\u00fd': {
                    result.append('y');
                    continue block179;
                }
                case '\u00ff': {
                    result.append('y');
                    continue block179;
                }
                case '\u0100': {
                    result.append('A');
                    continue block179;
                }
                case '\u0101': {
                    result.append('a');
                    continue block179;
                }
                case '\u0102': {
                    result.append('A');
                    continue block179;
                }
                case '\u0103': {
                    result.append('a');
                    continue block179;
                }
                case '\u0104': {
                    result.append('A');
                    continue block179;
                }
                case '\u0105': {
                    result.append('a');
                    continue block179;
                }
                case '\u0106': {
                    result.append('C');
                    continue block179;
                }
                case '\u0107': {
                    result.append('c');
                    continue block179;
                }
                case '\u0108': {
                    result.append('C');
                    continue block179;
                }
                case '\u0109': {
                    result.append('c');
                    continue block179;
                }
                case '\u010a': {
                    result.append('C');
                    continue block179;
                }
                case '\u010b': {
                    result.append('c');
                    continue block179;
                }
                case '\u010c': {
                    result.append('C');
                    continue block179;
                }
                case '\u010d': {
                    result.append('c');
                    continue block179;
                }
                case '\u010e': {
                    result.append('D');
                    continue block179;
                }
                case '\u010f': {
                    result.append('d');
                    continue block179;
                }
                case '\u0110': {
                    result.append('D');
                    continue block179;
                }
                case '\u0111': {
                    result.append('d');
                    continue block179;
                }
                case '\u0112': {
                    result.append('E');
                    continue block179;
                }
                case '\u0113': {
                    result.append('e');
                    continue block179;
                }
                case '\u0116': {
                    result.append('E');
                    continue block179;
                }
                case '\u0117': {
                    result.append('e');
                    continue block179;
                }
                case '\u0118': {
                    result.append('E');
                    continue block179;
                }
                case '\u0119': {
                    result.append('e');
                    continue block179;
                }
                case '\u011a': {
                    result.append('E');
                    continue block179;
                }
                case '\u011b': {
                    result.append('e');
                    continue block179;
                }
                case '\u011c': {
                    result.append('G');
                    continue block179;
                }
                case '\u011d': {
                    result.append('g');
                    continue block179;
                }
                case '\u011e': {
                    result.append('G');
                    continue block179;
                }
                case '\u011f': {
                    result.append('g');
                    continue block179;
                }
                case '\u0120': {
                    result.append('G');
                    continue block179;
                }
                case '\u0121': {
                    result.append('g');
                    continue block179;
                }
                case '\u0122': {
                    result.append('G');
                    continue block179;
                }
                case '\u0123': {
                    result.append('g');
                    continue block179;
                }
                case '\u0124': {
                    result.append('H');
                    continue block179;
                }
                case '\u0125': {
                    result.append('h');
                    continue block179;
                }
                case '\u0126': {
                    result.append('H');
                    continue block179;
                }
                case '\u0127': {
                    result.append('h');
                    continue block179;
                }
                case '\u0128': {
                    result.append('I');
                    continue block179;
                }
                case '\u0129': {
                    result.append('i');
                    continue block179;
                }
                case '\u012a': {
                    result.append('I');
                    continue block179;
                }
                case '\u012b': {
                    result.append('i');
                    continue block179;
                }
                case '\u012e': {
                    result.append('I');
                    continue block179;
                }
                case '\u012f': {
                    result.append('i');
                    continue block179;
                }
                case '\u0130': {
                    result.append('I');
                    continue block179;
                }
                case '\u0131': {
                    result.append('i');
                    continue block179;
                }
                case '\u0134': {
                    result.append('J');
                    continue block179;
                }
                case '\u0135': {
                    result.append('j');
                    continue block179;
                }
                case '\u0136': {
                    result.append('K');
                    continue block179;
                }
                case '\u0137': {
                    result.append('k');
                    continue block179;
                }
                case '\u0139': {
                    result.append('L');
                    continue block179;
                }
                case '\u013a': {
                    result.append('l');
                    continue block179;
                }
                case '\u013b': {
                    result.append('L');
                    continue block179;
                }
                case '\u013c': {
                    result.append('l');
                    continue block179;
                }
                case '\u013d': {
                    result.append('L');
                    continue block179;
                }
                case '\u013e': {
                    result.append('l');
                    continue block179;
                }
                case '\u013f': {
                    result.append('L');
                    continue block179;
                }
                case '\u0140': {
                    result.append('l');
                    continue block179;
                }
                case '\u0141': {
                    result.append('L');
                    continue block179;
                }
                case '\u0142': {
                    result.append('l');
                    continue block179;
                }
                case '\u0143': {
                    result.append('N');
                    continue block179;
                }
                case '\u0144': {
                    result.append('n');
                    continue block179;
                }
                case '\u0145': {
                    result.append('N');
                    continue block179;
                }
                case '\u0146': {
                    result.append('n');
                    continue block179;
                }
                case '\u0147': {
                    result.append('N');
                    continue block179;
                }
                case '\u0148': {
                    result.append('n');
                    continue block179;
                }
                case '\u0149': {
                    result.append('n');
                    continue block179;
                }
                case '\u014c': {
                    result.append('O');
                    continue block179;
                }
                case '\u014d': {
                    result.append('o');
                    continue block179;
                }
                case '\u0150': {
                    result.append('O');
                    continue block179;
                }
                case '\u0151': {
                    result.append('o');
                    continue block179;
                }
                case '\u0154': {
                    result.append('R');
                    continue block179;
                }
                case '\u0155': {
                    result.append('r');
                    continue block179;
                }
                case '\u0156': {
                    result.append('R');
                    continue block179;
                }
                case '\u0157': {
                    result.append('r');
                    continue block179;
                }
                case '\u0158': {
                    result.append('R');
                    continue block179;
                }
                case '\u0159': {
                    result.append('r');
                    continue block179;
                }
                case '\u015a': {
                    result.append('S');
                    continue block179;
                }
                case '\u015b': {
                    result.append('s');
                    continue block179;
                }
                case '\u015c': {
                    result.append('S');
                    continue block179;
                }
                case '\u015d': {
                    result.append('s');
                    continue block179;
                }
                case '\u015e': {
                    result.append('S');
                    continue block179;
                }
                case '\u015f': {
                    result.append('s');
                    continue block179;
                }
                case '\u0160': {
                    result.append('S');
                    continue block179;
                }
                case '\u0161': {
                    result.append('s');
                    continue block179;
                }
                case '\u0162': {
                    result.append('T');
                    continue block179;
                }
                case '\u0163': {
                    result.append('t');
                    continue block179;
                }
                case '\u0164': {
                    result.append('T');
                    continue block179;
                }
                case '\u0165': {
                    result.append('t');
                    continue block179;
                }
                case '\u0166': {
                    result.append('T');
                    continue block179;
                }
                case '\u0167': {
                    result.append('t');
                    continue block179;
                }
                case '\u0168': {
                    result.append('U');
                    continue block179;
                }
                case '\u0169': {
                    result.append('u');
                    continue block179;
                }
                case '\u016a': {
                    result.append('U');
                    continue block179;
                }
                case '\u016b': {
                    result.append('u');
                    continue block179;
                }
                case '\u016c': {
                    result.append('U');
                    continue block179;
                }
                case '\u016d': {
                    result.append('u');
                    continue block179;
                }
                case '\u016e': {
                    result.append('U');
                    continue block179;
                }
                case '\u016f': {
                    result.append('u');
                    continue block179;
                }
                case '\u0170': {
                    result.append('U');
                    continue block179;
                }
                case '\u0171': {
                    result.append('u');
                    continue block179;
                }
                case '\u0172': {
                    result.append('U');
                    continue block179;
                }
                case '\u0173': {
                    result.append('u');
                    continue block179;
                }
                case '\u0174': {
                    result.append('W');
                    continue block179;
                }
                case '\u0175': {
                    result.append('w');
                    continue block179;
                }
                case '\u0176': {
                    result.append('Y');
                    continue block179;
                }
                case '\u0177': {
                    result.append('y');
                    continue block179;
                }
                case '\u0178': {
                    result.append('Y');
                    continue block179;
                }
                case '\u0179': {
                    result.append('Z');
                    continue block179;
                }
                case '\u017a': {
                    result.append('z');
                    continue block179;
                }
                case '\u017b': {
                    result.append('Z');
                    continue block179;
                }
                case '\u017c': {
                    result.append('z');
                    continue block179;
                }
                case '\u017d': {
                    result.append('Z');
                    continue block179;
                }
                case '\u017e': {
                    result.append('z');
                    continue block179;
                }
                case '\u0192': {
                    result.append('f');
                    continue block179;
                }
                case '\u01f5': {
                    result.append('g');
                    continue block179;
                }
                case ' ': {
                    if (trimming) continue block179;
                    result.append(next);
                    continue block179;
                }
                case '-': {
                    if (trimming) continue block179;
                    result.append(next);
                    continue block179;
                }
                case '\'': {
                    if (trimming) continue block179;
                    result.append(next);
                    continue block179;
                }
                case '`': {
                    if (trimming) continue block179;
                    result.append(next);
                    continue block179;
                }
                default: {
                    result.append(next);
                }
            }
        }
        return result.toString();
    }

    public static String trimmAndUpperCase(String word, String trimSymbols) {
        StringBuffer Extra = new StringBuffer();
        for (int i = 0; i < word.length(); ++i) {
            char currentChar = word.charAt(i);
            boolean valid = true;
            for (int j = 0; j < trimSymbols.length(); ++j) {
                if (trimSymbols.charAt(j) != currentChar) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            Extra.append(Character.toUpperCase(currentChar));
        }
        return Extra.toString();
    }

    private static String WhitespacesToUnderscores(String s) {
        StringBuffer Extra = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == ' ') {
                Extra.append('_');
                continue;
            }
            Extra.append(currentChar);
        }
        return Extra.toString();
    }

    private static String downcasAndWhitespacesToUnderscores(String s) {
        StringBuffer Extra = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == ' ') {
                Extra.append('_');
                continue;
            }
            Extra.append(Character.toLowerCase(currentChar));
        }
        return Extra.toString();
    }

    private static String uppercaseTokenInitialSymbols(String s) {
        StringBuffer result = new StringBuffer();
        int len = s.length();
        boolean lastIsWhitespace = true;
        for (int i = 0; i < len; ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == ' ') {
                lastIsWhitespace = true;
                result.append(currentChar);
                continue;
            }
            if (lastIsWhitespace) {
                result.append(Character.toUpperCase(currentChar));
            } else {
                result.append(currentChar);
            }
            lastIsWhitespace = false;
        }
        return result.toString();
    }

    private static String FormingPatternCore(String firstWord, String secondWord) {
        String Pattern2 = null;
        if (firstWord.compareTo(secondWord) == 0) {
            return "+0";
        }
        String downCasedFirstWord = firstWord.toLowerCase();
        if (secondWord.compareTo(downCasedFirstWord) == 0) {
            return "+1";
        }
        String downCasedFirstWordWithUndescores = StringFunctions.WhitespacesToUnderscores(downCasedFirstWord);
        if (secondWord.compareTo(downCasedFirstWordWithUndescores) == 0) {
            return "+11";
        }
        String upercaseTokenInitialSym = StringFunctions.uppercaseTokenInitialSymbols(firstWord);
        if (secondWord.compareTo(upercaseTokenInitialSym) == 0) {
            return "+12";
        }
        String uppercasedFirstWord = firstWord.toUpperCase();
        if (secondWord.compareTo(uppercasedFirstWord) == 0) {
            return "+2";
        }
        String trimmedUpercased = StringFunctions.trimmAndUpperCase(firstWord, " -'");
        if (trimmedUpercased.compareTo(secondWord) == 0) {
            return "+3";
        }
        int where = firstWord.indexOf(secondWord);
        if (where != -1) {
            StringBuffer Result = new StringBuffer();
            Result.append("+4");
            Result.append((char)where);
            Result.append((char)secondWord.length());
            Pattern2 = Result.toString();
            return Pattern2;
        }
        String normalizedFirstWord = StringFunctions.normalizeDiacritics(firstWord, false);
        if (secondWord.compareTo(normalizedFirstWord) == 0) {
            return "+5";
        }
        String normalizedFirstWordAndTrimmed = StringFunctions.normalizeDiacritics(firstWord, true);
        if (secondWord.compareTo(normalizedFirstWordAndTrimmed) == 0) {
            return "+51";
        }
        if (secondWord.compareTo(normalizedFirstWord.toUpperCase()) == 0) {
            return "+6";
        }
        if (secondWord.compareTo(normalizedFirstWordAndTrimmed.toUpperCase()) == 0) {
            return "+7";
        }
        if (secondWord.compareTo(StringFunctions.reverseMultiWord(normalizedFirstWord, " -").toUpperCase()) == 0) {
            return "+8";
        }
        if (secondWord.compareTo(StringFunctions.permuteMultiWordAndTrim(normalizedFirstWord, " -").toUpperCase()) == 0) {
            return "+9";
        }
        return Pattern2;
    }

    private static String FormingPatternNotExtandable(String firstWord, String secondWord) {
        String Pattern2 = null;
        int where = StringFunctions.lengthOfCommonPrefix(firstWord, secondWord);
        int len = secondWord.length();
        if (where > 0) {
            StringBuffer Result = new StringBuffer();
            Result.append("+P");
            Result.append((char)where);
            Result.append(secondWord.substring(where, len));
            Pattern2 = Result.toString();
            return Pattern2;
        }
        return Pattern2;
    }

    public static String FormingPattern(String firstWord, String secondWord) {
        String Pattern2 = StringFunctions.FormingPatternCore(firstWord, secondWord);
        if (Pattern2 == null) {
            Pattern2 = StringFunctions.FormingPatternNotExtandable(firstWord, secondWord);
        }
        if (Pattern2 == null && secondWord.length() > 2) {
            String newSecondWord;
            char fir = secondWord.charAt(0);
            char las = secondWord.charAt(secondWord.length() - 1);
            if (!(fir != '\'' && fir != '\"' || las != '\'' && las != '\"' || (Pattern2 = StringFunctions.FormingPatternCore(firstWord, newSecondWord = secondWord.substring(1, secondWord.length() - 1))) == null)) {
                StringBuffer Result = new StringBuffer();
                Result.append(Pattern2);
                Result.append("+");
                Result.append(secondWord.charAt(0));
                Result.append(secondWord.charAt(secondWord.length() - 1));
                Pattern2 = Result.toString();
            }
        }
        return Pattern2;
    }

    public static String reconstructWord(String pattern, String word) {
        if (pattern == null) {
            return null;
        }
        int lenPattern = pattern.length();
        char patternType = pattern.charAt(1);
        switch (patternType) {
            case '0': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(word);
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return word;
            }
            case '1': {
                if (lenPattern > 2) {
                    if (pattern.charAt(2) == '1') {
                        if (lenPattern > 3) {
                            StringBuffer result = new StringBuffer();
                            result.append(pattern.charAt(4));
                            result.append(StringFunctions.downcasAndWhitespacesToUnderscores(word));
                            result.append(pattern.charAt(5));
                            return result.toString();
                        }
                        return StringFunctions.downcasAndWhitespacesToUnderscores(word);
                    }
                    if (pattern.charAt(2) == '2') {
                        if (lenPattern > 3) {
                            StringBuffer result = new StringBuffer();
                            result.append(pattern.charAt(4));
                            result.append(StringFunctions.uppercaseTokenInitialSymbols(word));
                            result.append(pattern.charAt(5));
                            return result.toString();
                        }
                        return StringFunctions.uppercaseTokenInitialSymbols(word);
                    }
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(word.toLowerCase());
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return word.toLowerCase();
            }
            case '2': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(word.toUpperCase());
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return word.toUpperCase();
            }
            case '3': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(StringFunctions.trimmAndUpperCase(word, " -'"));
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return StringFunctions.trimmAndUpperCase(word, " -'");
            }
            case 'P': {
                return word.substring(0, pattern.charAt(2)) + pattern.substring(3, pattern.length());
            }
            case '4': {
                if (lenPattern > 4) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(5));
                    result.append(word.substring(pattern.charAt(2), pattern.charAt(2) + pattern.charAt(3)));
                    result.append(pattern.charAt(6));
                    return result.toString();
                }
                return word.substring(pattern.charAt(2), pattern.charAt(2) + pattern.charAt(3));
            }
            case '5': {
                boolean trimming = false;
                int extraSymbol = -1;
                if (lenPattern > 2) {
                    if (pattern.charAt(2) == '1') {
                        trimming = true;
                        if (lenPattern > 3) {
                            extraSymbol = 4;
                        }
                    } else {
                        extraSymbol = 3;
                    }
                }
                if (extraSymbol > 0) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(extraSymbol));
                    result.append(StringFunctions.normalizeDiacritics(word, trimming));
                    result.append(pattern.charAt(extraSymbol + 1));
                    return result.toString();
                }
                return StringFunctions.normalizeDiacritics(word, trimming);
            }
            case '6': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(StringFunctions.normalizeDiacritics(word, false).toUpperCase());
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return StringFunctions.normalizeDiacritics(word, false).toUpperCase();
            }
            case '7': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(StringFunctions.normalizeDiacritics(word, true).toUpperCase());
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return StringFunctions.normalizeDiacritics(word, true).toUpperCase();
            }
            case '8': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(StringFunctions.reverseMultiWord(StringFunctions.normalizeDiacritics(word, false), " -").toUpperCase());
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return StringFunctions.reverseMultiWord(StringFunctions.normalizeDiacritics(word, false), " -").toUpperCase();
            }
            case '9': {
                if (lenPattern > 2) {
                    StringBuffer result = new StringBuffer();
                    result.append(pattern.charAt(3));
                    result.append(StringFunctions.permuteMultiWordAndTrim(StringFunctions.normalizeDiacritics(word, false), " -").toUpperCase());
                    result.append(pattern.charAt(4));
                    return result.toString();
                }
                return StringFunctions.permuteMultiWordAndTrim(StringFunctions.normalizeDiacritics(word, false), " -").toUpperCase();
            }
        }
        return null;
    }

    public static String reverseMultiWord(String word, String delimSymbols) {
        StringBuffer result = new StringBuffer();
        StringTokenizer T = new StringTokenizer(word, delimSymbols, true);
        ArrayList<String> A = new ArrayList<String>();
        while (T.hasMoreTokens()) {
            A.add(T.nextToken());
        }
        for (int i = A.size() - 1; i >= 0; --i) {
            result.append((String)A.get(i));
        }
        return result.toString();
    }

    public static String permuteMultiWordAndTrim(String S, String delimSymbols) {
        StringBuffer result = new StringBuffer();
        StringTokenizer T = new StringTokenizer(S, delimSymbols, false);
        ArrayList<String> A = new ArrayList<String>();
        while (T.hasMoreTokens()) {
            A.add(T.nextToken());
        }
        if (A.size() > 3) {
            for (int i = 1; i < A.size(); ++i) {
                result.append((String)A.get(i));
            }
        } else {
            return "x";
        }
        result.append(' ');
        result.append((String)A.get(0));
        return result.toString();
    }

    public static boolean containsEmptyLines(int start, int end, char[] text) {
        int count = 0;
        for (int i = start; i <= end; ++i) {
            if (text[i] != '\n') continue;
            ++count;
        }
        return count > 1;
    }

    public static char[] stringBufferToArray(StringBuffer s) {
        int len = s.length();
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            result[i] = s.charAt(i);
        }
        return result;
    }

    public static String[] createStringArrayFromHashMap(HashMap<String, Integer> myMap) {
        int size = myMap.size();
        String[] newArray = new String[size];
        for (String nextString : myMap.keySet()) {
            int index = myMap.get(nextString);
            if (index < 0 || index >= size) {
                return null;
            }
            newArray[index] = nextString;
        }
        return newArray;
    }
}

