/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.Files;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class ApplyDistanceMetrics {
    private static Properties initialize(String FileName) {
        Properties props = new Properties();
        try {
            FileInputStream FIS = new FileInputStream(FileName);
            props.load(FIS);
            FIS.close();
        }
        catch (IOException e) {
            System.out.println("IO ERROR while reading " + FileName);
            return null;
        }
        return props;
    }

    private static void messageAndExit(String m) {
        System.out.println(m);
        System.exit(0);
    }

    public static void main(String[] args) {
        String[] input2;
        String[] input1;
        AbstractDistanceMetric currentMetric;
        Properties props;
        if (args.length != 1) {
            ApplyDistanceMetrics.messageAndExit("Usage: applyDistanceMetric ConfigurationFile");
        }
        if ((props = ApplyDistanceMetrics.initialize(args[0])) == null) {
            ApplyDistanceMetrics.messageAndExit("Properties in " + args[0] + " are invalid");
        }
        String metric = props.getProperty("METRIC");
        String metricConfiguration = props.getProperty("METRICCONF");
        String inputFileName1 = props.getProperty("INPUTFILE1");
        String inputFileName2 = props.getProperty("INPUTFILE2");
        String encoding = props.getProperty("ENCODING");
        String outputFileName = props.getProperty("OUTPUTFILE");
        String minimumValueThreshold = props.getProperty("MINVAL");
        if (metric == null) {
            ApplyDistanceMetrics.messageAndExit("METRIC attribute not specified");
        }
        if ((currentMetric = AbstractDistanceMetric.getInstance(metric)) == null) {
            ApplyDistanceMetrics.messageAndExit("Metric: " + metric + " is not supported");
        }
        boolean status = true;
        if (metricConfiguration != null) {
            status = currentMetric.setProperties(metricConfiguration);
        }
        if (!status) {
            ApplyDistanceMetrics.messageAndExit("METRICCONF has some invalid values");
        }
        if (metricConfiguration != null) {
            currentMetric.setProperties(metricConfiguration);
            currentMetric.setDescription(metric + "::" + metricConfiguration);
        }
        if (inputFileName1 == null) {
            ApplyDistanceMetrics.messageAndExit("MISSING PROPERTY INPUTFILE1");
        }
        if (inputFileName2 == null) {
            ApplyDistanceMetrics.messageAndExit("MISSING PROPERTY INPUTFILE2");
        }
        if (encoding == null) {
            ApplyDistanceMetrics.messageAndExit("MISSING PROPERTY ENCODING");
        }
        try {
            input1 = Files.FileToStringArray(inputFileName1, encoding);
        }
        catch (Exception e) {
            input1 = null;
        }
        try {
            input2 = Files.FileToStringArray(inputFileName2, encoding);
        }
        catch (Exception e) {
            input2 = null;
        }
        if (input1 == null) {
            ApplyDistanceMetrics.messageAndExit("Input file: " + inputFileName1 + " could not be accessed.");
        }
        if (input2 == null) {
            ApplyDistanceMetrics.messageAndExit("Input file: " + inputFileName2 + " could not be accessed.");
        }
        float minVal = 1.0f;
        if (minimumValueThreshold != null) {
            try {
                minVal = Float.parseFloat(minimumValueThreshold);
            }
            catch (Exception e) {
                ApplyDistanceMetrics.messageAndExit("The value: " + minimumValueThreshold + " is not valid for the MINVAL attribute.");
            }
        }
        System.out.println("METRIC USED: " + currentMetric.getConfiguration());
        StringArrayList outputList = new StringArrayList();
        int len1 = input1.length;
        int len2 = input2.length;
        String current = null;
        String compareWith = null;
        for (int i = 0; i < len1; ++i) {
            current = input1[i];
            for (int j = 0; j < len2; ++j) {
                compareWith = input2[j];
                float metricVal = currentMetric.getDistance(current, compareWith);
                if (!(metricVal <= minVal)) continue;
                outputList.add(current + "\t" + compareWith + "\t" + metricVal);
            }
        }
        Files.StringArrayListToFile(outputFileName, outputList, encoding);
    }
}

