/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import piskorski.util.strings.distmetrics.DistanceRecord;

public class DistanceRecords {
    DistanceRecord[] myDistanceRecords;

    protected DistanceRecords() {
        this.myDistanceRecords = null;
    }

    private DistanceRecords(DistanceRecord[] distRecords) {
        int numEntries = distRecords.length;
        this.myDistanceRecords = new DistanceRecord[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            this.myDistanceRecords[i] = DistanceRecord.createInstance(distRecords[i]);
        }
    }

    private DistanceRecords(DistanceRecords distRecords) {
        int numEntries = distRecords.getNumberOfEntries();
        this.myDistanceRecords = new DistanceRecord[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            this.myDistanceRecords[i] = distRecords.myDistanceRecords[i];
        }
    }

    public static DistanceRecords createInstance(DistanceRecord[] distRecords) {
        return new DistanceRecords(distRecords);
    }

    public static DistanceRecords createInstance(DistanceRecords distRecords) {
        return new DistanceRecords(distRecords);
    }

    public int getNumberOfEntries() {
        return this.myDistanceRecords.length;
    }

    public DistanceRecord getDistanceRecord(int i) {
        return i < this.myDistanceRecords.length ? this.myDistanceRecords[i] : null;
    }

    public String toString() {
        String endOfLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        int numEntries = this.getNumberOfEntries();
        for (int i = 0; i < numEntries; ++i) {
            buffer.append(this.myDistanceRecords[i]);
            buffer.append(endOfLine);
        }
        return buffer.toString();
    }

    public static DistanceRecords sortDistanceRecords(HashMap<String, Double> distances) {
        int numberDistances = distances.size();
        DistanceRecord[] myDistances = new DistanceRecord[numberDistances];
        int count = 0;
        for (Map.Entry<String, Double> entry : distances.entrySet()) {
            myDistances[count++] = DistanceRecord.createInstance(entry.getKey(), entry.getValue());
        }
        Arrays.sort(myDistances, DistanceRecord.DistanceRecordComparator);
        return DistanceRecords.createInstance(myDistances);
    }
}

