/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.StringFunctions;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class JaroWinkler
extends AbstractDistanceMetric {
    float boostingThreshold = 0.3f;
    float commonPrefixAdjustment = 0.1f;
    int maxPrefixLen = 6;
    AbstractDistanceMetric metric = AbstractDistanceMetric.getInstance("Jaro");

    @Override
    public float getDistance(String s1, String s2) {
        int lenCommonPrefix = Math.min(StringFunctions.getLengthOfTheCommonPrefix(s1, s2), this.maxPrefixLen);
        float metricVal = this.metric.getDistance(s1, s2);
        if (metricVal < this.boostingThreshold) {
            return metricVal - (float)lenCommonPrefix * this.commonPrefixAdjustment * metricVal;
        }
        return metricVal;
    }

    @Override
    public String getName() {
        return "JaroWinkler";
    }

    @Override
    public void setProperties(Properties props) {
        float val;
        String boostingThreshold = props.getProperty("BOOSTTHRESHOLD");
        String commonPrefixAdjustment = props.getProperty("CPREFADJUSTMENT");
        String maxPrefixLen = props.getProperty("MAXPREFIXLEN");
        if (boostingThreshold != null) {
            try {
                val = Float.parseFloat(boostingThreshold);
                if (val >= 0.0f) {
                    this.boostingThreshold = val;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (commonPrefixAdjustment != null) {
            try {
                val = Float.parseFloat(commonPrefixAdjustment);
                if (val >= 0.0f) {
                    this.commonPrefixAdjustment = val;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (maxPrefixLen != null) {
            try {
                int val2 = Integer.parseInt(maxPrefixLen);
                if (val2 > 0) {
                    this.maxPrefixLen = val2;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": BOOSTTHRESHOLD:" + this.boostingThreshold + " CPREFADJUSTMENT:" + this.commonPrefixAdjustment + " MAXPREFIXLEN:" + this.maxPrefixLen;
    }
}

