/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import java.util.StringTokenizer;
import piskorski.util.strings.StringFunctions;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class JaroWinkler2
extends AbstractDistanceMetric {
    float boostingThreshold = 0.3f;
    float commonPrefixAdjustment = 0.1f;
    int maxPrefixLen = 6;
    AbstractDistanceMetric metric = AbstractDistanceMetric.getInstance("Jaro");

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": BOOSTTHRESHOLD:" + this.boostingThreshold + " CPREFADJUSTMENT:" + this.commonPrefixAdjustment + " MAXPREFIXLEN:" + this.maxPrefixLen;
    }

    @Override
    public float getDistance(String s1, String s2) {
        StringTokenizer sT1 = new StringTokenizer(s1, " \t", false);
        StringTokenizer sT2 = new StringTokenizer(s2, " \t", false);
        String[] tokensS1 = new String[sT1.countTokens()];
        int i = 0;
        while (sT1.hasMoreTokens()) {
            tokensS1[i++] = sT1.nextToken();
        }
        String[] tokensS2 = new String[sT2.countTokens()];
        i = 0;
        while (sT2.hasMoreTokens()) {
            tokensS2[i++] = sT2.nextToken();
        }
        int len1 = tokensS1.length;
        int len2 = tokensS2.length;
        int lenCommonPrefix = 0;
        float normalizationFactor = 1.0f;
        if (len1 == 1 && len2 == 1) {
            lenCommonPrefix = Math.min(StringFunctions.getLengthOfTheCommonPrefix(s1, s2), this.maxPrefixLen);
        } else {
            int minLen = Math.min(len1, len2);
            for (i = 0; i < minLen - 1; ++i) {
                lenCommonPrefix += Math.min(StringFunctions.getLengthOfTheCommonPrefix(tokensS1[i], tokensS2[i]), this.maxPrefixLen);
            }
            StringBuffer temp = new StringBuffer();
            for (i = minLen - 1; i < len1 - 1; ++i) {
                temp.append(tokensS1[i]);
                temp.append(" ");
            }
            temp.append(tokensS1[i]);
            String last1 = temp.toString();
            temp.setLength(0);
            for (i = minLen - 1; i < len2 - 1; ++i) {
                temp.append(tokensS2[i]);
                temp.append(" ");
            }
            temp.append(tokensS2[i]);
            String last2 = temp.toString();
            lenCommonPrefix += Math.min(StringFunctions.getLengthOfTheCommonPrefix(last1, last2), this.maxPrefixLen);
            normalizationFactor = 1.0f / (float)minLen;
        }
        float metricVal = this.metric.getDistance(s1, s2);
        if (metricVal < this.boostingThreshold) {
            return metricVal - (float)lenCommonPrefix * normalizationFactor * this.commonPrefixAdjustment * metricVal;
        }
        return metricVal;
    }

    @Override
    public String getName() {
        return "JaroWinkler2";
    }

    @Override
    public void setProperties(Properties props) {
        float val;
        String boostingThreshold = props.getProperty("BOOSTTHRESHOLD");
        String commonPrefixAdjustment = props.getProperty("CPREFADJUSTMENT");
        String maxPrefixLen = props.getProperty("MAXPREFIXLEN");
        if (boostingThreshold != null) {
            try {
                val = Float.parseFloat(boostingThreshold);
                if (val >= 0.0f) {
                    this.boostingThreshold = val;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (commonPrefixAdjustment != null) {
            try {
                val = Float.parseFloat(commonPrefixAdjustment);
                if (val >= 0.0f) {
                    this.commonPrefixAdjustment = val;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (maxPrefixLen != null) {
            try {
                int val2 = Integer.parseInt(maxPrefixLen);
                if (val2 > 0) {
                    this.maxPrefixLen = val2;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

