/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class Levenshtein
extends AbstractDistanceMetric {
    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": no parameters";
    }

    private int getLevensteinScore(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                int cost = s.charAt(i - 1) == t.charAt(j - 1) ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    @Override
    public float getDistance(String s1, String s2) {
        int lenS2;
        int levensteinDistance = this.getLevensteinScore(s1, s2);
        int lenS1 = s1.length();
        int maxLen = lenS1 > (lenS2 = s2.length()) ? lenS1 : lenS2;
        return maxLen == 0 ? 0.0f : (float)levensteinDistance / (float)maxLen;
    }

    @Override
    public String getName() {
        return "Levenshtein";
    }

    @Override
    public void setProperties(Properties props) {
    }
}

