/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.StringFunctions;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class LongestCommonSubstrings
extends AbstractDistanceMetric {
    private int minLenOfLCS = 3;

    private int computeLongestCommonSubstrings(String s1, String s2) {
        int lenS1 = s1.length();
        int lenS2 = s2.length();
        if (lenS1 < this.minLenOfLCS || lenS2 < this.minLenOfLCS) {
            return 0;
        }
        String lcs = StringFunctions.LongestCommonSubstring(s1, s2);
        int lenLcs = lcs.length();
        if (lenLcs < this.minLenOfLCS) {
            return 0;
        }
        int start = s1.indexOf(lcs);
        String newS1 = s1.substring(0, start) + s1.substring(start + lenLcs);
        start = s2.indexOf(lcs);
        String newS2 = s2.substring(0, start) + s2.substring(start + lenLcs);
        return lenLcs + this.computeLongestCommonSubstrings(newS1, newS2);
    }

    @Override
    public float getDistance(String s1, String s2) {
        int lenS2;
        int lcs = this.computeLongestCommonSubstrings(s1, s2);
        int lenS1 = s1.length();
        int maxLen = lenS1 > (lenS2 = s2.length()) ? lenS1 : lenS2;
        return 1.0f - (float)lcs / (float)maxLen;
    }

    @Override
    public String getName() {
        return "LongestCommonSubstrings";
    }

    @Override
    public void setProperties(Properties props) {
        String minLen = props.getProperty("MINLEN");
        if (minLen != null) {
            try {
                int minLenVal = Integer.parseInt(minLen);
                if (minLenVal > 0) {
                    this.minLenOfLCS = minLenVal;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": MINLEN:" + this.minLenOfLCS;
    }
}

