/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import java.util.StringTokenizer;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class MongeElkan
extends AbstractDistanceMetric {
    private AbstractDistanceMetric distanceMetric = AbstractDistanceMetric.getInstance("Jaro");

    @Override
    public String getConfiguration() {
        String metricName = this.distanceMetric.getClass().getName();
        return this.getClass().getName() + ": INTERNAL_METRIC:" + metricName + " CONF:" + this.distanceMetric.getConfiguration();
    }

    @Override
    public float getDistance(String s1, String s2) {
        StringTokenizer sT1 = new StringTokenizer(s1, " \t", false);
        StringTokenizer sT2 = new StringTokenizer(s2, " \t", false);
        String[] tokensS1 = new String[sT1.countTokens()];
        int i = 0;
        while (sT1.hasMoreTokens()) {
            tokensS1[i++] = sT1.nextToken();
        }
        String[] tokensS2 = new String[sT2.countTokens()];
        i = 0;
        while (sT2.hasMoreTokens()) {
            tokensS2[i++] = sT2.nextToken();
        }
        int lenTokensS1 = tokensS1.length;
        int lenTokensS2 = tokensS2.length;
        float totalMin = 0.0f;
        for (i = 0; i < lenTokensS1; ++i) {
            String current = tokensS1[i];
            float currentMin = 1.0f;
            for (int j = 0; j < lenTokensS2; ++j) {
                String compareWith = tokensS2[j];
                float currentVal = this.distanceMetric.getDistance(current, compareWith);
                if (!(currentVal < currentMin)) continue;
                currentMin = currentVal;
            }
            totalMin += currentMin;
        }
        return totalMin / (float)lenTokensS1;
    }

    @Override
    public String getName() {
        return "MongeElkan";
    }

    @Override
    public void setProperties(Properties props) {
        String metric = props.getProperty("METRIC");
        if (metric != null) {
            try {
                AbstractDistanceMetric newDistanceMetric = AbstractDistanceMetric.getInstance(metric);
                if (newDistanceMetric != null) {
                    this.distanceMetric = newDistanceMetric;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.distanceMetric.setProperties(props);
    }
}

