/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Arrays;
import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class PositionalQgrams
extends AbstractDistanceMetric {
    private int q = 3;
    private int k = 1;
    private char STARTPADDING = (char)35;
    private char ENDPADDING = (char)36;

    private final PositionalQGRAM[] getPositionalQGRAMS(String input) {
        int i;
        int lenInput = input.length();
        int aStringLen = lenInput + 2 * (this.q - 1);
        int pQgramLen = lenInput + this.q - 1;
        PositionalQGRAM[] pQgrams = new PositionalQGRAM[pQgramLen];
        char[] aString = new char[aStringLen];
        for (i = 0; i < this.q - 1; ++i) {
            aString[i] = this.STARTPADDING;
        }
        for (i = 0; i < lenInput; ++i) {
            aString[this.q - 1 + i] = input.charAt(i);
        }
        for (i = this.q - 1 + lenInput; i < aStringLen; ++i) {
            aString[i] = this.ENDPADDING;
        }
        for (int curPos = 0; curPos < pQgramLen; ++curPos) {
            PositionalQGRAM newPQ;
            String term = new String(aString, curPos, this.q);
            pQgrams[curPos] = newPQ = new PositionalQGRAM(term, curPos);
        }
        return pQgrams;
    }

    @Override
    public float getDistance(String s1, String s2) {
        PositionalQGRAM[] Qgrams1 = this.getPositionalQGRAMS(s1);
        PositionalQGRAM[] Qgrams2 = this.getPositionalQGRAMS(s2);
        int lenQgrams1 = Qgrams1.length;
        int lenQgrams2 = Qgrams2.length;
        boolean[] matched = new boolean[lenQgrams2];
        Arrays.fill(matched, false);
        int inCommon = 0;
        block0: for (int i = 0; i < lenQgrams1; ++i) {
            PositionalQGRAM current = Qgrams1[i];
            int position = current.position;
            int start = Math.max(position - this.k, 0);
            int end = Math.min(position + this.k, lenQgrams2 - 1);
            for (int j = start; j <= end; ++j) {
                PositionalQGRAM comparedWith;
                if (matched[j] || !current.compatibleQgram(comparedWith = Qgrams2[j])) continue;
                matched[j] = true;
                ++inCommon;
                continue block0;
            }
        }
        int maxNumQgrams = Math.max(lenQgrams1, lenQgrams2);
        return 1.0f - (float)inCommon / (float)maxNumQgrams;
    }

    @Override
    public String getName() {
        return "PositionalQgrams";
    }

    @Override
    public void setProperties(Properties props) {
        String q = props.getProperty("Q");
        String k = props.getProperty("K");
        String startpadding = props.getProperty("STARTPADDING");
        String endpadding = props.getProperty("ENDPADDING");
        if (q != null) {
            try {
                int qVal = Integer.parseInt(q);
                if (qVal > 0) {
                    this.q = qVal;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (k != null) {
            try {
                int kVal = Integer.parseInt(k);
                if (kVal >= 0) {
                    this.k = kVal;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (startpadding != null && startpadding.length() == 1) {
            this.STARTPADDING = startpadding.charAt(0);
        }
        if (endpadding != null && endpadding.length() == 1) {
            this.ENDPADDING = endpadding.charAt(0);
        }
    }

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": Q:" + this.q + " K:" + this.k + " STARTPADDING:" + this.STARTPADDING + " ENDPADDING:" + this.ENDPADDING;
    }

    private static class PositionalQGRAM {
        private String qgram;
        int position;

        public PositionalQGRAM() {
            this.qgram = null;
            this.position = 0;
        }

        public PositionalQGRAM(String qgram, int position) {
            this.qgram = qgram;
            this.position = position;
        }

        public void setQgram(String qgram) {
            this.qgram = qgram;
        }

        public void setPosition(int i) {
            this.position = i;
        }

        public int getPosition() {
            return this.position;
        }

        public String getQGram() {
            return this.qgram;
        }

        public boolean compatibleQgram(PositionalQGRAM pQ) {
            return this.qgram.compareTo(pQ.qgram) == 0;
        }

        public boolean compatible(PositionalQGRAM pQ, int k) {
            if (this.qgram.compareTo(pQ.qgram) != 0) {
                return false;
            }
            return !(this.position > pQ.position ? this.position - pQ.position > k : pQ.position - this.position > k);
        }

        public String toString() {
            return "(" + this.position + "," + this.qgram + ")";
        }
    }
}

