/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class SkipGrams
extends AbstractDistanceMetric {
    private int[] gramClass;
    private char STARTPADDING = (char)35;
    private char ENDPADDING = (char)36;

    public SkipGrams() {
        this.gramClass = new int[2];
        this.gramClass[0] = 0;
        this.gramClass[1] = 1;
    }

    private String[] getSkipGrams(String input) {
        int i;
        int lenInput = input.length();
        StringArrayList tempQgrams = new StringArrayList(lenInput * 2);
        int aStringLen = lenInput + 2;
        char[] aString = new char[aStringLen];
        aString[0] = this.STARTPADDING;
        for (i = 0; i < lenInput; ++i) {
            aString[1 + i] = input.charAt(i);
        }
        aString[i + 1] = this.ENDPADDING;
        char[] skipGram = new char[2];
        int numGramClasses = this.gramClass.length;
        for (i = 0; i < numGramClasses; ++i) {
            int gramClass = this.gramClass[i];
            int length = aStringLen - gramClass - 1;
            for (int curPos = 0; curPos < length; ++curPos) {
                skipGram[0] = aString[curPos];
                skipGram[1] = aString[curPos + gramClass + 1];
                tempQgrams.add(new String(skipGram));
            }
        }
        int finalLen = tempQgrams.size();
        String[] Qgrams2 = new String[finalLen];
        for (i = 0; i < finalLen; ++i) {
            Qgrams2[i] = tempQgrams.get(i);
        }
        return Qgrams2;
    }

    @Override
    public float getDistance(String s1, String s2) {
        String[] Qgrams1 = this.getSkipGrams(s1);
        String[] Qgrams2 = this.getSkipGrams(s2);
        int lenQgrams1 = Qgrams1.length;
        int lenQgrams2 = Qgrams2.length;
        boolean[] matched = new boolean[lenQgrams2];
        Arrays.fill(matched, false);
        int inCommon = 0;
        block0: for (int i = 0; i < lenQgrams1; ++i) {
            String current = Qgrams1[i];
            for (int j = 0; j < lenQgrams2; ++j) {
                String comparedWith;
                if (matched[j] || current.compareTo(comparedWith = Qgrams2[j]) != 0) continue;
                matched[j] = true;
                ++inCommon;
                continue block0;
            }
        }
        int maxNumQgrams = Math.max(lenQgrams1, lenQgrams2);
        return 1.0f - (float)inCommon / (float)maxNumQgrams;
    }

    @Override
    public String getName() {
        return "SkipGrams";
    }

    @Override
    public void setProperties(Properties props) {
        String skip = props.getProperty("GRAMCLASSES");
        String startpadding = props.getProperty("STARTPADDING");
        String endpadding = props.getProperty("ENDPADDING");
        if (skip != null) {
            try {
                StringTokenizer gClasses = new StringTokenizer(skip, ",", false);
                int numGClasses = gClasses.countTokens();
                this.gramClass = new int[numGClasses];
                int k = 0;
                while (gClasses.hasMoreTokens()) {
                    String next = gClasses.nextToken();
                    int val = Integer.parseInt(next);
                    if (val >= 0) {
                        this.gramClass[k++] = val;
                        continue;
                    }
                    throw new Exception();
                }
            }
            catch (Exception e) {
                this.gramClass = new int[2];
                this.gramClass[0] = 0;
                this.gramClass[1] = 1;
            }
        }
        if (startpadding != null && startpadding.length() == 1) {
            this.STARTPADDING = startpadding.charAt(0);
        }
        if (endpadding != null && endpadding.length() == 1) {
            this.ENDPADDING = endpadding.charAt(0);
        }
    }

    @Override
    public String getConfiguration() {
        StringBuffer out = new StringBuffer();
        out.append(this.getClass().getName() + " STARTPADDING:" + this.STARTPADDING + " ENDPADDING:" + this.ENDPADDING + " GRAMCLASS:");
        int numGC = this.gramClass.length;
        for (int i = 0; i < numGC; ++i) {
            out.append(this.gramClass[i]);
            if (i >= numGC - 1) continue;
            out.append(",");
        }
        return out.toString();
    }
}

