/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;
import piskorski.util.strings.distmetrics.AbstractSubstitutionCost;
import piskorski.util.strings.distmetrics.DefaultSubstCostSmithWaterman;

public class SmithWaterman
extends AbstractDistanceMetric {
    private boolean diceCoefficient = false;
    private float gapCost = 0.5f;
    private AbstractSubstitutionCost subCostFunc = new DefaultSubstCostSmithWaterman();

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": GAPCOST:" + this.gapCost + " SUBSTCOSTFUNCTION:" + this.subCostFunc.getName() + " DICECOEFFICIENT:" + this.diceCoefficient;
    }

    private float getSmithWatermanScore(String s, String t) {
        int j;
        float cost;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n][m];
        float maxSoFar = 0.0f;
        for (i = 0; i < n; ++i) {
            cost = this.subCostFunc.getCost(s, i, t, 0);
            if (i == 0) {
                d[0][0] = Math.max(Math.max(0.0f, -this.gapCost), cost);
            } else {
                d[i][0] = Math.max(Math.max(0.0f, d[i - 1][0] - this.gapCost), cost);
            }
            if (!(d[i][0] > maxSoFar)) continue;
            maxSoFar = d[i][0];
        }
        for (j = 0; j < m; ++j) {
            cost = this.subCostFunc.getCost(s, 0, t, j);
            if (j == 0) {
                d[0][0] = Math.max(Math.max(0.0f, -this.gapCost), cost);
            } else {
                d[0][j] = Math.max(Math.max(0.0f, d[0][j - 1] - this.gapCost), cost);
            }
            if (!(d[0][j] > maxSoFar)) continue;
            maxSoFar = d[0][j];
        }
        for (i = 1; i < n; ++i) {
            for (j = 1; j < m; ++j) {
                cost = this.subCostFunc.getCost(s, i, t, j);
                d[i][j] = Math.max(Math.max(0.0f, d[i - 1][j] - this.gapCost), Math.max(d[i][j - 1] - this.gapCost, d[i - 1][j - 1] + cost));
                if (!(d[i][j] > maxSoFar)) continue;
                maxSoFar = d[i][j];
            }
        }
        return maxSoFar;
    }

    @Override
    public float getDistance(String s1, String s2) {
        float maxValue;
        float smithWaterman = this.getSmithWatermanScore(s1, s2);
        float f = maxValue = this.diceCoefficient ? (float)(s1.length() + s2.length()) * 0.5f : (float)Math.min(s1.length(), s2.length());
        maxValue = this.subCostFunc.getMaxCost() > -this.gapCost ? (maxValue *= this.subCostFunc.getMaxCost()) : (maxValue *= -this.gapCost);
        return maxValue == 0.0f ? 1.0f : 1.0f - smithWaterman / maxValue;
    }

    @Override
    public String getName() {
        return "SmithWaterman";
    }

    @Override
    public void setProperties(Properties props) {
        String gapCost = props.getProperty("GAPCOST");
        String substCostFunction = props.getProperty("SUBSTCOSTFUNCTION");
        String diceCoeff = props.getProperty("DICECOEFFICIENT");
        if (gapCost != null) {
            try {
                this.gapCost = Float.parseFloat(gapCost);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (diceCoeff != null) {
            try {
                if (diceCoeff.compareTo("YES") == 0) {
                    this.diceCoefficient = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (substCostFunction != null) {
            try {
                AbstractSubstitutionCost newSubstCost = AbstractSubstitutionCost.getInstance(substCostFunction);
                if (newSubstCost != null) {
                    this.subCostFunc = newSubstCost;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

