/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class SortedTokensDistance
extends AbstractDistanceMetric {
    private AbstractDistanceMetric distanceMetric = AbstractDistanceMetric.getInstance("JaroWinkler");

    @Override
    public float getDistance(String s1, String s2) {
        StringTokenizer sT1 = new StringTokenizer(s1, " \t", false);
        StringTokenizer sT2 = new StringTokenizer(s2, " \t", false);
        Object[] tokensS1 = new String[sT1.countTokens()];
        int i = 0;
        while (sT1.hasMoreTokens()) {
            tokensS1[i++] = sT1.nextToken();
        }
        Object[] tokensS2 = new String[sT2.countTokens()];
        i = 0;
        while (sT2.hasMoreTokens()) {
            tokensS2[i++] = sT2.nextToken();
        }
        Arrays.sort(tokensS1);
        Arrays.sort(tokensS2);
        StringBuffer transformed = new StringBuffer();
        int len = tokensS1.length - 1;
        for (i = 0; i < len; ++i) {
            transformed.append((String)tokensS1[i]);
            transformed.append(" ");
        }
        transformed.append((String)tokensS1[i]);
        String newS1 = transformed.toString();
        transformed.setLength(0);
        len = tokensS2.length - 1;
        for (i = 0; i < len; ++i) {
            transformed.append((String)tokensS2[i]);
            transformed.append(" ");
        }
        transformed.append((String)tokensS2[i]);
        String newS2 = transformed.toString();
        return this.distanceMetric.getDistance(newS1, newS2);
    }

    @Override
    public String getName() {
        return "SortedTokens";
    }

    @Override
    public void setProperties(Properties props) {
        String metric = props.getProperty("METRIC");
        if (metric != null) {
            try {
                AbstractDistanceMetric newDistanceMetric = AbstractDistanceMetric.getInstance(metric);
                if (newDistanceMetric != null) {
                    this.distanceMetric = newDistanceMetric;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.distanceMetric.setProperties(props);
    }

    @Override
    public String getConfiguration() {
        String metricName = this.distanceMetric.getClass().getName();
        return this.getClass().getName() + ": INTERNAL_METRIC:" + metricName + " CONF:" + this.distanceMetric.getConfiguration();
    }
}

