/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.index;

import it.jrc.osint.index.IndexService;
import it.jrc.osint.index.internal.IndexServiceImpl;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.io.File;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class IndexPlugin
extends Plugin {
    public static final String PLUGIN_ID = "it.jrc.osint.index";
    public static final Version lucene_version = Version.LUCENE_42;
    public static final String PKField = "primary_key_id";
    public static final String ResourceIdfield = "resource_id";
    public static final String Projectfield = "project_id";
    public static final String Contentfield = "content";
    public static final String Pathfield = "path";
    public static final String Titlefield = "title";
    public static final String Typefield = "type";
    private static BundleContext context;
    private static IndexPlugin plugin;
    private static IndexServiceImpl indexService;
    private EventBroker eventBroker;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.eventBroker = new EventBroker(bundleContext);
        indexService = new IndexServiceImpl(this.eventBroker, IndexPlugin.getWorkspaceService(), this.getStateLocation());
        indexService.start();
        context = bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventBroker != null) {
            this.eventBroker.stop();
        }
        context = null;
        indexService = null;
        plugin = null;
    }

    static BundleContext getContext() {
        return context;
    }

    public static IndexPlugin getPlugin() {
        return plugin;
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    public static IndexService getIndexService() {
        return indexService;
    }

    public File getIndexFile() {
        IPath stateLocation = this.getStateLocation();
        IPath indexFilePath = stateLocation.append("index");
        return indexFilePath.toFile();
    }

    public static EventBroker getEventBroker() {
        return IndexPlugin.getPlugin().eventBroker;
    }
}

