/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.index.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.index.IndexPlugin;
import it.jrc.osint.index.IndexService;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RebuildIndexJob
extends Job {
    private static final Logger log = LogManager.getLogger((String)RebuildIndexJob.class.getName());
    private IndexService indexservice = IndexPlugin.getIndexService();
    private WorkspaceService ws = IndexPlugin.getWorkspaceService();

    public RebuildIndexJob(String jobName) {
        super(jobName);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Updating local index ", -1);
        try {
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                this.indexservice.createIndex();
                List caseProjects = this.ws.getCaseProjects();
                int ws_numdocs = 0;
                for (CaseProject cp : caseProjects) {
                    Iterator metaItemIterator = cp.getMetaItemProducer().iterator();
                    HashSet<ResourceId> filesToAddSet = new HashSet<ResourceId>();
                    while (metaItemIterator.hasNext()) {
                        DocumentMetaItem element = (DocumentMetaItem)metaItemIterator.next();
                        ResourceId filerid = element.getResourceId();
                        String filepk = filerid.toString().replaceAll("-", "");
                        ++ws_numdocs;
                        if (this.indexservice.checkFileInGlobalIndex(filepk)) continue;
                        filesToAddSet.add(filerid);
                    }
                    this.indexservice.addFilesInGlobalIndex(filesToAddSet);
                }
                if (this.indexservice.getNumDocsGlobalIndex() != ws_numdocs) {
                    if (ws_numdocs == 0) {
                        try {
                            this.indexservice.getGlobalIndex().deleteAll();
                        }
                        catch (IOException e) {
                            log.error("Error deleting all the documents in the index: " + e.toString());
                        }
                    } else {
                        this.indexservice.cleanGlobalIndex();
                    }
                }
            }
            catch (Exception e1) {
                log.error("Exception occurred during updating the local index: ", (Throwable)e1);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

