/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.io.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class WorkspaceUtil {
    private static final Logger log = LogManager.getLogger((String)WorkspaceUtil.class.getName());

    public static String getContentTypeId(IFile aFile) {
        IContentType contentType;
        IContentDescription contentDescription;
        block5: {
            if (aFile == null || !aFile.exists()) {
                return null;
            }
            try {
                contentDescription = aFile.getContentDescription();
                if (contentDescription != null) break block5;
                log.debug("Content description of file " + aFile.getName() + " is null, try to retrieve from IContentTypeManager");
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(aFile.getContents(), aFile.getName(), IContentDescription.ALL);
                if (contentDescription == null) {
                    log.debug("Failed to retrieve contentDescription from IContentTypeManager");
                }
                if ((contentType = Platform.getContentTypeManager().findContentTypeFor(aFile.getContents(), aFile.getName())) != null) break block5;
                log.debug("Failed to find content type for file " + aFile.getName());
                return null;
            }
            catch (Throwable t) {
                log.error("Failed to get content type for file " + aFile.getName(), t);
                return null;
            }
        }
        contentType = contentDescription.getContentType();
        return contentType.getId();
    }

    public static String getNextFolderName(IContainer parentContainer, String folderName, int uniqueId) {
        if (parentContainer == null || !parentContainer.exists()) {
            return folderName;
        }
        String testFolderName = folderName;
        if (uniqueId > 0) {
            testFolderName = String.valueOf(folderName) + "_" + Integer.toString(uniqueId);
        }
        if (WorkspaceUtil.resourceExists(parentContainer, (IPath)new Path(testFolderName))) {
            return WorkspaceUtil.getNextFolderName(parentContainer, folderName, ++uniqueId);
        }
        return testFolderName;
    }

    public static String getNextFileName(IContainer parentContainer, String fileName, int uniqueId) {
        if (parentContainer == null || !parentContainer.exists()) {
            return fileName;
        }
        String testFileName = fileName;
        if (uniqueId > 0) {
            testFileName = String.valueOf(FileUtil.getPrefix((String)fileName)) + "_" + Integer.toString(uniqueId) + "." + FileUtil.getFileExtension((String)fileName);
        }
        if (WorkspaceUtil.resourceExists(parentContainer, (IPath)new Path(testFileName))) {
            return WorkspaceUtil.getNextFileName(parentContainer, fileName, ++uniqueId);
        }
        return testFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean resourceExists(IResource aResource) {
        if (aResource == null) {
            return false;
        }
        if (aResource instanceof IWorkspaceRoot) {
            return true;
        }
        if (aResource.getParent().findMember(aResource.getName()) != null) {
            return true;
        }
        try {
            IResource[] members = aResource.getParent().members();
            if (members == null) return false;
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource res = iResourceArray[n2];
                if (res.getName().equalsIgnoreCase(aResource.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            log.error("Failed to check for existing resource: " + aResource.getName(), t);
        }
        return false;
    }

    public static IResource findFirstCaseVariant(IResource aResource) {
        if (aResource == null) {
            return null;
        }
        if (aResource instanceof IWorkspaceRoot) {
            return aResource;
        }
        IContainer parentContainer = aResource.getParent();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = parentContainer.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aMember = iResourceArray[n2];
                if (aMember.getName().equalsIgnoreCase(aResource.getName())) {
                    return aMember;
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            log.error("Failed to find first case variant of resource: " + aResource.getName(), t);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean resourceExists(IContainer parentContainer, IPath aResourcePath) {
        if (parentContainer.findMember(aResourcePath) != null) {
            return true;
        }
        String resourceName = aResourcePath.lastSegment();
        try {
            IResource[] members = parentContainer.members();
            if (members == null) return false;
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource aResource = iResourceArray[n2];
                if (aResource.getName().equalsIgnoreCase(resourceName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            log.error("Failed to check for existing file: " + resourceName, t);
        }
        return false;
    }

    public static boolean createDerivedFolder(IPath folderPath, IProject project) {
        return WorkspaceUtil.createDerivedFolder(folderPath.toString(), project);
    }

    public static boolean createDerivedFolder(String folderPath, IProject project) {
        try {
            boolean result = WorkspaceUtil.createFolder(folderPath, project);
            IFolder folder = project.getFolder(folderPath);
            folder.setDerived(true, null);
            return result;
        }
        catch (CoreException e) {
            log.error("Failed to create derived folder " + folderPath, (Throwable)e);
            return false;
        }
    }

    public static boolean createFolder(IPath folderPath, IProject project) {
        return WorkspaceUtil.createFolder(folderPath.toString(), project);
    }

    public static boolean createFolder(String folderPath, IProject project) {
        try {
            IFolder newFolder = project.getFolder(folderPath);
            if (!newFolder.exists()) {
                newFolder.create(true, true, null);
            }
            return true;
        }
        catch (CoreException e) {
            log.error("Failed to create folder " + folderPath, (Throwable)e);
            return false;
        }
    }

    public static boolean createFolderReadOnly(IPath folderPath, IProject project) {
        try {
            IFolder newFolder = project.getFolder(folderPath);
            if (!newFolder.exists()) {
                newFolder.create(true, true, null);
                ResourceAttributes attributes = newFolder.getResourceAttributes();
                if (attributes != null) {
                    attributes.setReadOnly(true);
                }
                newFolder.setResourceAttributes(attributes);
            }
            return true;
        }
        catch (CoreException e) {
            log.error("Failed to create folder " + folderPath, (Throwable)e);
            return false;
        }
    }
}

