/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.internal.BaseProjectImpl;
import it.jrc.osint.workspace.internal.ResourceDeltaVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

abstract class AbstractBuilder
extends IncrementalProjectBuilder {
    AbstractBuilder() {
    }

    protected abstract IProject[] build(int var1, Map<String, String> var2, IProgressMonitor var3) throws CoreException;

    protected abstract BaseProjectImpl getBaseProject();

    protected abstract Logger getLog();

    protected List<ResourceEvent> getResourceMonitorEvents(IResourceDelta rDelta) {
        List<ResourceEvent> events = new ArrayList<ResourceEvent>();
        if (rDelta == null) {
            return events;
        }
        try {
            DocumentsResourceDeltaVisitor visitor = new DocumentsResourceDeltaVisitor();
            rDelta.accept((IResourceDeltaVisitor)visitor);
            events = visitor.getEvents();
        }
        catch (CoreException e) {
            this.getLog().error("Failed to get resource monitor events", (Throwable)e);
        }
        Iterator iterator = events.iterator();
        while (iterator.hasNext()) {
            ResourceEvent event = (ResourceEvent)iterator.next();
            if (event.getResource() == null || !(event.getResource() instanceof IFolder) && !(event.getResource() instanceof IProject)) continue;
            iterator.remove();
        }
        return events;
    }

    protected class DocumentsResourceDeltaVisitor
    extends ResourceDeltaVisitor {
        @Override
        protected boolean includeResource(IResourceDelta delta) {
            IPath projectRelativePath = delta.getProjectRelativePath();
            if (projectRelativePath.segmentCount() == 0) {
                return true;
            }
            return delta.getResource().getType() != 2 || !delta.getResource().getName().equals(".osint");
        }
    }
}

