/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.AcquisitionMetaData;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.util.cache.Cache;
import it.jrc.osint.util.cache.SoftReferenceCache;
import it.jrc.osint.util.io.ContentTypeUtil;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.workspace.MarkerUtil;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceUtil;
import it.jrc.osint.workspace.internal.CaseProjectImpl;
import it.jrc.osint.workspace.internal.FileIndex;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

class DocumentRepository {
    private static final Logger log = LogManager.getLogger((String)DocumentRepository.class.getName());
    private IPath repositoryFolderPath;
    private CaseProjectImpl caseProject;
    private Cache<ResourceId, DocumentMetaItem> itemCache = new SoftReferenceCache();

    protected DocumentRepository(CaseProjectImpl caseProject, IPath repositoryFolderPath) {
        this.repositoryFolderPath = repositoryFolderPath;
        this.caseProject = caseProject;
    }

    private IProject getProject() {
        return this.caseProject.getProject();
    }

    private IPath getMetaItemPath(ResourceId docId) {
        Path metaItemPath = new Path(this.getMetaFolderPath() + "/" + docId.toString() + "." + "osd");
        return metaItemPath;
    }

    void compact() {
        CompactRepositoryJob compactJob = new CompactRepositoryJob();
        compactJob.setRule((ISchedulingRule)this.caseProject.getSystemFolder(".osint"));
        compactJob.setUser(false);
        compactJob.schedule();
    }

    private ResourceId getIdFromMetaFile(IFile file) {
        String fileName = file.getName();
        String fileExtension = file.getFileExtension();
        if (fileExtension == null || "".equals(fileExtension) || !"osd".equals(fileExtension)) {
            return null;
        }
        int indexOfFileExtension = fileName.lastIndexOf(fileExtension);
        String idStr = fileName.substring(0, indexOfFileExtension - 1);
        return new ResourceId(idStr);
    }

    Set<ResourceId> getResourceIds() {
        Set<ResourceId> idsFromIndex = this.getFileIndex().getResourceIds(this.getRepositoryPath());
        HashSet<ResourceId> validatedIds = new HashSet<ResourceId>();
        for (ResourceId id : idsFromIndex) {
            if (!this.validate(id)) continue;
            validatedIds.add(id);
        }
        return validatedIds;
    }

    private boolean validate(ResourceId id) {
        if (id == null) {
            return false;
        }
        boolean valid = true;
        if (!this.hasMetaItem(id)) {
            valid = false;
        }
        if (valid && !this.isMappedToFileInWorkspace(id)) {
            valid = false;
        }
        return valid;
    }

    private boolean isMappedToFileInWorkspace(ResourceId id) {
        IFile file;
        block5: {
            IPath path;
            block4: {
                try {
                    path = this.getFileIndex().getPath(id);
                    if (path != null) break block4;
                    return false;
                }
                catch (Throwable t) {
                    log.error("Could not check whether id " + id.toString() + " is mapped to file in workspace", t);
                    return false;
                }
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file != null) break block5;
            return false;
        }
        return file.exists();
    }

    boolean contains(IPath aPath) {
        if (aPath == null) {
            return false;
        }
        IPath repositoryPath = this.getRepositoryPath();
        return repositoryPath.isPrefixOf(aPath);
    }

    boolean contains(ResourceId docId) {
        if (docId == null) {
            return false;
        }
        IPath filePath = this.getFileIndex().getPath(docId);
        if (filePath == null) {
            return false;
        }
        IPath repositoryPath = this.getRepositoryPath();
        return repositoryPath.isPrefixOf(filePath);
    }

    ResourceId importFile_rm(File aFile, DocumentMetaItem metaItem, IFolder parentFolder) {
        log.debug("Importing file: " + aFile.getName() + " for link: " + metaItem.getLink());
        try {
            String fileName = aFile.getName();
            IFile newFile = null;
            if (WorkspaceUtil.resourceExists((IContainer)parentFolder, (IPath)new Path(fileName))) {
                fileName = WorkspaceUtil.getNextFileName((IContainer)parentFolder, fileName, 0);
            }
            newFile = parentFolder.getFile(fileName);
            ResourceId id = this.getFileIndex().getId(newFile.getFullPath());
            if (id == null) {
                log.error("Failed to obtain ResourceId for file " + newFile.getFullPath().toString());
                return ResourceId.NULL_ID;
            }
            RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
            rmd.setResourceId(id);
            this.saveContentFile_rm(newFile, aFile);
            this.saveMetaItem_rm(metaItem);
            return id;
        }
        catch (Throwable t) {
            log.error("Failed to import file", t);
            return ResourceId.NULL_ID;
        }
    }

    ResourceId fileAdded_rm(IFile aFile) {
        log.debug("File added: " + aFile.getName());
        IPath filePath = aFile.getFullPath();
        ResourceId id = this.getFileIndex().getId(filePath);
        if (!this.contains(filePath)) {
            return id;
        }
        DocumentMetaItem metaItem = null;
        metaItem = this.getMetaItem(id);
        if (metaItem == null) {
            log.debug("No meta item found for file: " + aFile.getName());
            metaItem = new DocumentMetaItem();
            AcquisitionMetaData amd = new AcquisitionMetaData(metaItem);
            amd.setSource("Import local disk");
        }
        RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
        rmd.setResourceId(id);
        rmd.setFileName(aFile.getName());
        rmd.setLinkedFile(aFile.getFullPath().toString());
        String binaryHash = this.createBinaryHash(aFile);
        rmd.setBinaryHash(binaryHash);
        String contentTypeId = ContentTypeUtil.getContentTypeId((IFile)aFile, (boolean)false, (String)"unknown-content-type");
        rmd.setContentTypeId(contentTypeId);
        this.saveMetaItem_rm(metaItem);
        return id;
    }

    private String createBinaryHash(IFile aFile) {
        if (aFile == null || !aFile.exists()) {
            return null;
        }
        InputStream in = null;
        String binHash = null;
        try {
            in = aFile.getContents();
            String string = binHash = this.createBinaryHash(in);
            return string;
        }
        catch (Throwable t) {
            log.error("Failed to compute binary hash for file " + aFile.getName(), t);
            return null;
        }
        finally {
            FileUtil.close((InputStream)in);
        }
    }

    private String createBinaryHash(InputStream in) throws IOException {
        return DigestUtils.shaHex((InputStream)in);
    }

    private void saveContentFile_rm(IFile targetFile, File sourceFile) {
        try {
            if (targetFile.exists()) {
                targetFile.setContents((InputStream)new FileInputStream(sourceFile), true, false, null);
            } else {
                targetFile.create((InputStream)new FileInputStream(sourceFile), true, null);
            }
        }
        catch (Throwable t) {
            log.error("Failed to copy file " + sourceFile.getPath() + " into workspace", t);
        }
    }

    ResourceId fileUpdated_rm(IFile aFile) {
        return this.fileAdded_rm(aFile);
    }

    ResourceId fileDeleted_rm(IFile aFile) {
        return this.getFileIndex().getId(aFile.getFullPath(), true);
    }

    ResourceId fileMovedWithin_rm(IFile toFile, IPath fromPath) {
        RepositoryMetaData rmd;
        ResourceId id = this.getFileIndex().getId(toFile.getFullPath());
        DocumentMetaItem metaItem = this.getMetaItem(id);
        IPath toPath = toFile.getFullPath();
        if (!this.contains(fromPath) && !this.contains(toPath)) {
            if (metaItem == null) {
                log.debug("No meta item found for file " + toPath);
            } else {
                rmd = new RepositoryMetaData(metaItem);
                rmd.setLinkedFile(toPath.toString());
                this.saveMetaItem_rm(metaItem);
            }
        }
        if (this.contains(fromPath) && !this.contains(toPath)) {
            if (metaItem == null) {
                log.debug("No meta item found for file " + toPath);
            } else {
                rmd = new RepositoryMetaData(metaItem);
                rmd.setLinkedFile(toFile.getFullPath().toString());
                this.saveMetaItem_rm(metaItem);
            }
            MarkerUtil.clean((IResource)toFile, "it.jrc.osint.extract.text.textExtractionMarker");
            MarkerUtil.clean((IResource)toFile, "it.jrc.osint.workspace.entityExtractionMarker");
            MarkerUtil.clean((IResource)toFile, "it.jrc.osint.workspace.errorStatusMarker");
        }
        if (this.contains(fromPath) && this.contains(toFile.getFullPath())) {
            if (metaItem == null) {
                log.error("No meta item found for file " + toPath);
            } else {
                rmd = new RepositoryMetaData(metaItem);
                rmd.setLinkedFile(toPath.toString());
                this.saveMetaItem_rm(metaItem);
            }
        }
        if (!this.contains(fromPath) && this.contains(toPath)) {
            if (metaItem == null) {
                metaItem = new DocumentMetaItem();
                MarkerUtil.mark((IResource)toFile, "it.jrc.osint.extract.text.textExtractionMarker");
                MarkerUtil.mark((IResource)toFile, "it.jrc.osint.workspace.entityExtractionMarker");
            }
            rmd = new RepositoryMetaData(metaItem);
            rmd.setResourceId(id);
            rmd.setLinkedFile(toPath.toString());
            rmd.setFileName(toFile.getName());
            this.saveMetaItem_rm(metaItem);
        }
        return id;
    }

    boolean hasMetaItem(ResourceId resourceId) {
        return this.getMetaItem(resourceId) != null;
    }

    DocumentMetaItem getMetaItem(ResourceId docId) {
        if (docId == null) {
            return null;
        }
        if (this.itemCache.contains((Object)docId)) {
            return (DocumentMetaItem)this.itemCache.get((Object)docId);
        }
        IFile metaItemFile = this.getProject().getFile(this.getMetaItemPath(docId));
        RSSItem resultItem = null;
        try {
            resultItem = this.loadFromItemFile(metaItemFile);
            if (resultItem != null) {
                DocumentMetaItem dmi = new DocumentMetaItem(resultItem);
                return dmi;
            }
            return null;
        }
        catch (Throwable t) {
            log.error("Failed to get meta item for file with path " + this.getFileIndex().getPath(docId), t);
            return null;
        }
    }

    void saveMetaItems(List<DocumentMetaItem> items) {
        WriteExtractionResultRunnable runnable = new WriteExtractionResultRunnable(items);
        IResource[] resources = new IResource[items.size()];
        int i = 0;
        for (DocumentMetaItem item : items) {
            IFile resource = this.getProject().getFile(this.getMetaItemPath(item.getResourceId()));
            resources[i++] = resource;
        }
        ISchedulingRule schedulingRule = MultiRule.combine((ISchedulingRule[])resources);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, schedulingRule, 1, null);
        }
        catch (CoreException e) {
            log.error("Failed to write extraction result items", (Throwable)e);
        }
    }

    void saveMetaItem(DocumentMetaItem metaItem) {
        ArrayList<DocumentMetaItem> items = new ArrayList<DocumentMetaItem>();
        items.add(metaItem);
        this.saveMetaItems(items);
    }

    void saveMetaItem_rm(DocumentMetaItem metaItem) {
        block10: {
            if (metaItem == null) {
                return;
            }
            ResourceId docId = metaItem.getResourceId();
            if (docId == null) {
                log.error("Failed to save meta item since resource id not set");
                return;
            }
            if (this.itemCache.contains((Object)docId)) {
                this.itemCache.remove((Object)docId);
            }
            IFile metaItemFile = this.getProject().getFile(this.getMetaItemPath(docId));
            OutputStreamWriter outWriter = null;
            try {
                try {
                    RSS rssItemFile = new RSS();
                    rssItemFile.addItem(metaItem.getItem());
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    outWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
                    rssItemFile.toXML((Writer)outWriter);
                    ((Writer)outWriter).flush();
                    if (metaItemFile.exists()) {
                        metaItemFile.setContents((InputStream)new ByteArrayInputStream(outStream.toByteArray()), true, false, null);
                    } else {
                        metaItemFile.create((InputStream)new ByteArrayInputStream(outStream.toByteArray()), true, null);
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to save rss meta item: " + metaItem.getResourceId(), t);
                    FileUtil.close(outWriter);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(outWriter);
                throw throwable;
            }
            FileUtil.close((Writer)outWriter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RSSItem loadFromItemFile(IFile itemFile) {
        RSSItem rSSItem;
        if (itemFile == null) {
            return null;
        }
        if (!itemFile.exists()) {
            return null;
        }
        InputStream in = null;
        try {
            RSSParser rssParser = new RSSParser();
            in = itemFile.getContents();
            RSS rssIn = rssParser.parse((Reader)new InputStreamReader(in, "UTF-8"));
            rSSItem = (RSSItem)rssIn.getItems().get(0);
        }
        catch (Throwable t) {
            try {
                log.error("Failed to read item from file " + itemFile.getName(), t);
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close((InputStream)in);
            return null;
        }
        FileUtil.close((InputStream)in);
        return rSSItem;
    }

    IFolder getMetaFolder() {
        IPath projectRelativePath = this.caseProject.getProjectLayout().getFolderPath(".osint/meta");
        IFolder metaDataFolder = this.getProject().getFolder(projectRelativePath);
        return metaDataFolder;
    }

    private IPath getMetaFolderPath() {
        IFolder metaDataFolder = this.getMetaFolder();
        if (!metaDataFolder.exists()) {
            WorkspaceUtil.createDerivedFolder(metaDataFolder.getProjectRelativePath(), this.getProject());
        }
        return metaDataFolder.getProjectRelativePath();
    }

    public void dumpMetaItem(IFile aFile) {
        if (!this.contains(aFile.getFullPath())) {
            log.debug("File: " + aFile.getFullPath() + " is not part of the repository");
            return;
        }
        ResourceId docId = this.getFileIndex().getId(aFile.getFullPath());
        DocumentMetaItem metaItem = this.getMetaItem(docId);
        metaItem.dump();
    }

    private FileIndex getFileIndex() {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        return ws.getFileIndex();
    }

    private IPath getRepositoryPath() {
        IPath projectPath = this.getProject().getFullPath();
        IPath repositoryPath = projectPath.append(this.repositoryFolderPath);
        return repositoryPath;
    }

    private class CompactRepositoryJob
    extends WorkspaceJob {
        public CompactRepositoryJob() {
            super("Compacting workspace");
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                List<IFile> danglingFiles = this.findDanglingFiles(DocumentRepository.this.getProject().getFolder(DocumentRepository.this.getMetaFolderPath()));
                monitor.beginTask("Removing unused meta files", danglingFiles.size());
                this.deleteMetaFiles(danglingFiles, monitor);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private List<IFile> findDanglingFiles(IFolder metaFolder) {
            ArrayList<IFile> danglingFiles = new ArrayList<IFile>();
            List<IFile> files = this.getMetaFilesInMetaFolder(metaFolder);
            for (IFile metaFile : files) {
                ResourceId id = DocumentRepository.this.getIdFromMetaFile(metaFile);
                if (id == null || DocumentRepository.this.getFileIndex().contains(id)) continue;
                danglingFiles.add(metaFile);
            }
            return danglingFiles;
        }

        private List<IFile> getMetaFilesInMetaFolder(IFolder metaFolder) {
            ArrayList<IFile> metaFiles = new ArrayList<IFile>();
            try {
                IResource[] metaResources;
                IResource[] iResourceArray = metaResources = metaFolder.members();
                int n = metaResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource aResource = iResourceArray[n2];
                    if (aResource instanceof IFile && "osd".equals(aResource.getFileExtension())) {
                        metaFiles.add((IFile)aResource);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                log.error("Failed to delete extraction meta items", (Throwable)e);
            }
            return metaFiles;
        }

        private void deleteMetaFiles(List<IFile> files, IProgressMonitor monitor) {
            for (IFile aFile : files) {
                try {
                    if (!aFile.exists()) continue;
                    aFile.delete(true, monitor);
                    monitor.worked(1);
                }
                catch (Throwable t) {
                    log.error("Failed to delete file: " + aFile, t);
                }
            }
        }
    }

    private class WriteExtractionResultRunnable
    implements IWorkspaceRunnable {
        private List<DocumentMetaItem> items;

        public WriteExtractionResultRunnable(List<DocumentMetaItem> items) {
            this.items = items;
        }

        public void run(IProgressMonitor monitor) {
            for (DocumentMetaItem item : this.items) {
                try {
                    DocumentRepository.this.saveMetaItem_rm(item);
                }
                catch (Throwable t) {
                    log.error("Failed to save RSS items", t);
                }
            }
        }
    }
}

