/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.workspace.internal.DocumentRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public class DocumentRepositoryConsumer
implements Consumer<DocumentMetaItem> {
    private static final int BULK_SAVE_LOT = 100;
    private Queue<DocumentMetaItem> saveQueue = new LinkedList<DocumentMetaItem>();
    private Set<String> idSet = new HashSet<String>();
    private DocumentRepository repository;
    private int consumedCount = 0;

    public DocumentRepositoryConsumer(DocumentRepository repo) {
        this.repository = repo;
    }

    public void consume(DocumentMetaItem anItem) {
        ResourceId documentId = anItem.getResourceId();
        if (documentId != null) {
            this.idSet.add(anItem.getResourceId().toString());
        }
        if (this.saveQueue.size() > 100) {
            ArrayList<DocumentMetaItem> saveList = new ArrayList<DocumentMetaItem>(100);
            int i = 0;
            while (i < 100) {
                DocumentMetaItem item = this.saveQueue.poll();
                if (item == null) break;
                saveList.add(item);
                ++i;
            }
            this.repository.saveMetaItems(saveList);
        }
        this.saveQueue.add(anItem);
        ++this.consumedCount;
    }

    public int consumedItemCount() {
        return this.consumedCount;
    }

    public void finish() {
        if (!this.saveQueue.isEmpty()) {
            ArrayList<DocumentMetaItem> saveList = new ArrayList<DocumentMetaItem>(this.saveQueue.size());
            saveList.addAll(this.saveQueue);
            this.repository.saveMetaItems(saveList);
        }
    }

    public void reset() {
        this.saveQueue.clear();
        this.idSet.clear();
        this.consumedCount = 0;
    }

    public void setContext(ProcessingContext context) {
    }

    public Set<String> getConsumedItemIds() {
        return this.idSet;
    }
}

