/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.util.concurrent.Producer;
import it.jrc.osint.workspace.internal.DocumentRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocumentRepositoryProducer
implements Producer<DocumentMetaItem> {
    private static final Logger log = LogManager.getLogger((String)DocumentRepositoryProducer.class.getName());
    private DocumentRepository repository;
    private List<ResourceId> initialIds = new ArrayList<ResourceId>();
    private List<ResourceId> ids = new ArrayList<ResourceId>();

    public DocumentRepositoryProducer(DocumentRepository repo, Set<ResourceId> ids) {
        this.repository = repo;
        this.initialIds.addAll(ids);
        this.ids.addAll(this.initialIds);
    }

    public int expectedItemCount() {
        return this.initialIds.size();
    }

    public void finish() {
    }

    public void reset() {
        this.ids.clear();
        this.ids.addAll(this.initialIds);
    }

    public void setContext(ProcessingContext newContext) {
    }

    public boolean hasNext() {
        return !this.ids.isEmpty();
    }

    public DocumentMetaItem next() {
        if (this.ids.isEmpty()) {
            return null;
        }
        ResourceId nextDocId = this.ids.remove(0);
        if (nextDocId == null) {
            return null;
        }
        DocumentMetaItem item = this.repository.getMetaItem(nextDocId);
        if (item == null) {
            log.warn("Failed to load meta data for resourceId:" + nextDocId);
        }
        return item;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by DocumentRepositorProducer");
    }

    public Iterator<DocumentMetaItem> iterator() {
        this.reset();
        return this;
    }
}

