/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.internal.CaseProjectImpl;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FileImportJob
extends WorkspaceJob {
    private static final Logger log = LogManager.getLogger((String)FileImportJob.class.getName());
    private CaseProjectImpl cp;
    private List<File> files;
    private List<DocumentMetaItem> metaItems;
    private IFolder parentFolder;

    public FileImportJob(CaseProjectImpl cp, List<File> files, List<DocumentMetaItem> metaItems, IFolder parentFolder) {
        super("Importing Files");
        this.cp = cp;
        this.files = files;
        this.metaItems = metaItems;
        this.parentFolder = parentFolder;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < this.files.size()) {
            File aFile = null;
            try {
                aFile = this.files.get(i);
                DocumentMetaItem metaItem = this.metaItems.get(i);
                this.cp.getDocumentRepository().importFile_rm(aFile, metaItem, this.parentFolder);
            }
            catch (Throwable t) {
                log.error("Failed to import file: " + aFile, t);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

