/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.workspace.ResourceEvent;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private List<ResourceEvent> parsedEvents = new LinkedList<ResourceEvent>();

    public List<ResourceEvent> getEvents() {
        return this.parsedEvents;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (!this.includeResource(delta)) {
            return false;
        }
        int flags = delta.getFlags();
        switch (delta.getKind()) {
            case 1: {
                if ((flags & 0x1000) == 4096) {
                    this.addResourceMovedEvent(delta.getResource(), delta.getMovedFromPath());
                    break;
                }
                this.addResourceCreatedEvent(delta.getResource());
                break;
            }
            case 2: {
                if ((flags & 0x2000) == 8192) break;
                this.addResourceDeletedEvent(delta.getResource());
                break;
            }
            case 4: {
                this.addResourceContentChangedEvent(delta.getResource());
                break;
            }
        }
        return true;
    }

    protected boolean includeResource(IResourceDelta delta) {
        return true;
    }

    private void addResourceMovedEvent(IResource aResource, IPath movedFromPath) {
        ResourceEvent monitorEvent = new ResourceEvent(aResource, ResourceEvent.EventType.MOVED);
        monitorEvent.setMovedFromPath(movedFromPath);
        this.parsedEvents.add(monitorEvent);
    }

    private void addResourceCreatedEvent(IResource aResource) {
        ResourceEvent monitorEvent = new ResourceEvent(aResource, ResourceEvent.EventType.CREATED);
        this.parsedEvents.add(monitorEvent);
    }

    private void addResourceDeletedEvent(IResource aResource) {
        ResourceEvent monitorEvent = new ResourceEvent(aResource, ResourceEvent.EventType.DELETED);
        this.parsedEvents.add(monitorEvent);
    }

    private void addResourceContentChangedEvent(IResource aResource) {
        ResourceEvent monitorEvent = new ResourceEvent(aResource, ResourceEvent.EventType.CONTENT_CHANGED);
        this.parsedEvents.add(monitorEvent);
    }
}

