/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.internal.FileIndex;
import it.jrc.osint.workspace.internal.ResourceMonitorListener;
import it.jrc.osint.workspace.internal.ResourceMonitorSubscription;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.util.LinkedList;
import java.util.List;

public class ResourceIdSubscription
extends ResourceMonitorSubscription {
    private ResourceId id;

    public ResourceIdSubscription(ResourceMonitorListener listener, ResourceId id) {
        super(listener);
        this.id = id;
    }

    @Override
    public void processEvents(List<ResourceEvent> events) {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        FileIndex fi = ws.getFileIndex();
        LinkedList<ResourceEvent> subscribedEvents = new LinkedList<ResourceEvent>();
        for (ResourceEvent event : events) {
            ResourceId eventResId = fi.getId(event.getMovedFromPath());
            if (eventResId == null || !eventResId.equals((Object)this.id)) continue;
            subscribedEvents.add(event);
        }
        this.getListener().resourcesChanged(subscribedEvents);
    }
}

