/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEventImpl;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

public class WorkspaceServiceEventImpl
extends SystemEventImpl
implements WorkspaceServiceEvent {
    private static final Logger log = LogManager.getLogger((String)WorkspaceServiceEventImpl.class.getName());
    private ResourceId projectId;
    private Set<ResourceId> resourceIds = new HashSet<ResourceId>();
    private Set<IPath> resourcePaths = new HashSet<IPath>();
    private Map<ResourceId, IPath> movedFromPathMap = new HashMap<ResourceId, IPath>();
    private String projectName;
    private boolean projectDeleted;

    WorkspaceServiceEventImpl(String topic) {
        super(topic);
    }

    WorkspaceServiceEventImpl(String topic, ResourceId projectId, String projectName) {
        super(topic);
        this.projectId = projectId;
        this.projectName = projectName;
    }

    public void setResourceIds(Set<ResourceId> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public void setResourceId(ResourceId resourceId) {
        this.resourceIds = new HashSet<ResourceId>();
        this.resourceIds.add(resourceId);
    }

    public void setMovedFromPathMap(Map<ResourceId, IPath> movedFromPathMap) {
        this.movedFromPathMap = movedFromPathMap;
    }

    public void setProjectDeleted(boolean projectDeleted) {
        this.projectDeleted = projectDeleted;
    }

    boolean merge(WorkspaceServiceEvent otherEvent) {
        if (this.getTopic().equals(otherEvent.getTopic()) && this.getProjectId().equals((Object)otherEvent.getProjectId())) {
            this.resourceIds = new HashSet<ResourceId>(this.resourceIds);
            this.resourceIds.addAll(otherEvent.getResourceIds());
            this.getMovedFromPathMap().putAll(otherEvent.getMovedFromPathMap());
            return true;
        }
        return false;
    }

    @Override
    public Set<ResourceId> getResourceIds() {
        return this.resourceIds;
    }

    @Override
    public Set<IPath> getResourcePaths() {
        if (this.resourcePaths.isEmpty() && !this.resourceIds.isEmpty()) {
            WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
            for (ResourceId id : this.resourceIds) {
                IPath path = ws.getPath(id, true);
                if (path == null) continue;
                this.resourcePaths.add(path);
            }
        }
        return this.resourcePaths;
    }

    @Override
    public boolean containsResources(IPath parentPath) {
        if (parentPath == null) {
            return false;
        }
        for (IPath path : this.getResourcePaths()) {
            if (path == null || !parentPath.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<ResourceId, IPath> getMovedFromPathMap() {
        return this.movedFromPathMap;
    }

    @Override
    public ResourceId getProjectId() {
        return this.projectId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public boolean isProjectDeleted() {
        return this.projectDeleted;
    }
}

