/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.io.ContentTypeUtil;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.workspace.BaseProject;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.ConfigProject;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import it.jrc.osint.workspace.WorkspaceUtil;
import it.jrc.osint.workspace.internal.CaseProjectImpl;
import it.jrc.osint.workspace.internal.ConfigProjectImpl;
import it.jrc.osint.workspace.internal.FileIndex;
import it.jrc.osint.workspace.internal.ResourceMonitorListener;
import it.jrc.osint.workspace.internal.ResourceMonitorService;
import it.jrc.osint.workspace.internal.WorkspaceJobSchedulingRule;
import it.jrc.osint.workspace.internal.WorkspaceSaveParticipant;
import it.jrc.osint.workspace.internal.WorkspaceServiceEventImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class WorkspaceServiceImpl
implements WorkspaceService {
    private static final Logger log = LogManager.getLogger((String)WorkspaceServiceImpl.class.getName());
    private Map<ResourceId, CaseProjectImpl> caseProjects = new HashMap<ResourceId, CaseProjectImpl>();
    private Map<ResourceId, ConfigProjectImpl> configProjects = new HashMap<ResourceId, ConfigProjectImpl>();
    private ResourceMonitorListener resourceMonitorListener = new ResourceMonitorListenerImpl();
    private boolean automaticExtractionEnabled;
    private FileIndex fileIndex;
    private EventBroker eventBroker;
    private ISchedulingRule workspaceSchedulingRule = new WorkspaceJobSchedulingRule();

    public WorkspaceServiceImpl(EventBroker eventBroker) {
        this.eventBroker = eventBroker;
        WorkspacePlugin.getPlugin().getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new PreferenceListener());
    }

    @Override
    public List<CaseProject> getCaseProjects() {
        return new ArrayList<CaseProject>(this.caseProjects.values());
    }

    @Override
    public List<ConfigProject> getConfigProjects() {
        return new ArrayList<ConfigProject>(this.configProjects.values());
    }

    @Override
    public ConfigProject getActiveConfigProject() {
        ResourceId activeProjectId = this.getActiveConfigProjectId();
        if (activeProjectId == null) {
            return null;
        }
        return this.getConfigProjectByProjectId(activeProjectId);
    }

    private ResourceId getActiveConfigProjectId() {
        IEclipsePreferences prefs = WorkspacePlugin.getPlugin().getPreferences();
        String activeProjectId = prefs.get("activeConfigProject", "_none");
        if ("_none".equals(activeProjectId)) {
            return null;
        }
        return new ResourceId(activeProjectId);
    }

    private void setActiveConfigPojectId(ResourceId configProjectId) {
        String newConfigIdValue = null;
        newConfigIdValue = configProjectId == null || configProjectId.isNull() ? "_none" : configProjectId.toString();
        IEclipsePreferences prefs = WorkspacePlugin.getPlugin().getPreferences();
        prefs.put("activeConfigProject", newConfigIdValue);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            log.error("Failed to write preferences", (Throwable)e);
        }
    }

    private void initialiseProject(final IProject project, final CaseProjectImpl caseProject) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.setDefaultCharset("UTF-8", monitor);
                    caseProject.createDefaultFolders_rm();
                    caseProject.createDefaultContent_rm();
                    caseProject.start();
                }
            }, (ISchedulingRule)project, 1, null);
        }
        catch (CoreException e) {
            log.error("Failed to initialise project: " + project.getName(), (Throwable)e);
        }
    }

    private void initialiseProject(final IProject project, final ConfigProjectImpl configProject) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.setDefaultCharset("UTF-8", monitor);
                    configProject.createDefaultFolders_rm();
                    configProject.createDefaultContent_rm();
                }
            }, (ISchedulingRule)project, 1, null);
        }
        catch (CoreException e) {
            log.error("Failed to initialise project: " + project.getName(), (Throwable)e);
        }
    }

    private void projectAdded(IProject project, List<WorkspaceServiceEvent> outEvents) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            if (project.hasNature("it.jrc.osint.workspace.caseProjectNature")) {
                if (this.getCaseProjectByName(project.getName()) == null) {
                    ResourceId id = this.getFileIndex().getId(project.getFullPath());
                    CaseProjectImpl caseProject = new CaseProjectImpl(id, this, project.getName());
                    this.caseProjects.put(caseProject.getId(), caseProject);
                    this.initialiseProject(project, caseProject);
                    outEvents.add(new WorkspaceServiceEventImpl("osint/workspace/projectAdded", caseProject.getId(), caseProject.getName()));
                }
            } else if (project.hasNature("it.jrc.osint.workspace.configProjectNature") && this.getConfigProject(project.getName()) == null) {
                ResourceId id = this.getFileIndex().getId(project.getFullPath());
                ConfigProjectImpl configProject = new ConfigProjectImpl(id, this, project.getName());
                this.configProjects.put(configProject.getId(), configProject);
                this.initialiseProject(project, configProject);
                outEvents.add(new WorkspaceServiceEventImpl("osint/workspace/projectAdded", configProject.getId(), configProject.getName()));
                this.setActiveConfigPojectId(configProject.getId());
            }
        }
        catch (Throwable t) {
            log.error("Failed to initialise project", t);
        }
    }

    private void projectDeleted(IProject project, List<WorkspaceServiceEvent> outEvents) {
        ConfigProject configPrj;
        CaseProject cp = this.getCaseProjectByName(project.getName());
        if (cp != null) {
            this.caseProjects.remove(cp.getId());
            ((CaseProjectImpl)cp).stop();
            WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/projectDeleted", cp.getId(), cp.getName());
            newEvent.setProjectDeleted(true);
            outEvents.add(newEvent);
        }
        if ((configPrj = this.getConfigProject(project.getName())) != null) {
            ConfigProjectImpl configProject = (ConfigProjectImpl)configPrj;
            this.configProjects.remove(configPrj.getId());
            WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/projectDeleted", configPrj.getId(), configPrj.getName());
            newEvent.setProjectDeleted(true);
            outEvents.add(newEvent);
            ResourceId activeConfigProjectId = this.getActiveConfigProjectId();
            if (activeConfigProjectId != null && activeConfigProjectId.equals((Object)configProject.getId())) {
                if (!this.configProjects.isEmpty()) {
                    ArrayList<ConfigProjectImpl> projectList = new ArrayList<ConfigProjectImpl>();
                    projectList.addAll(this.configProjects.values());
                    ConfigProjectImpl newActiveConfigPrj = (ConfigProjectImpl)projectList.get(0);
                    this.setActiveConfigPojectId(newActiveConfigPrj.getId());
                } else {
                    this.setActiveConfigPojectId(ResourceId.NULL_ID);
                }
            }
        }
    }

    private void projectRenamed(IProject project, IPath originalPath, List<WorkspaceServiceEvent> outEvents) {
        if (project == null || originalPath == null) {
            log.warn("projectRenamed called, but project or originalPath were null");
            return;
        }
        CaseProject cp = this.getCaseProjectByName(project.getName());
        if (cp != null) {
            outEvents.add(new WorkspaceServiceEventImpl("osint/workspace/projectMoved", cp.getId(), cp.getName()));
            return;
        }
        ConfigProject configPrj = this.getConfigProject(project.getName());
        if (configPrj != null) {
            outEvents.add(new WorkspaceServiceEventImpl("osint/workspace/projectMoved", configPrj.getId(), configPrj.getName()));
            if (configPrj.getId().equals((Object)this.getActiveConfigProjectId())) {
                outEvents.add(new WorkspaceServiceEventImpl("osint/workspace/activeConfigProjectChanged", configPrj.getId(), configPrj.getName()));
            }
        }
    }

    public void start() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                WorkspaceServiceImpl.this.performStart();
            }
        });
    }

    public void performStart() {
        this.getFileIndex().refreshIndex();
        this.getResourceMonitorService().addListener(this.resourceMonitorListener);
        this.startProjects();
        try {
            WorkspaceSaveParticipant saveParticipant = new WorkspaceSaveParticipant(this);
            ResourcesPlugin.getWorkspace().addSaveParticipant("it.jrc.osint.workspace", (ISaveParticipant)saveParticipant);
        }
        catch (Throwable t) {
            log.error("Failed to attache save participant", t);
        }
        this.fireWorkspaceEvent(new WorkspaceServiceEventImpl("osint/workspace/serviceStarted"));
    }

    public void stop() {
        this.getResourceMonitorService().removeListener(this.resourceMonitorListener);
        this.stopProjects();
    }

    private void startProjects() {
        IProject[] workspaceProjects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspaceProjects = workspace.getRoot().getProjects();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                ResourceId projectId;
                if (project.isAccessible() && project.hasNature("it.jrc.osint.workspace.caseProjectNature")) {
                    projectId = this.fileIndex.getId(project.getFullPath());
                    CaseProjectImpl caseProject = new CaseProjectImpl(projectId, this, project.getName());
                    caseProject.start();
                    this.caseProjects.put(caseProject.getId(), caseProject);
                } else if (project.isAccessible() && project.hasNature("it.jrc.osint.workspace.configProjectNature")) {
                    projectId = this.fileIndex.getId(project.getFullPath());
                    ConfigProjectImpl configProject = new ConfigProjectImpl(projectId, this, project.getName());
                    this.configProjects.put(configProject.getId(), configProject);
                }
            }
            catch (CoreException e) {
                log.error("Could not initialize CaseProject", (Throwable)e);
            }
            ++n2;
        }
    }

    private void stopProjects() {
        for (CaseProjectImpl project : this.caseProjects.values()) {
            project.stop();
        }
    }

    @Override
    public BaseProject getProjectByName(String name) {
        BaseProject bp = this.getCaseProjectByName(name);
        if (bp == null) {
            bp = this.getConfigProject(name);
        }
        return bp;
    }

    @Override
    public CaseProject getCaseProjectByName(String name) {
        for (CaseProject caseProject : this.caseProjects.values()) {
            if (!caseProject.getName().equals(name)) continue;
            return caseProject;
        }
        return null;
    }

    public ConfigProject getConfigProject(String name) {
        for (ConfigProject configProject : this.configProjects.values()) {
            if (!configProject.getName().equals(name)) continue;
            return configProject;
        }
        return null;
    }

    private ConfigProject getConfigProjectByProjectId(ResourceId projectId) {
        return this.configProjects.get(projectId);
    }

    @Override
    public boolean hasCaseProject(ResourceId projectId) {
        return this.caseProjects.containsKey(projectId);
    }

    @Override
    public boolean exists(IPath aPath) {
        return WorkspaceUtil.resourceExists((IContainer)ResourcesPlugin.getWorkspace().getRoot(), aPath);
    }

    @Override
    public IFile getFile(ResourceId docId) {
        IPath path = this.getFileIndex().getPath(docId);
        if (path == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    @Override
    public String readFile(ResourceId id) {
        IFile aFile = this.getFile(id);
        if (aFile != null) {
            InputStream in = null;
            try {
                String result;
                String charSet = aFile.getCharset();
                String string = result = FileUtil.readFile((InputStream)aFile.getContents(), (String)charSet);
                return string;
            }
            catch (Throwable t) {
                log.error("Failed to read contents of file", t);
            }
            finally {
                FileUtil.close(in);
            }
        }
        return null;
    }

    @Override
    public IResource getResource(ResourceId id) {
        IPath path = this.getFileIndex().getPath(id);
        if (path == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
    }

    @Override
    public boolean containsDocument(ResourceId resourceId) {
        for (CaseProject cp : this.getCaseProjects()) {
            if (!cp.containsDocument(resourceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDocument(IPath filePath) {
        for (CaseProject cp : this.getCaseProjects()) {
            if (!cp.containsDocument(filePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getContentTypeId(IPath filePath) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!wsRoot.exists(filePath)) {
            return null;
        }
        IFile aFile = wsRoot.getFile(filePath);
        return ContentTypeUtil.getContentTypeId((IFile)aFile, (boolean)false, (String)"unknown-content-type");
    }

    @Override
    public void enableAutomaticExtraction(boolean enable) {
        this.automaticExtractionEnabled = enable;
    }

    @Override
    public boolean isAutomaticExtractionEnabled() {
        return this.automaticExtractionEnabled;
    }

    private ResourceMonitorService getResourceMonitorService() {
        return (ResourceMonitorService)WorkspacePlugin.getResourceMonitorService();
    }

    void fireWorkspaceEvent(WorkspaceServiceEvent event) {
        if (event == null) {
            return;
        }
        try {
            this.eventBroker.postEvent((SystemEvent)event);
        }
        catch (Throwable t) {
            log.error("Faield to post event", t);
        }
    }

    @Override
    public BaseProject getProjectByProjectId(ResourceId projectId) {
        if (this.caseProjects.containsKey(projectId)) {
            return this.caseProjects.get(projectId);
        }
        if (this.configProjects.containsKey(projectId)) {
            return this.configProjects.get(projectId);
        }
        return null;
    }

    @Override
    public CaseProject getCaseProjectByProjectId(ResourceId projectId) {
        return this.caseProjects.get(projectId);
    }

    @Override
    public CaseProject getCaseProjectByDocumentId(ResourceId docId) {
        for (CaseProject caseProject : this.caseProjects.values()) {
            if (!caseProject.contains(docId)) continue;
            return caseProject;
        }
        return null;
    }

    @Override
    public BaseProject getProjectByResourceId(ResourceId docId) {
        CaseProject prj = this.getCaseProjectByDocumentId(docId);
        if (prj == null) {
            for (ConfigProject configProject : this.configProjects.values()) {
                if (!configProject.contains(docId)) continue;
                return configProject;
            }
            return null;
        }
        return prj;
    }

    FileIndex getFileIndex() {
        if (this.fileIndex == null) {
            this.fileIndex = new FileIndex(ResourcesPlugin.getWorkspace().getRoot());
            boolean loadSuccess = this.fileIndex.load(this.getIndexFile());
            if (!loadSuccess) {
                log.warn("Failed to load file-index.xml, loading backup instead");
                this.fileIndex.load(this.getIndexFileBackup());
            }
        }
        return this.fileIndex;
    }

    void saveFileIndex() {
        this.backupFileIndex();
        if (this.fileIndex != null) {
            this.fileIndex.save(this.getIndexFile());
        }
    }

    private void backupFileIndex() {
        try {
            File fileIndex = this.getIndexFile();
            if (fileIndex.exists()) {
                File fileIndexBackup = this.getIndexFileBackup();
                FileUtils.copyFile((File)fileIndex, (File)fileIndexBackup);
            }
        }
        catch (Throwable t) {
            log.error("Failed to create backup of file-index.xml", t);
        }
    }

    private File getIndexFile() {
        IPath stateLocation = WorkspacePlugin.getPlugin().getStateLocation();
        IPath indexFilePath = stateLocation.append("file-index.xml");
        return indexFilePath.toFile();
    }

    private File getIndexFileBackup() {
        File fileIndex = this.getIndexFile();
        File fileIndexBackup = new File(String.valueOf(fileIndex.getAbsolutePath()) + ".backup");
        return fileIndexBackup;
    }

    @Override
    public ResourceId getId(IPath filePath) {
        if (filePath == null) {
            return ResourceId.NULL_ID;
        }
        try {
            return this.getFileIndex().getId(filePath);
        }
        catch (Throwable t) {
            log.error("Failed to get resource id for path " + filePath, t);
            return ResourceId.NULL_ID;
        }
    }

    @Override
    public IPath getPath(ResourceId resourceId) {
        return this.getFileIndex().getPath(resourceId);
    }

    @Override
    public IPath getPath(ResourceId id, boolean includeDeletedResources) {
        return this.getFileIndex().getPath(id, true);
    }

    @Override
    public List<WorkspaceService.IndexEntry> getIndexEntries() {
        return this.getFileIndex().getIndexEntries();
    }

    @Override
    public void refreshIndex() {
        this.getFileIndex().refreshIndex();
    }

    @Override
    public void refreshUI() {
        WorkspaceServiceEventImpl refreshEvent = new WorkspaceServiceEventImpl("osint/workspace/refreshUI");
        this.fireWorkspaceEvent(refreshEvent);
    }

    public String getLabel(ResourceId id) {
        DocumentMetaItem dmi;
        CaseProject cp;
        if (this.getFileIndex().contains(id) && (cp = this.getCaseProjectByDocumentId(id)) != null && (dmi = cp.getMetaItem(id)) != null) {
            return dmi.getTitle();
        }
        return null;
    }

    @Override
    public void invalidateExtractionData() {
        for (CaseProject cp : this.getCaseProjects()) {
            cp.clean();
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.workspaceSchedulingRule;
    }

    private class PreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String key = event.getKey();
            if ("activeConfigProject".equals(key)) {
                ConfigProject cp = WorkspaceServiceImpl.this.getActiveConfigProject();
                if (cp != null) {
                    WorkspaceServiceImpl.this.fireWorkspaceEvent(new WorkspaceServiceEventImpl("osint/workspace/activeConfigProjectChanged", cp.getId(), cp.getName()));
                } else {
                    WorkspaceServiceImpl.this.fireWorkspaceEvent(new WorkspaceServiceEventImpl("osint/workspace/activeConfigProjectChanged", ResourceId.NULL_ID, ""));
                }
            }
        }
    }

    private class ResourceMonitorListenerImpl
    implements ResourceMonitorListener {
        private ResourceMonitorListenerImpl() {
        }

        @Override
        public void resourcesChanged(List<ResourceEvent> events) {
            WorkspaceServiceImpl.this.getFileIndex().update(events);
            LinkedList<WorkspaceServiceEvent> wsEvents = new LinkedList<WorkspaceServiceEvent>();
            try {
                for (ResourceEvent resourceEvent : events) {
                    if (!(resourceEvent.getResource() instanceof IProject)) continue;
                    if (resourceEvent.getType().equals((Object)ResourceEvent.EventType.CREATED)) {
                        WorkspaceServiceImpl.this.projectAdded((IProject)resourceEvent.getResource(), wsEvents);
                        continue;
                    }
                    if (resourceEvent.getType().equals((Object)ResourceEvent.EventType.DELETED)) {
                        List<ResourceEvent> filteredEvents = this.filter(events);
                        BaseProject project = WorkspaceServiceImpl.this.getProjectByName(((IProject)resourceEvent.getResource()).getName());
                        if (project != null) {
                            project.update(filteredEvents, true, wsEvents);
                        }
                        WorkspaceServiceImpl.this.projectDeleted((IProject)resourceEvent.getResource(), wsEvents);
                        continue;
                    }
                    if (!resourceEvent.getType().equals((Object)ResourceEvent.EventType.MOVED)) continue;
                    WorkspaceServiceImpl.this.projectRenamed((IProject)resourceEvent.getResource(), resourceEvent.getMovedFromPath(), wsEvents);
                }
            }
            catch (Throwable throwable) {
                log.error("Error occurred during processing of project related events", throwable);
            }
            try {
                List<ResourceEvent> list = this.filter(events);
                if (!list.isEmpty()) {
                    List<CaseProject> caseProjects = WorkspaceServiceImpl.this.getCaseProjects();
                    for (CaseProject cPrj : caseProjects) {
                        cPrj.update(list, false, wsEvents);
                    }
                    List<ConfigProject> configProjects = WorkspaceServiceImpl.this.getConfigProjects();
                    for (ConfigProject configPrj : configProjects) {
                        configPrj.update(list, false, wsEvents);
                    }
                }
            }
            catch (Throwable throwable) {
                log.error("Error occurred during processing events for each project", throwable);
            }
            for (WorkspaceServiceEvent workspaceServiceEvent : wsEvents) {
                try {
                    WorkspaceServiceImpl.this.fireWorkspaceEvent(workspaceServiceEvent);
                }
                catch (Throwable t) {
                    log.error("Error occurred during fireing WorkspaceServiceEvents", t);
                }
            }
        }

        private List<ResourceEvent> filter(List<ResourceEvent> events) {
            LinkedList<ResourceEvent> filteredEvents = new LinkedList<ResourceEvent>();
            for (ResourceEvent event : events) {
                if (!(event.getResource() instanceof IFile) || !WorkspaceServiceImpl.this.getFileIndex().isIncludedInIndex(event.getResourcePath())) continue;
                filteredEvents.add(event);
            }
            return filteredEvents;
        }
    }
}

