/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportGeonames {
    private static String FILENAME = "WebContent/geonames.txt";
    private static boolean GZIP_IT = true;
    private static final String TABLE = "all_names";
    private static final boolean ADJECTIVES = true;
    String url = "jdbc:postgresql://139.191.254.83/geonmaesupdate?user=postgres&password=postgres";
    String ExcUrl = "jdbc:postgresql://139.191.254.83/GAUL?user=postgres&password=postgres";
    String adjUrl = "jdbc:postgresql://139.191.254.83/geonmaesupdate?user=postgres&password=postgres";

    public static void main(String[] args) {
        if (args != null && args.length == 1) {
            if ("true".equals(args[0])) {
                GZIP_IT = true;
            } else if ("false".equals(args[0])) {
                GZIP_IT = false;
            } else {
                System.out.println("Use true or false as the only parameter!");
            }
        }
        try {
            new ExportGeonames().export();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws ClassNotFoundException, SQLException, IOException {
        Connection conn = this.getConnection();
        try {
            String[] wrongLang = new String[]{"'PL'", "'ber'", "'berZ'", "'bu'", "'cai'", "'caxu'", "'cayug'", "'cpp'", "'dari'", "'faac'", "'fre'", "'ge'", "'ger'", "'gre'", "'haks'", "'hant'", "'izor'", "'karj'", "'lit'", "'livo'", "'mans'", "'nana'", "'nav'", "'nene'", "'nivh'", "'qq_ca'", "'qq_ch'", "'qq_kh'", "'qq_ma'", "'qq_om'", "'qq_wy'", "'rum'", "'rup'", "'sp'", "'syl'", "'tals'", "'veps'", "'wen'", "'wenD'", "'wenH'", "'LOC'", "'unknown'", "'szl'"};
            String sql = "SELECT gid, \"name\", lat, lon, lang,  cls   FROM all_names WHERE (\tcls <= 3 OR ( cls > 3 AND length(\"name\") > 3 ) OR cls IS NULL) AND lang != 'post'  AND gid != 0  AND gid IS NOT NULL  AND name not similar to '[0-9]*'  AND length(lang) < 5  AND lang NOT IN " + Arrays.asList(wrongLang).toString().replaceAll("\\[", "(").replaceAll("\\]", ")") + " ORDER BY gid ";
            System.out.println("The url is " + this.url);
            System.out.println(sql);
            PreparedStatement stat = conn.prepareStatement(sql);
            ResultSet resultSet = stat.executeQuery();
            Writer wri = this.getWriter();
            wri.write(this.getHeader());
            for (String[] exc : ExportGeonames.getExceptionsNew(DriverManager.getConnection(this.ExcUrl))) {
                String ret = "0;";
                ret = ret + exc[0] + ";";
                ret = ret + "0;";
                ret = ret + "0;";
                ret = ret + "-1;";
                ret = ret + exc[1];
                wri.write(ret + "\n");
            }
            long count = 0L;
            while (resultSet.next()) {
                wri.write(this.getLine(resultSet) + "\n");
                ++count;
            }
            this.exportAdjectives(wri);
            wri.close();
            System.out.println("Done! " + count);
        }
        finally {
            conn.close();
        }
    }

    private void exportAdjectives(Writer wri) {
        try {
            Connection conn = DriverManager.getConnection(this.adjUrl);
            String sql = "SELECT gid, name, lang, comment  FROM adjectives";
            ResultSet resultSet = conn.createStatement().executeQuery(sql);
            long count = 0L;
            if (resultSet.next()) {
                do {
                    wri.write(this.getLineAdj(resultSet));
                    ++count;
                } while (resultSet.next());
            } else {
                System.err.println("No adjectives!??!");
            }
            System.out.println("Adjectives : " + count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getLineAdj(ResultSet rs) throws SQLException {
        String ret = "-" + rs.getLong("gid") + ";";
        ret = ret + rs.getString("name") + ";";
        ret = ret + "0;";
        ret = ret + "0;";
        ret = ret + "5;";
        ret = ret + rs.getString("lang") + "\n";
        return ret;
    }

    public static ArrayList<String[]> getExceptionsNew(Connection conn) throws SQLException {
        return ExportGeonames.getExceptionsNew(conn, false);
    }

    public static int deleteException(long oid, Connection conn) throws SQLException {
        String sql = "DELETE FROM exceptions WHERE oid=" + oid;
        return conn.createStatement().executeUpdate(sql);
    }

    public static ArrayList<String[]> getExceptionsNew(Connection conn, boolean withOids) throws SQLException {
        String sql = "SELECT *, oid FROM exceptions ORDER BY name";
        PreparedStatement stat = conn.prepareStatement(sql);
        ResultSet query = stat.executeQuery();
        ArrayList<String[]> ret = new ArrayList<String[]>();
        if (query.next()) {
            int excCount = 0;
            do {
                if (withOids) {
                    ret.add(new String[]{query.getString("name"), query.getString("lang"), query.getString("comment"), query.getString("oid")});
                } else {
                    ret.add(new String[]{query.getString("name"), query.getString("lang"), query.getString("comment")});
                }
                ++excCount;
            } while (query.next());
            System.out.println("Exceptions " + excCount);
        } else {
            System.out.println("No exceptions");
        }
        return ret;
    }

    private String numberOrZero(String cls) {
        return cls == null ? "5" : cls;
    }

    private String getLine(ResultSet rs) throws SQLException {
        String ret = "" + rs.getLong("gid") + ";";
        ret = ret + rs.getString("name") + ";";
        ret = ret + rs.getDouble("lat") + ";";
        ret = ret + rs.getDouble("lon") + ";";
        ret = ret + this.numberOrZero(rs.getString("cls")) + ";";
        ret = ret + rs.getString("lang");
        return ret;
    }

    private String getHeader() {
        return "//created on " + new Date() + "\n// the syntax is : id;name;lat;lon;class;lang\n";
    }

    private Writer getWriter() throws IOException {
        OutputStream out = null;
        if (GZIP_IT) {
            System.out.println("Outputfile is : " + FILENAME + ".gz");
            out = new GZIPOutputStream(new FileOutputStream(FILENAME + ".gz"));
        } else {
            System.out.println("Outputfile is : " + FILENAME);
            out = new FileOutputStream(FILENAME);
        }
        return new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        return DriverManager.getConnection(this.url);
    }
}

