/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import it.jrc.geocoder.DisAmbiguate;
import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.test.Function;
import it.jrc.geocoder.test.GeoSteu;
import it.jrc.geoutils.GeoResource;
import it.jrc.geoutils.GeoUtils;
import it.jrc.matcher.MatchResult;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoDisAmbiguate
implements DisAmbiguate {
    public HashMap<Long, GeoResource> idmap;
    public HashMap<String, Long> isomap;
    public HashMap<String, Integer> langmap;
    public int foundCut = 3;
    public int maxThreshold = 10;
    private static Logger logger;
    protected static final int PLACE = 15;
    protected static final int PROVINCE = 7;
    protected static final int REGION = 3;
    protected static final int COUNTRY = 1;
    HashMap<Long, SimpleElement> fullGeo = null;
    private static final boolean DEBUG = true;
    private static final boolean SINGLE_STEPS_DEBUG = true;
    private static final boolean EXPERIMENTAL = true;
    private static final boolean SAN_JOSE_REMOVING = true;
    private static final boolean CBN_SINGLE_STEPS_DEBUG = false;

    public GeoDisAmbiguate(String name, HashMap<Long, GeoResource> ids, HashMap<String, Long> imap, HashMap<String, Integer> lmap, int fcut, int maxt) {
        this.idmap = ids;
        this.isomap = imap;
        this.langmap = lmap;
        this.foundCut = fcut;
        this.maxThreshold = maxt;
        if (logger == null) {
            logger = Logger.getLogger((String)this.getClass().getName());
        }
    }

    @Override
    public Vector<SimpleElement> disAmbiguateResult(MatchResult res, RSSItem item, String text) {
        return new Vector<SimpleElement>(this.disAmbiguateResult(res, item, text, 2));
    }

    public Vector<SimpleElement> disAmbiguateResult(MatchResult res, RSSItem item, String text, int disambigugateLevel) {
        GeocodeMatchResult result = (GeocodeMatchResult)res;
        this.fullGeo = null;
        HashMap<Long, SimpleElement> retElements = new HashMap<Long, SimpleElement>();
        ArrayList<GeoResource> countries = new ArrayList<GeoResource>();
        ArrayList<GeoResource> regions = new ArrayList<GeoResource>();
        ArrayList<GeoResource> provinces = new ArrayList<GeoResource>();
        ArrayList<GeoResource> places = new ArrayList<GeoResource>();
        String lang = item.getLanguage();
        if (lang == null) {
            lang = "en";
        }
        ArrayList<GeoResource> mom = new ArrayList<GeoResource>(result.getAllPlaces());
        Collections.sort(mom, new Comparator<GeoResource>(){

            @Override
            public int compare(GeoResource o1, GeoResource o2) {
                return o1.getCleanName().compareTo(o2.getCleanName());
            }
        });
        logger.debug((Object)("sortFilterResultTypes " + GeoSteu.myClosure(mom, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + ":" + GeocodeMatcher.getCompleteInfo(par.gid, 15, GeoDisAmbiguate.this.idmap) + "(" + par.gid + "," + par.cls + ")";
            }
        })));
        this.sortFilterResultTypes(result.getAllPlaces(), countries, regions, provinces, places, item.getElements("emm:entity"), lang);
        long cid = 0L;
        if (item.getSourceCountry() != null && this.isomap.containsKey(item.getSourceCountry())) {
            cid = this.isomap.get(item.getSourceCountry());
        }
        if (countries.size() != 0 && cid != 0L && !countries.contains(cid)) {
            cid = -1L;
        }
        places = this.removeSmallPlaces(places, provinces, regions, countries, cid);
        logger.debug((Object)("Remaining         after removesmallplaces : " + GeoSteu.myClosure(places, "getCleanName")));
        logger.debug((Object)GeoSteu.myClosure(places, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + ":" + GeocodeMatcher.getCompleteInfo(par.gid, 15, GeoDisAmbiguate.this.idmap) + "(" + par.gid + ")";
            }
        }));
        this.processWeights(places, provinces, regions, countries, cid);
        logger.debug((Object)"processCapitals");
        places = this.processCapitals(places);
        logger.debug((Object)"getHighScored ");
        Collection<GeoResource> found = this.getHighScored(retElements, countries, regions, provinces, places);
        logger.debug((Object)("getHighScored RESULT " + GeoSteu.myClosure(found, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return "(" + par.cls + ") " + par.getCleanName() + " (" + GeocodeMatcher.getCountryName(par.gid) + ")";
            }
        })));
        if (disambigugateLevel > 0) {
            this.processForLevel(disambigugateLevel, found, retElements, countries, regions, provinces, places);
        }
        Iterator<Long> iterator = this.fullGeo.keySet().iterator();
        while (iterator.hasNext()) {
            Long gid = iterator.next();
            for (Long retKey : retElements.keySet()) {
                if (retKey.longValue() == gid.longValue()) {
                    iterator.remove();
                    continue;
                }
                if (!this.samePos(this.fullGeo.get(gid), retElements.get(retKey)) || gid != 20215L) continue;
                iterator.remove();
            }
        }
        HashSet<Long> toBeRemoved = new HashSet<Long>();
        for (long firstGid : this.fullGeo.keySet()) {
            SimpleElement first = this.fullGeo.get(firstGid);
            for (Long otherOne : this.fullGeo.keySet()) {
                SimpleElement second = this.fullGeo.get(otherOne);
                if (!this.samePos(first, second) || !this.isBigger(second, first)) continue;
                toBeRemoved.add(firstGid);
            }
        }
        for (Long l : toBeRemoved) {
            this.fullGeo.remove(l);
        }
        return new Vector<SimpleElement>(retElements.values());
    }

    private boolean isBigger(SimpleElement second, SimpleElement first) {
        int firstCls = Integer.parseInt(first.getAttribute((String)"class").value);
        int secondCls = Integer.parseInt(second.getAttribute((String)"class").value);
        return secondCls > firstCls;
    }

    private boolean samePos(SimpleElement elem1, SimpleElement elem2) {
        if (elem1 != null && elem2 != null && elem1.getAttribute("wordpos") != null && elem2.getAttribute("wordpos") != null) {
            return elem1.getAttribute((String)"wordpos").value.equals(elem2.getAttribute((String)"wordpos").value);
        }
        if (elem1 != null && elem2 != null && elem1.getAttribute("pos") != null && elem2.getAttribute("pos") != null) {
            return elem1.getAttribute((String)"pos").value.equals(elem2.getAttribute((String)"pos").value);
        }
        return false;
    }

    public Collection<GeoResource> getHighScored(HashMap<Long, SimpleElement> retElements, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places) {
        int maxClass = this.maxClass(places);
        int placemax = this.maxValue(places, 0);
        int provincemax = this.maxValue(provinces, 0);
        int regionmax = this.maxValue(regions, 0);
        int countrymax = this.maxValue(countries, 0);
        HashMap<Long, GeoResource> found = new HashMap<Long, GeoResource>();
        ArrayList<GeoResource> topscore = new ArrayList<GeoResource>();
        logger.debug((Object)("  placemax(" + placemax + ")" + GeoSteu.myClosure(places, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + ":" + GeocodeMatcher.getCompleteInfo(par.gid, 15, GeoDisAmbiguate.this.idmap);
            }
        })));
        logger.debug((Object)("  provincemax(" + provincemax + ")"));
        logger.debug((Object)("  regionmax(" + regionmax + ")" + GeoSteu.myClosure(regions, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + " (" + GeocodeMatcher.getCountryName(par.gid) + ")";
            }
        })));
        logger.debug((Object)("  countrymax(" + countrymax + ")"));
        if (placemax > 0) {
            logger.debug((Object)("  CHECKING " + placemax));
            if (placemax > 0) {
                for (ArrayList arrayList : this.divideByMatch(places)) {
                    GeoResource biggest = this.getTheBiggest(arrayList);
                    logger.debug((Object)("  ..adding MANY RES " + biggest.getCleanName() + " " + biggest.gid + " as topscores (" + biggest.count + "=" + placemax + ")"));
                    topscore.add(biggest);
                }
            } else {
                for (GeoResource geoResource : places) {
                    logger.debug((Object)("   " + geoResource.getCleanName() + " " + geoResource.count));
                    if (!((double)geoResource.count > (double)placemax * 0.75)) continue;
                    logger.debug((Object)("  ..adding " + geoResource.getCleanName() + " " + geoResource.gid + " as topscores (" + geoResource.count + "=" + placemax + ")" + ((double)geoResource.count > (double)placemax * 0.75)));
                    topscore.add(geoResource);
                }
            }
        }
        if (topscore.size() > 0 && !this.tooSmallToBeConsidered(maxClass, countries, regions, provinces, places)) {
            for (GeoResource geoResource : topscore) {
                logger.debug((Object)"  ..looking in topscores");
                if (!geoResource.isCaps()) {
                    retElements.put(geoResource.gid, this.createElement(geoResource, 15));
                    found.put(geoResource.gid, geoResource);
                    logger.debug((Object)"  ..not caps... so adding it");
                    continue;
                }
                logger.debug((Object)"  ..is caps");
                GeoResource gnw = this.checkForNewsWire(places, geoResource);
                if (gnw == null) continue;
                if (gnw.gid != geoResource.gid) {
                    logger.debug((Object)("  .... count " + gnw.count));
                    gnw.count += geoResource.count;
                }
                logger.debug((Object)("  ....is newswire adding it " + gnw));
                retElements.put(gnw.gid, this.createElement(gnw, 15));
                found.put(gnw.gid, gnw);
            }
        } else if (provincemax > 0 && provincemax >= regionmax && provincemax >= countrymax) {
            for (GeoResource geoResource : provinces) {
                if (geoResource.count != provincemax) continue;
                logger.debug((Object)("  ..using provincemax " + geoResource.getCleanName() + " " + geoResource.count));
                retElements.put(geoResource.gid, this.createElement(geoResource, 7));
                found.put(geoResource.gid, geoResource);
            }
        } else if (regionmax >= countrymax) {
            for (GeoResource geoResource : regions) {
                logger.debug((Object)("Regione " + geoResource.count + "  " + GeocodeMatcher.getCountryName(geoResource.gid) + " - " + regionmax));
                if (geoResource.count != regionmax) continue;
                logger.debug((Object)("  ..using regionmax " + geoResource.getCleanName() + " " + geoResource.gid + " " + GeocodeMatcher.getCountryName(geoResource.gid)));
                retElements.put(geoResource.gid, this.createElement(geoResource, 3));
                found.put(geoResource.gid, geoResource);
            }
        } else if (countrymax > 0) {
            for (GeoResource geoResource : countries) {
                logger.debug((Object)("  ..using countrymax " + geoResource.getCleanName() + " " + geoResource.count));
                if (geoResource.count != countrymax) continue;
                retElements.put(geoResource.gid, this.createElement(geoResource, 1));
                found.put(geoResource.gid, geoResource);
            }
            for (GeoResource geoResource : places) {
                if (geoResource.cls != 1 || geoResource.count < 2) continue;
                logger.debug((Object)("  ..adding low score capitals " + geoResource.getCleanName()));
                retElements.put(geoResource.gid, this.createElement(geoResource, 15));
                found.put(geoResource.gid, geoResource);
            }
        }
        if (this.fullGeo == null) {
            this.fullGeo = new HashMap();
        }
        this.addToFullGeo(places);
        this.addToFullGeo(topscore);
        this.addToFullGeo(provinces);
        this.addToFullGeo(regions);
        this.addToFullGeo(countries);
        logger.debug((Object)("   getHighScored results: " + found));
        return found.values();
    }

    private Collection<ArrayList<GeoResource>> divideByMatch(ArrayList<GeoResource> places) {
        HashMap<String, ArrayList<GeoResource>> map = new HashMap<String, ArrayList<GeoResource>>();
        for (GeoResource p : places) {
            ArrayList<GeoResource> curr = null;
            curr = (ArrayList<GeoResource>)map.get(p.match);
            if (curr == null) {
                curr = new ArrayList<GeoResource>(Arrays.asList(p));
                map.put(p.match, curr);
                continue;
            }
            curr.add(p);
        }
        return map.values();
    }

    private void addToFullGeo(GeoResource gr) {
        SimpleElement newElem = gr.asSimpleElement(new SimpleElement("emm:fullgeo"));
        newElem.setValue(gr.match);
        newElem.setAttribute("iso", this.getIsoCode(GeoUtils.getCountryId((long)gr.gid)));
        newElem.setAttribute("name", this.createFullPath(gr));
        newElem.setAttribute("score", "" + gr.count);
        if (this.fullGeo == null) {
            this.fullGeo = new HashMap();
        }
        this.fullGeo.put(gr.gid, newElem);
    }

    private void addToFullGeo(Collection<GeoResource> places) {
        for (GeoResource gr : places) {
            if (this.fullGeo.get(gr.gid) != null) continue;
            this.addToFullGeo(gr);
        }
    }

    protected boolean tooSmallToBeConsidered(int maxClass, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places) {
        logger.debug((Object)("  tooSmallToBeConsidered: maxclass(" + maxClass + ")"));
        if (maxClass >= 4) {
            logger.debug((Object)"      could be too small...");
            for (GeoResource place : places) {
                if (this.regionContains(regions, place) || this.provinceContains(provinces, place)) {
                    logger.debug((Object)"         Something contains it");
                    return false;
                }
                if (!this.contains(countries, place) && !this.contains(provinces, place) && !this.contains(regions, place)) continue;
                logger.debug((Object)"         Same name with something bigger contains it");
                return true;
            }
        }
        return false;
    }

    private boolean provinceContains(ArrayList<GeoResource> provinces, GeoResource place) {
        for (GeoResource province : provinces) {
            if (!GeoUtils.inProvince((long)place.gid, (long)province.gid)) continue;
            return true;
        }
        return false;
    }

    private boolean regionContains(ArrayList<GeoResource> regions, GeoResource place) {
        for (GeoResource region : regions) {
            if (!GeoUtils.inRegion((long)place.gid, (long)region.gid)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(ArrayList<GeoResource> regions, GeoResource place) {
        for (GeoResource region : regions) {
            if (!region.getCleanName().equals(place.getCleanName()) && !region.match.equals(place.match)) continue;
            return true;
        }
        return false;
    }

    public Vector<GeoResource> oldProcessForLevel0(Vector<SimpleElement> retElements, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places, int dislevel) {
        Vector<GeoResource> found;
        block11: {
            int countrymax;
            block13: {
                int regionmax;
                block12: {
                    int provincemax;
                    block10: {
                        int filter = dislevel < 0 ? 0 : 9;
                        int placemax = this.maxValue(places, filter);
                        provincemax = this.maxValue(provinces, 0);
                        regionmax = this.maxValue(regions, 9);
                        countrymax = this.maxValue(countries);
                        found = new Vector<GeoResource>(5);
                        boolean placewon = placemax >= provincemax && placemax >= regionmax && placemax >= countrymax;
                        ArrayList<GeoResource> topscore = new ArrayList<GeoResource>();
                        if (placemax > 0) {
                            for (GeoResource gr : places) {
                                if ((gr.count != placemax || !placewon) && (gr.count != placemax || gr.countryFound <= 0 && gr.regionFound <= 0 && gr.provinceFound <= 0)) continue;
                                topscore.add(gr);
                            }
                        }
                        if (topscore.size() <= 1 || this.sameName(topscore)) break block10;
                        for (GeoResource gr : topscore) {
                            GeoResource gnw;
                            if (!gr.isCaps()) {
                                retElements.add(this.createElement(gr, 15));
                                found.add(gr);
                                continue;
                            }
                            if (!gr.isCaps() || (gnw = this.checkForNewsWire(places, gr)) == null) continue;
                            if (gnw.gid != gr.gid) {
                                gnw.count += gr.count;
                            }
                            retElements.add(this.createElement(gnw, 15));
                            found.add(gnw);
                        }
                        break block11;
                    }
                    if (provincemax <= 0 || provincemax < regionmax || provincemax < countrymax) break block12;
                    for (GeoResource gr : provinces) {
                        if (gr.count != provincemax) continue;
                        retElements.add(this.createElement(gr, 7));
                        found.add(gr);
                    }
                    break block11;
                }
                if (regionmax < countrymax) break block13;
                for (GeoResource gr : regions) {
                    if (gr.count != regionmax) continue;
                    retElements.add(this.createElement(gr, 3));
                    found.add(gr);
                }
                break block11;
            }
            if (countrymax <= 0) break block11;
            for (GeoResource gr : countries) {
                if (gr.count != countrymax) continue;
                retElements.add(this.createElement(gr, 1));
                found.add(gr);
            }
            for (GeoResource gr : places) {
                if (gr.cls == 1 && gr.count >= 2) {
                    retElements.add(this.createElement(gr, 15));
                }
                found.add(gr);
            }
        }
        return found;
    }

    public boolean sameName(ArrayList<GeoResource> list) {
        if (list.size() == 0) {
            return true;
        }
        if (list.size() == 1) {
            return false;
        }
        String firstname = list.get((int)0).match;
        boolean same = true;
        for (int loop = 1; loop < list.size(); ++loop) {
            if (!firstname.equals(list.get((int)loop).match)) continue;
            same = false;
        }
        return same;
    }

    public void processForLevel(int level, Collection<GeoResource> found, HashMap<Long, SimpleElement> retElements, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places) {
        long testid;
        logger.debug((Object)("processForLevel (" + level + ")"));
        int pclass = level - 3;
        ArrayList<Long> processed = new ArrayList<Long>(100);
        for (GeoResource gr : found) {
            testid = GeoUtils.getCountryId((long)gr.gid);
            if (!processed.contains(testid)) {
                processed.add(testid);
            }
            if (!processed.contains(testid = GeoUtils.getRegionId((long)gr.gid))) {
                processed.add(testid);
            }
            if (!processed.contains(testid = GeoUtils.getProvinceId((long)gr.gid))) {
                processed.add(testid);
            }
            processed.add(gr.gid);
        }
        for (GeoResource gr : places) {
            if (found.contains(gr) || (places.size() != 1 || gr.cls != 2 && gr.cls != 3) && (gr.cls > pclass || gr.provinceFound <= 0 && gr.regionFound <= 0 || gr.countryFound <= 0) && gr.cls != 1) continue;
            logger.debug((Object)("   1:places " + gr.getCleanName() + "  (pclass=" + pclass + ")" + (gr.cls <= pclass) + "  " + (gr.provinceFound > 0 || gr.regionFound > 0) + "  " + (gr.countryFound > 0)));
            retElements.put(gr.gid, this.createElement(gr, 15));
            testid = GeoUtils.getCountryId((long)gr.gid);
            if (!processed.contains(testid)) {
                processed.add(testid);
            }
            if (!processed.contains(testid = GeoUtils.getRegionId((long)gr.gid))) {
                processed.add(testid);
            }
            if (processed.contains(testid = GeoUtils.getProvinceId((long)gr.gid))) continue;
            processed.add(testid);
        }
        logger.debug((Object)("   SAME REGION ? " + places));
        if (places.size() > 1 && this.areInTheSameRegion(places)) {
            GeoResource gr = this.getTheBiggest(places);
            logger.debug((Object)("   1b:places in the SAME REGION " + gr));
            retElements.put(gr.gid, this.createElement(gr, 15));
        }
        if (level >= ProcessRSS.PROVINCES) {
            for (GeoResource gr : provinces) {
                logger.debug((Object)("   2:provinces" + gr.getCleanName() + "  regFound:" + gr.regionFound + " countryFound:" + gr.countryFound));
                if (found.contains(gr) || processed.contains(gr.gid) || gr.regionFound <= 0 || gr.countryFound <= 0) continue;
                retElements.put(gr.gid, this.createElement(gr, 7));
                testid = GeoUtils.getCountryId((long)gr.gid);
                if (!processed.contains(testid)) {
                    processed.add(testid);
                }
                if (processed.contains(testid = GeoUtils.getRegionId((long)gr.gid))) continue;
                processed.add(testid);
            }
        }
        if (level >= ProcessRSS.REGIONS) {
            for (GeoResource gr : regions) {
                logger.debug((Object)("   3:regions " + gr.getCleanName() + "  country found : " + gr.countryFound + "  " + gr.count + " capital found " + this.containsCountryCapital(found, retElements, gr)));
                if (found.contains(gr) || processed.contains(gr.gid) || gr.countryFound <= 0 || this.containsCountryCapital(found, retElements, gr) || gr.count <= 0) continue;
                retElements.put(gr.gid, this.createElement(gr, 3));
                testid = GeoUtils.getCountryId((long)gr.gid);
                if (!processed.contains(testid)) {
                    processed.add(testid);
                }
                if (processed.contains(testid = GeoUtils.getRegionId((long)gr.gid))) continue;
                processed.add(testid);
            }
        }
        if (level >= ProcessRSS.COUNTRIES) {
            for (GeoResource gr : countries) {
                logger.debug((Object)("   3:countries" + gr.getCleanName()));
                if (found.contains(gr) || processed.contains(gr.gid)) continue;
                retElements.put(gr.gid, this.createElement(gr, 1));
            }
        }
        logger.debug((Object)("   RESULTS " + retElements.values().toString().replaceAll(", ", "\n")));
    }

    private boolean containsCountryCapital(Collection<GeoResource> found, HashMap<Long, SimpleElement> retElements, GeoResource gr) {
        for (GeoResource foundgr : found) {
            logger.debug((Object)("\t\tWASH1 problem " + gr + "  " + (foundgr.cls == 1 && GeoUtils.getCountryId((long)foundgr.gid) == GeoUtils.getCountryId((long)gr.gid))));
            if (foundgr.cls != 1 || GeoUtils.getCountryId((long)foundgr.gid) != GeoUtils.getCountryId((long)gr.gid)) continue;
            this.removeFromFullGeo(foundgr);
            return true;
        }
        for (SimpleElement elem : retElements.values()) {
            if (!elem.getValue().equals(gr.match) || !elem.getAttributeValue("pos").contains(gr.cposition + "")) continue;
            logger.debug((Object)("\t\tWASH2 problem " + gr + "  " + elem.getValue() + " " + elem.getAttributeValue("pos") + " = " + gr.cposition));
            this.removeFromFullGeo(elem);
            return true;
        }
        return false;
    }

    private void removeFromFullGeo(SimpleElement elem) {
        Iterator<Long> it = this.fullGeo.keySet().iterator();
        while (it.hasNext()) {
            Long gid = it.next();
            SimpleElement fromFullGeo = this.fullGeo.get(gid);
            if (!fromFullGeo.getValue().equals(elem.getValue()) || elem.getAttribute("id").equals(gid + "")) continue;
            logger.debug((Object)("Removing from FULLGEO2 " + elem));
            it.remove();
        }
    }

    private void removeFromFullGeo(GeoResource gr) {
        Iterator<Long> it = this.fullGeo.keySet().iterator();
        while (it.hasNext()) {
            Long gid = it.next();
            SimpleElement fromFullGeo = this.fullGeo.get(gid);
            if (!fromFullGeo.getValue().equals(gr.match) || gid == gr.gid) continue;
            logger.debug((Object)("Removing from FULLGEO1 " + gr));
            it.remove();
        }
    }

    private GeoResource getTheBiggest(ArrayList<GeoResource> places) {
        GeoResource ret = null;
        int minClass = 100;
        boolean moreThanOen = false;
        for (GeoResource geoResource : places) {
            if (ret == null) {
                ret = geoResource;
                minClass = ret.cls;
                moreThanOen = false;
                continue;
            }
            if (geoResource.cls < ret.cls) {
                ret = geoResource;
                moreThanOen = false;
                continue;
            }
            if (geoResource.cls != ret.cls) continue;
            moreThanOen = true;
        }
        if (moreThanOen) {
            logger.debug((Object)"\t\t\t\tgetTheBiggest:We have more than one with the same class");
            ret = null;
            for (GeoResource geoResource : places) {
                if (ret == null) {
                    ret = geoResource;
                    continue;
                }
                if (geoResource.count <= ret.count) continue;
                ret = geoResource;
            }
        }
        return ret;
    }

    private boolean areInTheSameRegion(ArrayList<GeoResource> places) {
        if (places.size() < 2) {
            return false;
        }
        Iterator<GeoResource> iter = places.iterator();
        HashSet<Long> regions = new HashSet<Long>();
        while (iter.hasNext()) {
            GeoResource other = iter.next();
            if (regions.add(GeoUtils.getRegionId((long)other.gid))) continue;
            logger.debug((Object)("\t\t\t\tRegion is " + this.idmap.get(GeoUtils.getRegionId((long)other.gid))));
            return true;
        }
        return false;
    }

    private boolean OLDareInTheSameRegion(ArrayList<GeoResource> places) {
        if (places.size() < 2) {
            return false;
        }
        Iterator<GeoResource> iter = places.iterator();
        GeoResource first = iter.next();
        long gid = GeoUtils.getRegionId((long)first.gid);
        while (iter.hasNext()) {
            GeoResource other = iter.next();
            logger.debug((Object)(gid + "  " + GeoUtils.getRegionId((long)other.gid)));
            if (gid == GeoUtils.getRegionId((long)other.gid)) continue;
            return false;
        }
        return true;
    }

    private void setMetaRegionWeights(ArrayList<GeoResource> regions, ArrayList<SimpleElement> cats) {
        for (GeoResource gr : regions) {
            String rname = gr.getCleanName();
            for (SimpleElement se : cats) {
                if (rname.indexOf(se.getValue()) < 0) continue;
                gr.count += 10;
            }
        }
    }

    public ArrayList<GeoResource> processCapitals(ArrayList<GeoResource> places) {
        ArrayList<GeoResource> caps = new ArrayList<GeoResource>();
        ArrayList<GeoResource> tokeep = new ArrayList<GeoResource>();
        for (GeoResource gr : places) {
            if (gr.cls != 1) continue;
            caps.add(gr);
            tokeep.add(gr);
        }
        if (caps.size() == 0) {
            logger.debug((Object)"  No capitals found...");
            return places;
        }
        for (GeoResource gr : places) {
            if (gr.cls == 1) continue;
            for (GeoResource cap : caps) {
                if (GeoUtils.sameRegion((long)cap.gid, (long)gr.gid) || gr.cls < 5 && GeoUtils.sameCountry((long)gr.gid, (long)cap.gid)) {
                    tokeep.add(gr);
                    continue;
                }
                if (!gr.name.equals(cap.name) || gr.provinceFound <= 0) continue;
                tokeep.add(gr);
            }
        }
        if (tokeep.size() > 0) {
            return tokeep;
        }
        return places;
    }

    public void sortFilterResultTypes(Collection<GeoResource> ids, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places, ArrayList<SimpleElement> entities, String lang) {
        Integer momVal = this.langmap.get(lang);
        if (momVal == null) {
            momVal = this.langmap.get("en");
        }
        int lval = momVal;
        int en = this.langmap.get("en");
        ArrayList<String> allnames = new ArrayList<String>(ids.size());
        ArrayList<String> bigNames = new ArrayList<String>();
        for (GeoResource gr : ids) {
            allnames.add(gr.match);
            if (Math.abs(gr.cls) >= 3) continue;
            bigNames.add(gr.match);
        }
        String discarded = "";
        for (GeoResource gr : ids) {
            if (gr.cls == -1 && GeoUtils.isCountry((long)gr.gid) && (gr.lang.contains(lval) || gr.hasDefaultLang() || gr.lang.contains(en)) && !this.isSubstring(bigNames, gr.match)) {
                if (!GeoUtils.listContains(entities, (String)gr.match)) {
                    countries.add(gr);
                    continue;
                }
                logger.debug((Object)("Skipping " + gr.match + " enities are : " + entities));
                continue;
            }
            if (gr.cls >= -2 && !this.isSubstring(allnames, gr.match)) {
                if (gr.lang.contains(lval) || gr.hasDefaultLang() || gr.lang.contains(en)) {
                    if (GeoUtils.isCountry((long)gr.gid)) {
                        countries.add(gr);
                        continue;
                    }
                    if (!GeoUtils.listContainsExactly(entities, (String)gr.match) && !this.overlap(entities, gr)) {
                        if (GeoUtils.isRegion((long)gr.gid)) {
                            regions.add(gr);
                            continue;
                        }
                        if (GeoUtils.isProvince((long)gr.gid)) {
                            provinces.add(gr);
                            continue;
                        }
                        places.add(gr);
                        continue;
                    }
                    discarded = discarded + gr.getCleanName() + " ENTITY " + gr.gid + ", ";
                    continue;
                }
                discarded = discarded + gr.getCleanName() + " a " + gr.cls + "  " + gr.gid + "(lang " + lval + "  " + gr.lang + gr.lang.contains(lval) + " " + gr.hasDefaultLang() + " " + gr.lang.contains(en) + "), ";
                continue;
            }
            discarded = discarded + gr.getCleanName() + " b " + gr.cls + "  " + gr.gid + ", ";
        }
        logger.debug((Object)("\tDiscarded places " + discarded));
        logger.debug((Object)("Places  " + places));
    }

    private boolean overlap(ArrayList<SimpleElement> entities, GeoResource gr) {
        if (entities != null) {
            for (SimpleElement ent : entities) {
                if (ent.getAttributeValue("pos") == null || "".equals(ent.getAttributeValue("pos"))) continue;
                String[] poss = ent.getAttributeValue("pos").split(",");
                int lenght = ent.getValue().length();
                for (int i = 0; i < poss.length; ++i) {
                    int startEnt = Integer.parseInt(poss[i]);
                    int eend = startEnt + lenght;
                    for (String grPosStr : gr.cposition.split(",")) {
                        int grPosStart = Integer.parseInt(grPosStr);
                        int grPosEnd = grPosStart + gr.match.length();
                        if ((startEnt > grPosStart || grPosStart > eend) && (grPosStart > startEnt || startEnt > grPosEnd)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    boolean isSubstring(ArrayList<String> names, String test) {
        for (String name : names) {
            int len = test.length();
            int nlen = name.length();
            if (nlen <= len || !name.toLowerCase().contains(test.toLowerCase())) continue;
            logger.debug((Object)("                   " + name + " contains " + test));
            return true;
        }
        return false;
    }

    public void processWeights(ArrayList<GeoResource> places, ArrayList<GeoResource> provinces, ArrayList<GeoResource> regions, ArrayList<GeoResource> countries, long cid) {
        logger.debug((Object)("processWeights  on " + places.size() + " places"));
        for (GeoResource gr : regions) {
            if (cid > 0L && GeoUtils.inCountry((long)gr.gid, (long)cid)) {
                gr.count *= 10;
                gr.countryFound = 1;
                logger.debug((Object)("  processWeights  in CID country " + gr.count));
            }
            for (GeoResource gr2 : countries) {
                if (!GeoUtils.inCountry((long)gr.gid, (long)gr2.gid) || cid > 0L && cid != gr2.gid) continue;
                gr.count *= 10;
                gr.countryFound += gr2.count + 1;
                logger.debug((Object)("  processWeights  in COUNTRY " + gr.count));
            }
        }
        for (GeoResource gr : provinces) {
            Iterator<GeoResource> iter = regions.iterator();
            boolean match = false;
            while (iter.hasNext() && !match) {
                GeoResource gr2 = iter.next();
                if (gr2.name.equalsIgnoreCase(gr.name) || !GeoUtils.inRegion((long)gr.gid, (long)gr2.gid)) continue;
                gr.count *= gr2.count;
                gr.regionFound = gr.count;
                match = true;
            }
            if (match) continue;
            gr.count = 0;
        }
        for (GeoResource gr : places) {
            logger.debug((Object)("  processWeights (scoring): " + gr.getCleanName() + " (" + GeocodeMatcher.getCountryName(gr.gid) + "  " + gr.gid + " -> " + gr.count + ")"));
            int extra = 0;
            if (cid > 0L && GeoUtils.inCountry((long)gr.gid, (long)cid)) {
                if (gr.cls < 3 && gr.cls > 0) {
                    gr.countryFound = 1;
                    logger.debug((Object)("  processWeights  in SOURCE COUNTRY " + (extra += 10)));
                } else {
                    extra += 3;
                    gr.countryFound = 1;
                    logger.debug((Object)("  processWeights  in REGION MENTIONED " + gr.countryFound));
                }
            }
            for (GeoResource gr2 : countries) {
                if (!GeoUtils.inCountry((long)gr.gid, (long)gr2.gid)) continue;
                if (gr.cls < 3 && gr.cls > 0) {
                    extra += 10 * gr2.count;
                    logger.debug((Object)("  processWeights  in CITIES MENTIONED " + gr2.getCleanName() + "  " + gr.getCleanName()));
                    gr.countryFound = 1;
                    continue;
                }
                gr.countryFound = 1;
            }
            for (GeoResource gr2 : regions) {
                logger.debug((Object)("   ..processWeights  in country MENTIONED : " + gr + " same region?? " + gr2 + " " + GeoUtils.inRegion((long)gr.gid, (long)gr2.gid)));
                logger.debug((Object)("   \tsameCountryButNotContainedEachOther: " + this.sameCountryButNotContainedEachOther(gr, gr2, cid)));
                if (!GeoUtils.inRegion((long)gr.gid, (long)gr2.gid) && !this.sameCountryButNotContainedEachOther(gr, gr2, cid)) continue;
                logger.debug((Object)("  ..comparing : " + gr.match + " (" + GeocodeMatcher.getCountryName(gr.gid) + "," + gr.gid + ")" + " = " + gr2.match + " (" + GeocodeMatcher.getCountryName(gr2.gid) + ", " + gr2.gid + ") extra : " + extra));
                if (gr.match.equalsIgnoreCase(gr2.match)) {
                    if (extra > 10 && gr.count > 1) {
                        logger.debug((Object)("  processWeights  in country MENTIONED " + (extra += 10 * gr2.count)));
                    } else {
                        logger.debug((Object)("\t\tRemoving (Washington-Problem) : " + gr2 + "  " + gr2.count));
                        gr2.count = -1;
                    }
                    gr.regionFound = gr2.count;
                    continue;
                }
                gr.regionFound = gr2.count;
                logger.debug((Object)("\t\tAdding Extras : " + (extra += 10 * gr2.count) + "  found region for " + gr));
            }
            for (GeoResource gr2 : provinces) {
                if (!GeoUtils.inProvince((long)gr.gid, (long)gr2.gid) || !GeoUtils.sameRegion((long)gr.gid, (long)gr2.gid)) continue;
                extra += gr2.count;
                gr.provinceFound = gr2.count;
            }
            gr.count += extra;
            logger.debug((Object)("\t\t\t\tCount for " + gr + " -> " + gr.count));
        }
    }

    private boolean sameCountryButNotContainedEachOther(GeoResource gr, GeoResource gr2, long cid) {
        if (GeoUtils.inCountry((long)gr.gid, (long)cid) && GeoUtils.inCountry((long)gr2.gid, (long)cid)) {
            if (GeoUtils.isProvince((long)gr.gid) && !GeoUtils.isProvince((long)gr2.gid) && !GeoUtils.isRegion((long)gr2.gid) && GeoUtils.inProvince((long)gr2.gid, (long)gr.gid) || GeoUtils.isProvince((long)gr2.gid) && !GeoUtils.isProvince((long)gr.gid) && !GeoUtils.isRegion((long)gr.gid) && GeoUtils.inProvince((long)gr.gid, (long)gr2.gid)) {
                return false;
            }
            return (!GeoUtils.isRegion((long)gr.gid) || GeoUtils.isRegion((long)gr2.gid) || !GeoUtils.inRegion((long)gr2.gid, (long)gr.gid)) && (!GeoUtils.isRegion((long)gr2.gid) || GeoUtils.isRegion((long)gr.gid) || !GeoUtils.inRegion((long)gr.gid, (long)gr2.gid));
        }
        return false;
    }

    public int maxClass(ArrayList<GeoResource> tocheck) {
        int ret = 1000;
        for (GeoResource gr : tocheck) {
            ret = Math.min(ret, gr.cls);
        }
        return ret;
    }

    public int maxValue(ArrayList<GeoResource> tocheck, int threshold) {
        int maxvalue = 0;
        for (GeoResource gr : tocheck) {
            if (gr.count <= maxvalue) continue;
            maxvalue = gr.count;
        }
        if (threshold > 0 && maxvalue < threshold) {
            maxvalue = 0;
        }
        logger.debug((Object)("\t\tmaxValue max:" + maxvalue + "  <-- " + GeoSteu.myClosure(tocheck, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + "(" + par.gid + "," + par.count + ")";
            }
        })));
        return maxvalue;
    }

    public int maxValue(ArrayList<GeoResource> tocheck) {
        return this.maxValue(tocheck, -1);
    }

    public String createFullPath(GeoResource res) {
        int type = -1;
        type = GeoUtils.isCountry((long)res.gid) ? 1 : (GeoUtils.isRegion((long)res.gid) ? 3 : (GeoUtils.isProvince((long)res.gid) ? 7 : 15));
        return this.createFullPath(res, type);
    }

    public String createFullPath(GeoResource res, int type) {
        String name;
        GeoResource gr;
        StringBuilder sb = new StringBuilder();
        if ((type & 8) == 8) {
            String name2 = GeocodeMatcher.defPlacename.get(res.gid);
            sb.append(name2 == null ? res.getCleanName() : name2).append(":");
        }
        if ((type & 4) == 4) {
            gr = this.idmap.get(GeoUtils.getProvinceId((long)res.gid));
            name = gr != null ? gr.getCleanName() : "-";
            sb.append(name).append(":");
        }
        if ((type & 2) == 2) {
            gr = this.idmap.get(GeoUtils.getRegionId((long)res.gid));
            name = gr != null ? gr.getCleanName() : "-";
            sb.append(name).append(":");
        }
        if ((type & 1) == 1) {
            gr = this.idmap.get(GeoUtils.getCountryId((long)res.gid));
            name = gr != null ? gr.getCleanName() : "-";
            name = gr != null ? GeocodeMatcher.getCountryName(res.gid) : "-";
            sb.append(name);
        }
        return sb.toString();
    }

    public SimpleElement createElement(GeoResource res, int type) {
        long country = res.gid & 0x1FFL;
        SimpleElement ret = res.asSimpleElement(this.createFullPath(res, type), this.getIsoCode(country));
        ret.addAttribute("score", "" + res.count);
        return ret;
    }

    public String getIsoCode(long country) {
        for (String code : this.isomap.keySet()) {
            if (country != this.isomap.get(code)) continue;
            return code;
        }
        return null;
    }

    public ArrayList<GeoResource> replaceEntities(ArrayList<GeoResource> places, ArrayList<SimpleElement> entities) {
        ArrayList<GeoResource> retval = new ArrayList<GeoResource>(places.size());
        for (GeoResource pid : places) {
            String geoname = pid.getCleanName();
            if (GeoUtils.listContains(entities, (String)geoname)) continue;
            retval.add(pid);
        }
        return retval;
    }

    protected GeoResource checkForNewsWire(ArrayList<GeoResource> places, GeoResource gwire) {
        int distance = 5000;
        GeoResource selected = null;
        if (gwire.match.equals(gwire.match.toUpperCase()) && gwire.wpos < 100) {
            logger.debug((Object)("               checkForNewsWire: is newswire... not adding it! " + gwire));
            return null;
        }
        for (GeoResource gr : places) {
            if (gr.gid == gwire.gid || !GeoUtils.sameCountry((long)gr.gid, (long)gwire.gid) || !GeoUtils.sameProvince((long)gr.gid, (long)gwire.gid)) continue;
            if (!(gr.wpos >= distance || gr.name.equalsIgnoreCase(gwire.name) || selected != null && gr.cls < selected.cls)) {
                selected = gr;
                distance = gr.wpos;
                continue;
            }
            if (selected == null || gr.cls <= selected.cls) continue;
            selected = gr;
            distance = gr.wpos;
        }
        logger.debug((Object)("    checkForNewsWire " + (selected == null ? gwire.getCleanName() : selected.getCleanName()) + " " + (selected == null)));
        return selected == null ? gwire : selected;
    }

    protected ArrayList<GeoResource> processForLanguages(Collection<GeoResource> places, String lang) {
        ArrayList<GeoResource> retval = new ArrayList<GeoResource>(places.size());
        int en2 = this.langmap.get("en");
        int lval = lang == null ? this.langmap.get("en") : this.langmap.get(lang);
        int en = this.langmap.get("en");
        for (GeoResource gr : places) {
            if (!gr.lang.contains(lval) && !gr.hasDefaultLang() && !gr.lang.contains(en)) continue;
            boolean found = false;
            Iterator<GeoResource> iter = retval.iterator();
            while (iter.hasNext() && !found) {
                GeoResource test = iter.next();
                if (test.gid != gr.gid) continue;
                found = true;
            }
            if (found) continue;
            retval.add(gr);
        }
        return retval;
    }

    private ArrayList<GeoResource> removeContains(Collection<GeoResource> found) {
        ArrayList<GeoResource> retval = new ArrayList<GeoResource>(found.size());
        for (GeoResource gr : found) {
            boolean duplicate = false;
            Iterator<GeoResource> iter = found.iterator();
            while (iter.hasNext() && !duplicate) {
                GeoResource test = iter.next();
                if (!test.match.contains(gr.match) || test.match.equals(gr.match) || gr.lang != test.lang && !gr.hasDefaultLang() && !test.hasDefaultLang()) continue;
                duplicate = true;
            }
            if (duplicate) continue;
            retval.add(gr);
        }
        return retval;
    }

    protected ArrayList<GeoResource> removeSmallPlaces(ArrayList<GeoResource> places, ArrayList<GeoResource> provinces, ArrayList<GeoResource> regions, ArrayList<GeoResource> countries, long countryId) {
        logger.debug((Object)("removeSmallPlaces operating on " + places.size() + " places" + GeoSteu.myClosure(places, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + ":" + GeocodeMatcher.getCompleteInfo(par.gid, 15, GeoDisAmbiguate.this.idmap);
            }
        })));
        logger.debug((Object)("  Countries " + GeoSteu.myClosure(countries, "getCleanName")));
        logger.debug((Object)("  Regions " + GeoSteu.myClosure(regions, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + " (" + GeocodeMatcher.getCountryName(par.gid) + " " + par.count + ")";
            }
        })));
        logger.debug((Object)("  Provinces " + GeoSteu.myClosure(provinces, "getCleanName")));
        Iterator<GeoResource> iter = places.iterator();
        while (iter.hasNext()) {
            GeoResource place = iter.next();
            if (!this.contains(countries, place)) continue;
            logger.debug((Object)("  PreRemoving " + place + " I have a country with same name!"));
            iter.remove();
        }
        ArrayList<GeoResource> retval = new ArrayList<GeoResource>(places.size());
        ArrayList<Long> added = new ArrayList<Long>(places.size());
        for (GeoResource place : places) {
            GeoResource gtest;
            boolean processed = false;
            if (!added.contains(place.gid)) {
                added.add(place.gid);
            } else {
                processed = true;
            }
            iter = provinces.iterator();
            boolean found = false;
            if (place.cls < 3 && place.cls > -1) {
                found = true;
                logger.debug((Object)("  Added by CLASS(" + place.getCleanName() + "  " + place.cls + ")"));
            }
            if (!found && place.cls > -1 && place.cls < 4 && GeoUtils.inCountry((long)place.gid, (long)countryId)) {
                found = true;
                logger.debug((Object)("  Added by INCOUNTRY (article country) (" + place.getCleanName() + "," + place.gid + ")"));
            }
            while (iter.hasNext() && !found) {
                gtest = iter.next();
                if (!GeoUtils.inProvince((long)place.gid, (long)gtest.gid) || place.match.equals(gtest.match)) continue;
                found = true;
                logger.debug((Object)("  Added by INPROVINCE(" + place.getCleanName() + "," + place.gid + ")"));
            }
            iter = countries.iterator();
            while (iter.hasNext() && !found && place.cls <= 5) {
                gtest = iter.next();
                if (!GeoUtils.inCountry((long)place.gid, (long)gtest.gid)) continue;
                found = true;
                logger.debug((Object)("  Added by INCOUNTRIES(" + place.getCleanName() + "," + place.gid + "," + place.cls + ")"));
            }
            iter = regions.iterator();
            while (iter.hasNext() && !found && place.cls <= 6) {
                gtest = iter.next();
                if (!GeoUtils.inRegion((long)place.gid, (long)gtest.gid) || place.match.equals(gtest.match)) continue;
                found = true;
                logger.debug((Object)("  Added by INREGIONS(" + place.getCleanName() + "," + place.gid + ")"));
            }
            if (processed || !found) continue;
            retval.add(place);
        }
        if (countries.size() == 0 && regions.size() == 0 && retval.size() == 0) {
            List<GeoResource> insameregions = this.getSmallPlacesInSameRegion(places);
            logger.debug((Object)("    EXPERIMENTAL add SAME-REGION adding " + insameregions));
            retval.addAll(insameregions);
        }
        logger.debug((Object)("removeSmallPlaces remaning " + retval.size() + " places" + GeoSteu.myClosure(retval, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + ":" + GeocodeMatcher.getCompleteInfo(par.gid, 15, GeoDisAmbiguate.this.idmap) + "(" + par.gid + ", " + par.cls + ")";
            }
        })));
        return retval;
    }

    private boolean haveABiggerPlaceInCOuntry(GeoResource place, ArrayList<GeoResource> retval) {
        for (GeoResource alreadyHave : retval) {
            if (GeoUtils.getCountryId((long)place.gid) != GeoUtils.getCountryId((long)alreadyHave.gid) || !place.match.equals(alreadyHave.match) || alreadyHave.cls >= place.cls) continue;
            return true;
        }
        return false;
    }

    private List<GeoResource> getSmallPlacesInSameRegion(ArrayList<GeoResource> places) {
        if (places.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<GeoResource> ret = new ArrayList<GeoResource>();
        HashMap<Long, ArrayList<GeoResource>> regions = new HashMap<Long, ArrayList<GeoResource>>();
        for (GeoResource gr : places) {
            long thisreg = GeoUtils.getRegionId((long)gr.gid);
            ArrayList count = null;
            count = (ArrayList)regions.get(thisreg);
            if (count == null) {
                regions.put(thisreg, new ArrayList<GeoResource>(Arrays.asList(gr)));
                continue;
            }
            count.add(gr);
        }
        for (Long regid : regions.keySet()) {
            ArrayList list = (ArrayList)regions.get(regid);
            if (list.size() <= 1) continue;
            ret.addAll(list);
        }
        return ret;
    }

    private ArrayList<SimpleElement> filterElements(ArrayList<SimpleElement> elems, String title, String description) {
        if (elems == null) {
            return null;
        }
        ArrayList<SimpleElement> retval = new ArrayList<SimpleElement>(elems.size());
        for (SimpleElement elem : elems) {
            String text = elem.getValue();
            if (!title.contains(text) && !description.contains(text)) continue;
            retval.add(elem);
        }
        return retval;
    }

    public static boolean debugEnabled() {
        return true;
    }

    public Collection<SimpleElement> getFullGeo() {
        ArrayList<SimpleElement> ret = new ArrayList<SimpleElement>(this.fullGeo.size());
        for (SimpleElement orig : this.fullGeo.values()) {
            SimpleElement full = new SimpleElement("emm:fullgeo");
            for (SimpleAttribute attr : orig.getAttributes()) {
                full.addAttribute(attr.name, attr.value);
            }
            full.setValue(orig.getValue());
            ret.add(full);
        }
        return ret;
    }
}

