/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import it.jrc.geoutils.GeoResource;
import it.jrc.matcher.MatchResult;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeocodeMatchResult
implements MatchResult {
    Logger logger = Logger.getLogger((String)GeocodeMatchResult.class.getName());
    private static final boolean DEBUG = false;
    private HashMap<Long, GeoResource> placeMap = new HashMap();
    private int nWordCount = 0;
    private boolean verbose = true;
    private ArrayList<GeoResource> exceptions;
    private ArrayList<GeoResource> adjectives;

    public GeocodeMatchResult(boolean verb) {
        this.verbose = verb;
    }

    public GeocodeMatchResult() {
    }

    public void addMatch(char[] data, int index, String word, int wordIndex, int charIndex) {
        int infoIndex = index + 2;
        char patternLen = data[infoIndex];
        String pattern = String.valueOf(data, index - patternLen + 1, patternLen);
        int len = data[++infoIndex];
        ++infoIndex;
        for (int i = 0; i < len; ++i) {
            String toparse = String.valueOf(data, infoIndex, 32);
            GeoResource gr = GeoResource.parseString((String)pattern, (String)word, (int)wordIndex, (int)charIndex, (String)toparse, (boolean)this.verbose);
            if (gr.gid < 0L) {
                if (this.adjectives == null) {
                    this.adjectives = new ArrayList();
                }
                if (!this.notContains(gr, this.adjectives)) continue;
                this.adjectives.add(gr);
                continue;
            }
            if (gr.gid == 0L) {
                this.addToExceptions(gr);
                continue;
            }
            GeoResource place = this.placeMap.get(gr.gid);
            if (place == null) {
                gr.count = 1;
                gr.internalCount = 1;
                this.placeMap.put(gr.gid, gr);
            } else if (Pattern.compile(",?(" + wordIndex + ")+,?").matcher(place.position).find()) {
                place.lang.addAll(gr.lang);
            } else {
                place.lang.addAll(gr.lang);
                ++place.count;
                ++place.internalCount;
                if (place.match.length() == gr.match.length()) {
                    place.addMatch(word, wordIndex, charIndex, this.verbose);
                } else if (place.match.length() <= gr.match.length()) {
                    place.match = gr.match;
                    place.name = gr.name;
                    place.lang.addAll(gr.lang);
                }
            }
            infoIndex += 32;
        }
    }

    private boolean notContains(GeoResource gr, ArrayList<GeoResource> adjectives) {
        for (GeoResource adj : adjectives) {
            if (!adj.match.equals(gr.match) || !adj.lang.contains(gr.lang.iterator().next()) || !adj.position.contains(gr.position)) continue;
            return false;
        }
        return true;
    }

    private void addToExceptions(GeoResource gr) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(gr);
    }

    private void removeExceptions() {
        for (GeoResource exc : this.exceptions) {
            for (Long gid : this.placeMap.keySet()) {
                GeoResource gr = this.placeMap.get(gid);
                if (!gr.match.equals(exc.match) || gr.lang != exc.lang && !exc.lang.contains("Eu") && !exc.lang.contains("PP") || gr.wpos != exc.wpos) continue;
                this.placeMap.remove(gid);
            }
        }
        this.exceptions = null;
    }

    public void setWordCount(int n) {
        this.nWordCount = n;
    }

    public int getWordCount() {
        return this.nWordCount;
    }

    public Set<Long> getIds() {
        if (this.exceptions != null) {
            this.removeExceptions();
        }
        return this.placeMap.keySet();
    }

    public Collection<GeoResource> getAllPlaces() {
        if (this.exceptions != null) {
            this.removeExceptions();
        }
        return this.placeMap.values();
    }

    public ArrayList<Object> getOldPlaces(long id) {
        return new ArrayList<Object>(2);
    }

    public GeoResource getPlace(Long id) {
        if (this.exceptions != null) {
            this.removeExceptions();
        }
        return this.placeMap.get(id);
    }

    public List<SimpleElement> getAdjectives(HashMap<Long, GeoResource> idmap, Integer lang) {
        if (this.adjectives == null) {
            return Collections.emptyList();
        }
        ArrayList<SimpleElement> ret = new ArrayList<SimpleElement>();
        for (GeoResource gr : this.adjectives) {
            if (!gr.hasDefaultLang() && !gr.lang.contains(lang)) continue;
            SimpleElement adj = gr.asSimpleElement(new SimpleElement("emm:fullgeo"));
            adj.setAttribute("id", "" + -gr.gid);
            adj.addAttribute("adjective", "true");
            GeoResource res = idmap.get(new Long(-gr.gid));
            if (res == null) {
                this.logger.warn((Object)("can't find the place the adjective " + gr.gid + " is referring to!!"));
            } else {
                adj.setAttribute("lat", "" + res.lat);
                adj.setAttribute("lon", "" + res.lon);
                adj.setAttribute("class", "" + res.cls);
            }
            ret.add(adj);
        }
        return ret;
    }
}

