/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import it.jrc.dispatcher.Dispatcher;
import it.jrc.emmutils.Utils;
import it.jrc.geocoder.GeoDisAmbiguate;
import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.OsIntGeoDis;
import it.jrc.geocoder.test.Function;
import it.jrc.geocoder.test.GeoSteu;
import it.jrc.geoutils.GeoResource;
import it.jrc.geoutils.GeoUtils;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Scheduler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRSS
extends Thread {
    public static MatchWords matcher;
    protected static Scheduler scheduler;
    protected static Dispatcher dispatcher;
    protected RSSParser rssParser;
    protected Logger logger = null;
    protected String lang = null;
    protected boolean bRunning;
    protected String outPath;
    protected long processed = 0L;
    protected long fails = 0L;
    public static int DEFAULT;
    public static int COUNTRIES;
    public static int REGIONS;
    public static int PROVINCES;
    public static int CAPITALS;
    public static int MAJORCITIES;
    public static int CLASS3;
    public static int CLASS4;
    public static int CLASS5;
    public static int CLASS6;
    protected GeoDisAmbiguate geodis;
    public static boolean FULLGEO;
    private static final boolean DEBUG = true;
    private static final boolean STEUU_DEBUG = true;
    public static boolean USE_ADJECTIVES;

    public ProcessRSS(String name, MatchWords m, Scheduler s, Dispatcher d, GeoDisAmbiguate gdis, String language, String path) {
        super(name);
        this.geodis = gdis;
        this.logger = Logger.getLogger((String)this.getClass().getName());
        matcher = m;
        scheduler = s;
        dispatcher = d;
        this.rssParser = new RSSParser();
        this.bRunning = true;
        this.lang = language;
        this.outPath = path;
    }

    public ProcessRSS(String name, MatchWords m, GeoDisAmbiguate gdis, String language, String path) {
        super(name);
        this.geodis = gdis;
        this.logger = Logger.getLogger((String)name);
        matcher = m;
        this.rssParser = new RSSParser();
        this.lang = language;
        this.outPath = path;
    }

    @Override
    public void run() {
        while (this.bRunning) {
            CachedJob job = (CachedJob)scheduler.next();
            boolean bl = this.bRunning = job != null;
            if (!this.bRunning) continue;
            try {
                long time = System.currentTimeMillis();
                this.logger.info((Object)("Geo on job" + job.getId()));
                RSS rss = this.rssParser.parse(job.getReader());
                String result = this.runForRSSMixed(rss);
                time = System.currentTimeMillis() - time;
                this.logger.info((Object)("Geo result for job " + job.getId() + " " + result + " in " + time / 1000L + " secs"));
                dispatcher.send(rss.getGuid(), rss.toString());
                job.delete();
            }
            catch (Exception e) {
                this.logger.error((Object)("error processing RSS for " + job.getId()), (Throwable)e);
                job.fail();
            }
        }
    }

    public String runForRSSMixed(RSS rss) {
        Vector items = rss.getItems();
        this.logger.info((Object)("items to do =" + items.size()));
        int found = 0;
        int missed = 0;
        for (int i = 0; i < items.size(); ++i) {
            RSSItem item = (RSSItem)items.get(i);
            try {
                GeocodeMatchResult result = new GeocodeMatchResult();
                String tomatch = item.getTitle() + ". " + item.getDescription();
                if (GeocodeMatcher.USE_FULL_TEXT) {
                    if (item.getText() == null) {
                        this.logger.warn((Object)("Problem with " + item.getGuid() + " the TEXT is null!!"));
                    } else {
                        tomatch = item.getTitle() + ". " + item.getText();
                    }
                }
                this.logger.debug((Object)tomatch);
                matcher.match(tomatch, (MatchResult)result);
                if (this.handleItemUpdate(result, item, tomatch)) {
                    ++found;
                    continue;
                }
                ++missed;
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Problem processing ITEM " + item.getGuid() + " ....continuing anyway"), (Throwable)e);
            }
        }
        return "Items coded=" + found + " uncoded=" + missed;
    }

    public void runOnRSS(RSS rss, boolean useText, int disambiguateLevel) {
        Vector items = rss.getItems();
        this.logger.info((Object)("items to do =" + items.size()));
        for (int i = 0; i < items.size(); ++i) {
            RSSItem item = (RSSItem)items.get(i);
            this.runOnRSSItem(item, useText, disambiguateLevel, true);
        }
        ++this.processed;
    }

    public RSSItem runOnRSSItem(RSSItem item, boolean textOnly, int disambiguateLevel) {
        this.runOnRSSOSIntWay(item, false, disambiguateLevel, true, textOnly);
        return item;
    }

    public ArrayList<SimpleElement> runOnRSSOSIntWay(RSSItem item, boolean useText, int disambiguateLevel, boolean alterItem, boolean textOnly) {
        this.logger.debug((Object)("running on (" + disambiguateLevel + " " + useText + ")" + item.getTitle() + " : "));
        GeocodeMatchResult result = new GeocodeMatchResult(true);
        String tomatch = item.getTitle();
        if (useText) {
            tomatch = item.getTitle() + ". " + item.getText();
        }
        if (textOnly) {
            tomatch = item.getText();
        }
        matcher.match(tomatch, (MatchResult)result);
        OsIntGeoDis myDis = new OsIntGeoDis(this.geodis);
        ArrayList<SimpleElement> eresult = myDis.disAmbiguateResultOsInt(result, item, tomatch, disambiguateLevel);
        ArrayList<Object> topScores = new ArrayList(10);
        int max = 0;
        for (SimpleElement simpleElement : eresult) {
            long id = Long.parseLong(simpleElement.getAttributeValue("id"));
            int count = Integer.parseInt(simpleElement.getAttributeValue("count"));
            if (count > max) {
                max = count;
                topScores.clear();
                topScores.add(simpleElement);
                continue;
            }
            if (disambiguateLevel <= 0 && count != max) continue;
            topScores.add(simpleElement);
        }
        topScores = eresult;
        this.logger.debug((Object)("After disAmbiguateResult : \n" + GeoSteu.myClosure(topScores, new Function<SimpleElement>(){

            @Override
            public String exec(SimpleElement se) {
                return se.getAttributeValue("name");
            }
        }).replaceAll(", ", "\n")));
        if (alterItem) {
            for (SimpleElement simpleElement : topScores) {
                item.addElement(simpleElement);
            }
        }
        return topScores;
    }

    public ArrayList<SimpleElement> runOnRSSItem(RSSItem item, boolean useText, int disambiguateLevel, boolean alterItem) {
        this.logger.debug((Object)("running on (" + disambiguateLevel + " " + useText + ")" + item.getTitle() + " : "));
        GeocodeMatchResult result = new GeocodeMatchResult(true);
        String tomatch = item.getTitle() + ". " + item.getDescription();
        if (useText && item.getText() != null) {
            tomatch = tomatch + item.getText();
        }
        matcher.match(tomatch, (MatchResult)result);
        this.logger.debug((Object)("Matcher results : " + GeoSteu.myClosure(result.getAllPlaces(), "getCleanName")));
        for (GeoResource resource : result.getAllPlaces()) {
            if (!resource.getCleanName().startsWith("Afg")) continue;
            this.logger.debug((Object)resource.position);
            this.logger.debug((Object)resource.wpos);
        }
        ArrayList<SimpleElement> topScores = this.disAmbiguateResult(result, item, tomatch, disambiguateLevel);
        this.logger.debug((Object)("After disAmbiguateResult : \n" + topScores.toString().replaceAll(", ", "\n")));
        if (alterItem) {
            for (SimpleElement element : topScores) {
                item.addElement(element);
            }
        }
        return topScores;
    }

    private boolean handleItemUpdate(GeocodeMatchResult result, RSSItem item, String tomatch) {
        Vector<SimpleElement> eresult = this.geodis.disAmbiguateResult(result, item, tomatch);
        this.logger.debug((Object)("RESULTSIZE : " + eresult.size()));
        boolean found = false;
        for (SimpleElement element : eresult) {
            item.addElement(element);
            this.logger.info((Object)("GeoMatcher found: guid: " + item.getGuid() + " " + element.getAttributeValue("name")));
            found = true;
        }
        this.logger.debug((Object)("FULLGEO size: " + this.geodis.getFullGeo().toString().replaceAll(", ", ",\n")));
        if (FULLGEO) {
            for (SimpleElement elem : this.geodis.getFullGeo()) {
                item.addElement(elem);
            }
        }
        this.logger.debug((Object)("ADJECTIVES size: " + result.getAdjectives(this.geodis.idmap, this.geodis.langmap.get(item.getLanguage())).toString().replaceAll(", ", ",\n")));
        if (USE_ADJECTIVES) {
            for (SimpleElement adj : result.getAdjectives(this.geodis.idmap, this.geodis.langmap.get(item.getLanguage()))) {
                item.addElement(adj);
            }
        }
        if (found) {
            this.logger.info((Object)"-");
        }
        return found;
    }

    private ArrayList<SimpleElement> disAmbiguateResult(GeocodeMatchResult result, RSSItem item, String tomatch, int level) {
        Vector<SimpleElement> eresult = this.geodis.disAmbiguateResult(result, item, tomatch, level);
        ArrayList<SimpleElement> topScores = new ArrayList<SimpleElement>(10);
        int max = 0;
        for (SimpleElement element : eresult) {
            long id = Long.parseLong(element.getAttributeValue("id"));
            int count = Integer.parseInt(element.getAttributeValue("count"));
            if (count > max) {
                max = count;
                topScores.clear();
                topScores.add(element);
                continue;
            }
            if (level <= 0 && count != max) continue;
            topScores.add(element);
        }
        return topScores;
    }

    public void end() {
        this.bRunning = false;
        this.interrupt();
    }

    public long[] getResetStats() {
        long[] retval = new long[2];
        retval[0] = this.processed;
        this.processed = 0L;
        retval[1] = this.fails;
        this.fails = 0L;
        return retval;
    }

    public GeoResource testMatcher(GeoResource res) {
        GeocodeMatchResult result = new GeocodeMatchResult();
        String tomatch = res.getCleanName();
        matcher.match(tomatch, (MatchResult)result);
        return result.getPlace(res.gid);
    }

    public void testGeoRSS(File filename, boolean useText) {
        try {
            BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(filename + "_places"));
            OutputStreamWriter wri = new OutputStreamWriter((OutputStream)bo, "UTF-8");
            BufferedOutputStream bo2 = new BufferedOutputStream(new FileOutputStream(filename + "_rest"));
            OutputStreamWriter wri2 = new OutputStreamWriter((OutputStream)bo2, "UTF-8");
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(filename));
            InputStreamReader reader = new InputStreamReader((InputStream)bi, "UTF-8");
            RSS rss = this.rssParser.parse((Reader)reader);
            Vector items = rss.getItems();
            int level = 1;
            this.runOnRSS(rss, useText, level);
            wri.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<items xmlns:emm=\"http://emm.jrc.it\">");
            wri2.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<items xmlns:emm=\"http://emm.jrc.it\">");
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            for (int i = 0; i < items.size(); ++i) {
                RSSItem item = (RSSItem)items.get(i);
                ArrayList elems = item.getElements("emm:georss");
                if (elems == null) continue;
                for (SimpleElement e : elems) {
                    if (e.getAttributeValue("name") == null) continue;
                    long id = 0L;
                    try {
                        id = Long.parseLong(e.getAttributeValue("id"));
                        OutputStreamWriter w = GeoUtils.isCountry((long)id) || GeoUtils.isRegion((long)id) ? wri : wri2;
                        ((Writer)w).append("<item>");
                        e.toXML((Writer)w);
                        ((Writer)w).append("<date>");
                        ((Writer)w).append(sdf.format(item.getDate())).append("</date>\n<name>");
                        ((Writer)w).append(e.getAttributeValue("name")).append("</name>\n<lat>");
                        ((Writer)w).append(e.getAttributeValue("lat")).append("</lat>\n<lon>");
                        ((Writer)w).append(e.getAttributeValue("lon")).append("</lon>\n<id>");
                        ((Writer)w).append(e.getAttributeValue("id")).append("</id>\n<guid>");
                        ((Writer)w).append(item.getGuid()).append("</guid><title>");
                        ((Writer)w).append(Utils.encodeXML((String)item.getTitle())).append("</title>\n<description>");
                        ((Writer)w).append(Utils.encodeXML((String)item.getDescription())).append("</description>\n</item>");
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)ex);
                        System.out.println(ex);
                    }
                }
            }
            wri.append("</items>");
            wri2.append("</items>");
            wri.flush();
            wri.close();
            wri2.flush();
            wri2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean debugEnabled() {
        return true;
    }

    static {
        DEFAULT = 0;
        COUNTRIES = 1;
        REGIONS = 2;
        PROVINCES = 3;
        CAPITALS = 4;
        MAJORCITIES = 5;
        CLASS3 = 6;
        CLASS4 = 7;
        CLASS5 = 8;
        CLASS6 = 9;
        USE_ADJECTIVES = true;
    }
}

